/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractTableReference;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyDeferrability;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schemacrawler.exceptions.NotLoadedException;

final class MutableForeignKey
extends AbstractTableReference
implements ForeignKey {
    private static final long serialVersionUID = 4121411795974895671L;
    private ForeignKeyDeferrability deferrability;
    private ForeignKeyUpdateRule deleteRule;
    private ForeignKeyUpdateRule updateRule = ForeignKeyUpdateRule.unknown;

    MutableForeignKey(String name, ColumnReference columnReference) {
        super(name, columnReference);
        this.deleteRule = ForeignKeyUpdateRule.unknown;
        this.deferrability = ForeignKeyDeferrability.unknown;
    }

    @Override
    public ForeignKeyDeferrability getDeferrability() {
        return this.deferrability;
    }

    @Override
    public ForeignKeyUpdateRule getDeleteRule() {
        return this.deleteRule;
    }

    @Override
    public TableConstraintType getType() {
        return TableConstraintType.foreign_key;
    }

    @Override
    public ForeignKeyUpdateRule getUpdateRule() {
        return this.updateRule;
    }

    @Override
    public boolean isDeferrable() {
        return this.isInitiallyDeferred();
    }

    @Override
    public boolean isInitiallyDeferred() {
        if (this.deferrability == null) {
            throw new NotLoadedException(this);
        }
        return this.deferrability == ForeignKeyDeferrability.initiallyDeferred;
    }

    void setDeferrability(ForeignKeyDeferrability deferrability) {
        this.deferrability = deferrability;
    }

    void setDeleteRule(ForeignKeyUpdateRule deleteRule) {
        this.deleteRule = deleteRule;
    }

    void setUpdateRule(ForeignKeyUpdateRule updateRule) {
        this.updateRule = updateRule;
    }
}

