/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.zlib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.JavaCompress;
import com.oracle.graal.python.builtins.modules.zlib.NativeZlibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibCompObject;
import com.oracle.graal.python.builtins.modules.zlib.ZLibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.zlib.ZlibCompressBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.zlib.ZlibCompressBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.zlib.ZlibNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.NFIZlibSupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ZlibCompress})
public final class ZlibCompressBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZlibCompressBuiltinsFactory.getFactories();
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1, parameterNames={"$self", "mode"})
    @ImportStatic(value={ZLibModuleBuiltins.class})
    @ArgumentClinic(name="mode", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="ZLibModuleBuiltins.Z_FINISH", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends PythonBinaryClinicBuiltinNode {
        FlushNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibCompressBuiltinsClinicProviders.FlushNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"mode == Z_NO_FLUSH"})
        static PBytes empty(ZLibCompObject self, int mode, @Bind PythonLanguage language) {
            return PFactory.createEmptyBytes(language);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"mode != Z_NO_FLUSH", "self.isInitialized()"})
        static PBytes doit(NativeZlibCompObject self, int mode, @Bind Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction compressObjFlush, @Cached ZlibNodes.GetNativeBufferNode getBuffer, @Cached NativeLibrary.InvokeNativeFunction getIsInitialised, @Cached ZlibNodes.NativeDeallocation processDeallocation, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                PythonContext context = PythonContext.get(inliningTarget);
                NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
                byte[] lastInput = self.lastInput == null ? PythonUtils.EMPTY_BYTE_ARRAY : self.lastInput;
                int err = zlibSupport.compressObjFlush(self.getZst(), lastInput, 16384L, mode, compressObjFlush);
                if (err != 0) {
                    errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
                }
                byte[] resultArray = getBuffer.getOutputBuffer(inliningTarget, self.getZst(), context);
                if (zlibSupport.getIsInitialised(self.getZst(), getIsInitialised) == 0) {
                    processDeallocation.execute(inliningTarget, self, context, true);
                }
                return PFactory.createBytes(context.getLanguage(inliningTarget), resultArray);
            }
        }

        @Specialization(guards={"mode != Z_NO_FLUSH", "self.isInitialized()"})
        static PBytes doit(JavaCompress self, int mode, @Bind PythonLanguage language) {
            return PFactory.createBytes(language, self.compress(mode));
        }

        @Specialization(guards={"!self.isInitialized()"})
        static PNone error(ZLibCompObject self, int mode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, -2, "while compressing data", "inconsistent stream state");
        }
    }

    @Builtin(name="__deepcopy__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DeepCopyNode
    extends PythonBinaryBuiltinNode {
        DeepCopyNode() {
        }

        @Specialization
        static Object doit(ZLibCompObject self, Object memo, @Bind Node inliningTarget, @Cached BaseCopyNode copyNode) {
            return copyNode.execute(inliningTarget, self);
        }
    }

    @Builtin(name="__copy__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class UndescoreCopyNode
    extends CopyNode {
        UndescoreCopyNode() {
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        CopyNode() {
        }

        @Specialization
        static Object doit(ZLibCompObject self, @Bind Node inliningTarget, @Cached BaseCopyNode copyNode) {
            return copyNode.execute(inliningTarget, self);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class BaseCopyNode
    extends PNodeWithContext {
        BaseCopyNode() {
        }

        public abstract Object execute(Node var1, ZLibCompObject var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"self.isInitialized()"})
        static Object doNative(Node inliningTarget, NativeZlibCompObject self, @Bind PythonContext context, @Cached(inline=false) NativeLibrary.InvokeNativeFunction createCompObject, @Cached(inline=false) NativeLibrary.InvokeNativeFunction compressObjCopy, @Cached(inline=false) NativeLibrary.InvokeNativeFunction deallocateStream, @Cached ZlibNodes.ZlibNativeErrorHandling errorHandling) {
            NativeZlibCompObject nativeZlibCompObject = self;
            synchronized (nativeZlibCompObject) {
                assert (self.isInitialized());
                NFIZlibSupport zlibSupport = context.getNFIZlibSupport();
                Object zstNewCopy = zlibSupport.createCompObject(createCompObject);
                int err = zlibSupport.compressObjCopy(self.getZst(), zstNewCopy, compressObjCopy);
                if (err != 0) {
                    zlibSupport.deallocateStream(zstNewCopy, deallocateStream);
                    errorHandling.execute(inliningTarget, self.getZst(), err, zlibSupport, false);
                }
                return PFactory.createNativeZLibCompObjectCompress(context.getLanguage(inliningTarget), zstNewCopy, zlibSupport);
            }
        }

        @Specialization(guards={"self.isInitialized()", "self.canCopy()"})
        static Object doJava(JavaCompress self) {
            return self.copy();
        }

        @Specialization(guards={"self.isInitialized()", "!self.canCopy()"})
        static PNone error(JavaCompress self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("JDK based zlib doesn't support copying"));
        }

        @Specialization(guards={"!self.isInitialized()"})
        static PNone error(ZLibCompObject self, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.ValueError, ErrorMessages.INCONSISTENT_STREAM_STATE);
        }
    }

    @Builtin(name="compress", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "data"})
    @ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class CompressNode
    extends PythonBinaryClinicBuiltinNode {
        CompressNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static PBytes compress(VirtualFrame frame, ZLibCompObject self, Object buffer, @Bind Node inliningTarget, @Bind PythonLanguage language, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached(value="createFor($node)") IndirectCallData indirectCallData, @Cached CompressInnerNode innerNode, @Cached PRaiseNode raiseNode) {
            try {
                if (!self.isInitialized()) {
                    throw raiseNode.raise(inliningTarget, PythonErrorType.ZLibError, ErrorMessages.ERROR_D_S_S, -2, "while compressing data", "inconsistent stream state");
                }
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                int len = bufferLib.getBufferLength(buffer);
                PBytes pBytes = PFactory.createBytes(language, innerNode.execute(inliningTarget, self, bytes, len));
                return pBytes;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ZlibCompressBuiltinsClinicProviders.CompressNodeClinicProviderGen.INSTANCE;
        }

        @GenerateInline
        @GenerateCached(value=false)
        static abstract class CompressInnerNode
        extends Node {
            CompressInnerNode() {
            }

            abstract byte[] execute(Node var1, Object var2, byte[] var3, int var4);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Specialization
            static byte[] doNative(Node inliningTarget, NativeZlibCompObject self, byte[] bytes, int length, @Cached ZlibNodes.ZlibNativeCompressObj compressObj) {
                NativeZlibCompObject nativeZlibCompObject = self;
                synchronized (nativeZlibCompObject) {
                    return compressObj.execute(inliningTarget, self, PythonContext.get(inliningTarget), bytes, length);
                }
            }

            @Specialization
            static byte[] doJava(JavaCompress self, byte[] bytes, int length) {
                self.setDeflaterInput(bytes, length);
                return self.compress(0);
            }
        }
    }
}

