/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.nfi.api;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=SignatureLibrary.class)
final class SignatureLibraryGen
extends LibraryFactory<SignatureLibrary> {
    private static final Class<SignatureLibrary> LIBRARY_CLASS = SignatureLibraryGen.lazyLibraryClass();
    private static final Message CALL = new MessageImpl("call", 0, false, Object.class, Object.class, Object.class, Object[].class);
    private static final Message BIND = new MessageImpl("bind", 1, false, Object.class, Object.class, Object.class);
    private static final Message CREATE_CLOSURE = new MessageImpl("createClosure", 2, false, Object.class, Object.class, Object.class);
    private static final SignatureLibraryGen INSTANCE = new SignatureLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private SignatureLibraryGen() {
        super(LIBRARY_CLASS, List.of(CALL, BIND, CREATE_CLOSURE));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return SignatureLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected SignatureLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected SignatureLibrary createDelegate(SignatureLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        SignatureLibrary lib = (SignatureLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.call(receiver, args[offset], (Object[])args[offset + 1]);
            }
            case 1: {
                return lib.bind(receiver, args[offset]);
            }
            case 2: {
                return lib.createClosure(receiver, args[offset]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected SignatureLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected SignatureLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<SignatureLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.nfi.api.SignatureLibrary", false, SignatureLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static final class Proxy
    extends SignatureLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            try {
                return this.lib.send(receiver_, CALL, new Object[]{functionPointer, args});
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object bind(Object receiver_, Object functionPointer) {
            try {
                return this.lib.send(receiver_, BIND, new Object[]{functionPointer});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object createClosure(Object receiver_, Object executable) {
            try {
                return this.lib.send(receiver_, CREATE_CLOSURE, new Object[]{executable});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static final class Delegate
    extends SignatureLibrary {
        @Node.Child
        private SignatureLibrary delegateLibrary;

        Delegate(SignatureLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (SignatureLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = SignatureLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((SignatureLibrary)SignatureLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).call(delegate, functionPointer, args);
            }
            return this.delegateLibrary.call(receiver_, functionPointer, args);
        }

        @Override
        public Object bind(Object receiver_, Object functionPointer) {
            if (SignatureLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = SignatureLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((SignatureLibrary)SignatureLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).bind(delegate, functionPointer);
            }
            return this.delegateLibrary.bind(receiver_, functionPointer);
        }

        @Override
        public Object createClosure(Object receiver_, Object executable) {
            if (SignatureLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = SignatureLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((SignatureLibrary)SignatureLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).createClosure(delegate, executable);
            }
            return this.delegateLibrary.createClosure(receiver_, executable);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(SignatureLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                SignatureLibrary exportLibrary = (SignatureLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (SignatureLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static abstract class CachedDispatch
    extends SignatureLibrary {
        @Node.Child
        SignatureLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(SignatureLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    SignatureLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.call(receiver_, functionPointer, args);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object bind(Object receiver_, Object functionPointer) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    SignatureLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.bind(receiver_, functionPointer);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object createClosure(Object receiver_, Object executable) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    SignatureLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.createClosure(receiver_, executable);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                SignatureLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (SignatureLibrary)this.insert((Node)((SignatureLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        SignatureLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (SignatureLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((SignatureLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends SignatureLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            return ((SignatureLibrary)INSTANCE.getUncached(receiver_)).call(receiver_, functionPointer, args);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object bind(Object receiver_, Object functionPointer) {
            return ((SignatureLibrary)INSTANCE.getUncached(receiver_)).bind(receiver_, functionPointer);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createClosure(Object receiver_, Object executable) {
            return ((SignatureLibrary)INSTANCE.getUncached(receiver_)).createClosure(receiver_, executable);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static final class Default
    extends LibraryExport<SignatureLibrary> {
        private Default() {
            super(SignatureLibrary.class, Object.class, false, false, 0);
        }

        protected SignatureLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected SignatureLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=SignatureLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends SignatureLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object receiver, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object bind(Object receiver, Object functionPointer) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object receiver, Object executable) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=SignatureLibrary.class)
        private static final class Cached
        extends SignatureLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object call(Object receiver, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object bind(Object receiver, Object functionPointer) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createClosure(Object receiver, Object executable) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(SignatureLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=SignatureLibrary.class)
    private static final class CachedToUncachedDispatch
    extends SignatureLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object call(Object receiver_, Object functionPointer, Object ... args) throws ArityException, UnsupportedTypeException, UnsupportedMessageException {
            assert (SignatureLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((SignatureLibrary)INSTANCE.getUncached(receiver_)).call(receiver_, functionPointer, args);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object bind(Object receiver_, Object functionPointer) {
            assert (SignatureLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((SignatureLibrary)INSTANCE.getUncached(receiver_)).bind(receiver_, functionPointer);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object createClosure(Object receiver_, Object executable) {
            assert (SignatureLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((SignatureLibrary)INSTANCE.getUncached(receiver_)).createClosure(receiver_, executable);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

