/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={PGuards.class})
public abstract class CastToJavaBooleanNode
extends PNodeWithContext {
    public abstract boolean execute(Node var1, Object var2) throws CannotCastException;

    public static boolean executeUncached(Object x) throws CannotCastException {
        return CastToJavaBooleanNodeGen.getUncached().execute(null, x);
    }

    @Specialization
    static boolean doBoolean(boolean x) {
        return x;
    }

    @Specialization
    static boolean doPInt(Node inliningTarget, PInt x, @Cached.Shared(value="dummy") @Cached InlinedConditionProfile isBoolean, @Cached.Shared @Cached(inline=false) IsSubtypeNode isSubtypeNode, @Cached.Shared @Cached GetClassNode getClassNode) {
        if (isBoolean.profile(inliningTarget, isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.Boolean))) {
            return !x.isZero();
        }
        throw CannotCastException.INSTANCE;
    }

    @Specialization
    @HostCompilerDirectives.InliningCutoff
    static boolean doNativeObject(Node inliningTarget, PythonNativeObject x, @Cached.Shared(value="dummy") @Cached InlinedConditionProfile isBoolean, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached(inline=false) IsSubtypeNode isSubtypeNode) {
        if (isSubtypeNode.execute(getClassNode.execute(inliningTarget, x), (Object)PythonBuiltinClassType.Boolean)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.NotImplementedError, ErrorMessages.CASTING_A_NATIVE_INT_OBJECT_IS_NOT_IMPLEMENTED_YET);
        }
        throw CannotCastException.INSTANCE;
    }

    @Fallback
    static boolean doUnsupported(Object x) {
        throw CannotCastException.INSTANCE;
    }
}

