/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.referencetype;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class PReferenceType
extends PythonBuiltinObject {
    private WeakRefStorage store;
    private long hash = -1L;

    @CompilerDirectives.TruffleBoundary
    public PReferenceType(Object cls, Shape instanceShape, Object pythonObject, Object callback, ReferenceQueue<Object> queue) {
        super(cls, instanceShape);
        this.store = new WeakRefStorage(this, pythonObject, callback, queue);
    }

    public void clearRef() {
        WeakRefStorage s = this.store;
        if (s != null) {
            s.callback = null;
            this.store = null;
        }
    }

    public Object getCallback() {
        Object callback = null;
        WeakRefStorage s = this.store;
        if (s != null) {
            callback = s.callback;
        }
        if (callback == null) {
            return PNone.NONE;
        }
        return callback;
    }

    @CompilerDirectives.TruffleBoundary
    public Object getObject() {
        WeakRefStorage s = this.store;
        if (s != null) {
            return s.get();
        }
        return null;
    }

    public Object getPyObject() {
        Object object = this.getObject();
        return object == null ? PNone.NONE : object;
    }

    public int getWeakRefCount() {
        return this.getObject() == null ? 0 : 1;
    }

    public long getHash() {
        return this.hash;
    }

    public void setHash(long hash) {
        this.hash = hash;
    }

    public static class WeakRefStorage
    extends WeakReference<Object> {
        private Object callback;
        private final PReferenceType ref;
        private final long pointer;

        public WeakRefStorage(PReferenceType ref, Object referent, Object callback, ReferenceQueue<Object> queue) {
            super(referent, queue);
            this.callback = callback;
            this.ref = ref;
            this.pointer = CApiTransitions.getNativePointer(referent);
        }

        public Object getCallback() {
            return this.callback;
        }

        public PReferenceType getRef() {
            return this.ref;
        }

        public long getPointer() {
            return this.pointer;
        }
    }
}

