/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

public abstract class JSClass {
    protected JSClass() {
    }

    @CompilerDirectives.TruffleBoundary
    public abstract JSDynamicObject getPrototypeOf(JSDynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean setPrototypeOf(JSDynamicObject var1, JSDynamicObject var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean isExtensible(JSDynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean preventExtensions(JSDynamicObject var1, boolean var2);

    @CompilerDirectives.TruffleBoundary
    public abstract PropertyDescriptor getOwnProperty(JSDynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean defineOwnProperty(JSDynamicObject var1, Object var2, PropertyDescriptor var3, boolean var4);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasProperty(JSDynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasProperty(JSDynamicObject var1, long var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOwnProperty(JSDynamicObject var1, Object var2);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOwnProperty(JSDynamicObject var1, long var2);

    public final Object get(JSDynamicObject thisObj, Object key) {
        Object value = this.getHelper(thisObj, (Object)thisObj, key, null);
        assert (!(value instanceof String));
        return JSRuntime.nullToUndefined(value);
    }

    public Object get(JSDynamicObject thisObj, long index) {
        Object value = this.getHelper(thisObj, (Object)thisObj, index, (Node)null);
        assert (!(value instanceof String));
        return JSRuntime.nullToUndefined(value);
    }

    @CompilerDirectives.TruffleBoundary
    public abstract Object getHelper(JSDynamicObject var1, Object var2, Object var3, Node var4);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getHelper(JSDynamicObject var1, Object var2, long var3, Node var5);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getOwnHelper(JSDynamicObject var1, Object var2, Object var3, Node var4);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getOwnHelper(JSDynamicObject var1, Object var2, long var3, Node var5);

    @CompilerDirectives.TruffleBoundary
    public abstract Object getMethodHelper(JSDynamicObject var1, Object var2, Object var3, Node var4);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean set(JSDynamicObject var1, Object var2, Object var3, Object var4, boolean var5, Node var6);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean set(JSDynamicObject var1, long var2, Object var4, Object var5, boolean var6, Node var7);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean delete(JSDynamicObject var1, Object var2, boolean var3);

    @CompilerDirectives.TruffleBoundary
    public abstract boolean delete(JSDynamicObject var1, long var2, boolean var4);

    public final List<Object> ownPropertyKeys(JSDynamicObject obj) {
        return this.getOwnPropertyKeys(obj, true, true);
    }

    @CompilerDirectives.TruffleBoundary
    public abstract List<Object> getOwnPropertyKeys(JSDynamicObject var1, boolean var2, boolean var3);

    @CompilerDirectives.TruffleBoundary
    public static List<Object> filterOwnPropertyKeys(List<Object> ownPropertyKeys, boolean strings, boolean symbols) {
        if (strings && symbols) {
            return ownPropertyKeys;
        }
        ArrayList<Object> names = new ArrayList<Object>();
        for (Object key : ownPropertyKeys) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof TruffleString) continue;
            names.add(key);
        }
        return names;
    }

    @CompilerDirectives.TruffleBoundary
    public abstract boolean hasOnlyShapeProperties(JSDynamicObject var1);

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.getClass().getSimpleName();
    }

    public final boolean isInstance(JSDynamicObject object) {
        return JSClass.isInstance(object, this);
    }

    public final boolean isInstance(Object object) {
        return JSClass.isInstance(object, this);
    }

    public static boolean isInstance(Object object, JSClass jsclass) {
        return JSDynamicObject.isJSDynamicObject(object) && JSClass.isInstance((JSDynamicObject)((Object)object), jsclass);
    }

    public static boolean isInstance(JSDynamicObject object, JSClass jsclass) {
        return object.getShape().getDynamicType() == jsclass;
    }

    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        throw Errors.shouldNotReachHere(this.getClass().getName());
    }

    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        throw Errors.shouldNotReachHere(this.getClass().getName());
    }

    @Idempotent
    public abstract boolean usesOrdinaryGetOwnProperty();

    @Idempotent
    public abstract boolean usesOrdinaryIsExtensible();
}

