/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.ActionOrientationType;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ConditionTimingType;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.DatabaseInfo;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.DefinedObject;
import schemacrawler.schema.DescribedObject;
import schemacrawler.schema.EventManipulationType;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.ForeignKeyUpdateRule;
import schemacrawler.schema.Grant;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Privilege;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineParameter;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintColumn;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.Trigger;
import schemacrawler.schema.View;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.HideDependantDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.BaseTabularFormatter;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.ObjectToString;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.property.Property;
import us.fatehi.utility.string.StringFormat;

public final class SchemaTextFormatter
extends BaseTabularFormatter<SchemaTextOptions>
implements SchemaTraversalHandler {
    private static final Logger LOGGER = Logger.getLogger(SchemaTextFormatter.class.getName());
    private static final String SPACE = " ";

    private static String negate(boolean positive, String text) {
        Object textValue = text;
        if (!positive) {
            textValue = "not " + (String)textValue;
        }
        return textValue;
    }

    public SchemaTextFormatter(SchemaTextDetailType schemaTextDetailType, SchemaTextOptions options, OutputOptions outputOptions, Identifiers identifiers) {
        super(schemaTextDetailType, options, outputOptions, identifiers);
    }

    @Override
    public void handle(ColumnDataType columnDataType) {
        if (this.printVerboseDatabaseInfo() && this.isVerbose()) {
            this.formattingHelper.writeObjectStart();
            this.printColumnDataType(columnDataType);
            this.formattingHelper.writeObjectEnd();
        }
    }

    @Override
    public void handle(Routine routine) {
        if (routine == null || ((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideRoutines)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing routine <%s>", routine));
            return;
        }
        String routineTypeDetail = "%s, %s".formatted(new Object[]{routine.getRoutineType(), routine.getReturnType()});
        String routineName = this.quoteName(routine);
        String routineType = "[" + routineTypeDetail + "]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId(routine), routineName, routineType, this.colorMap.getColor(routine));
        this.printRemarks(routine);
        if (!this.isBrief()) {
            this.printRoutineParameters(routine.getParameters());
        }
        if (this.isVerbose()) {
            if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideRoutineSpecificNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing routine specific name for <%s>", routine));
                String specificName = routine.getSpecificName();
                if (!Utility.isBlank(specificName) && !routine.getName().equals(specificName)) {
                    this.formattingHelper.writeEmptyRow();
                    this.formattingHelper.writeNameRow("", "[specific name]");
                    this.formattingHelper.writeWideRow(this.identifiers.quoteName(specificName), "");
                }
            }
            this.printRoutineReferences(routine);
            this.printDefinition(routine);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(Sequence sequence) {
        String sequenceName = this.quoteName(sequence);
        String sequenceType = "[sequence]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId(sequence), sequenceName, "[sequence]", this.colorMap.getColor(sequence));
        this.printRemarks(sequence);
        if (!this.isBrief()) {
            this.formattingHelper.writeDetailRow("", "increment", String.valueOf(sequence.getIncrement()));
            this.formattingHelper.writeDetailRow("", "start value", Objects.toString(sequence.getStartValue(), ""));
            this.formattingHelper.writeDetailRow("", "minimum value", Objects.toString(sequence.getMinimumValue(), ""));
            this.formattingHelper.writeDetailRow("", "maximum value", Objects.toString(sequence.getMaximumValue(), ""));
            this.formattingHelper.writeDetailRow("", "cycle", String.valueOf(sequence.isCycle()));
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(Synonym synonym) {
        if (synonym == null || ((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSynonyms)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing synonym <%s>", synonym));
            return;
        }
        String synonymName = this.quoteName(synonym);
        String synonymType = "[synonym]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId(synonym), synonymName, "[synonym]", this.colorMap.getColor(synonym));
        this.printRemarks(synonym);
        if (!this.isBrief()) {
            String referencedObjectName = this.quoteName(synonym.getReferencedObject());
            this.formattingHelper.writeDetailRow("", "%s %s %s".formatted(this.identifiers.quoteName(synonym), this.formattingHelper.createRightArrow(), referencedObjectName), "");
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handle(Table table) {
        if (table == null || ((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideTables)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing table <%s>", table));
            return;
        }
        String tableName = this.quoteName(table);
        String tableType = "[" + String.valueOf(table.getTableType()) + "]";
        this.formattingHelper.println();
        this.formattingHelper.println();
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeObjectNameRow(this.nodeId(table), tableName, tableType, this.colorMap.getColor(table));
        this.printRemarks(table);
        if (!((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideTableColumns)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing table columns for <%s>", table));
            this.printTableColumns(table.getColumns(), true);
            if (this.isVerbose()) {
                this.printTableColumns(new ArrayList<Column>(table.getHiddenColumns()), true);
            }
        }
        this.printPrimaryKey(table.getPrimaryKey());
        this.printForeignKeys(table);
        if (!this.isBrief()) {
            this.printAlternateKeys(table);
            this.printWeakAssociations(table);
            this.printIndexes(table.getIndexes());
            this.printTriggers(table.getTriggers());
            this.printTableConstraints(table.getTableConstraints());
            if (this.isVerbose()) {
                this.printDefinition(table);
                this.printViewTableUsage(table);
                this.printTableUsedByObjects(table);
                this.printPrivileges(table.getPrivileges());
            }
            this.printTableRowCount(table);
        }
        this.formattingHelper.writeObjectEnd();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
        if (this.printVerboseDatabaseInfo() && this.isVerbose()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Data Types");
        }
    }

    @Override
    public void handleInfo(DatabaseInfo dbInfo) {
        if (!this.printVerboseDatabaseInfo() || !((SchemaTextOptions)this.options).isShowDatabaseInfo() || dbInfo == null) {
            return;
        }
        Collection<Property> serverInfo = dbInfo.getServerInfo();
        if (!serverInfo.isEmpty()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Server Information");
            this.formattingHelper.writeObjectStart();
            for (Property property : serverInfo) {
                String name = property.getName();
                Object value = property.getValue();
                this.formattingHelper.writeNameValueRow(name, ObjectToString.listOrObjectToString(value), Alignment.inherit);
            }
            this.formattingHelper.writeObjectEnd();
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("database product name", dbInfo.getProductName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database product version", dbInfo.getProductVersion(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("database user name", dbInfo.getUserName(), Alignment.inherit);
        this.formattingHelper.writeObjectEnd();
        Collection<Property> dbProperties = dbInfo.getProperties();
        if (!dbProperties.isEmpty()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "Database Characteristics");
            this.formattingHelper.writeObjectStart();
            for (Property property : dbProperties) {
                String name = property.getDescription();
                Object value = property.getValue();
                this.formattingHelper.writeNameValueRow(name, ObjectToString.listOrObjectToString(value), Alignment.inherit);
            }
            this.formattingHelper.writeObjectEnd();
        }
    }

    @Override
    public void handleInfo(JdbcDriverInfo driverInfo) {
        Collection<JdbcDriverProperty> jdbcDriverProperties;
        if (!this.printVerboseDatabaseInfo() || !((SchemaTextOptions)this.options).isShowJdbcDriverInfo() || driverInfo == null) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Information");
        this.formattingHelper.writeObjectStart();
        this.formattingHelper.writeNameValueRow("connection url", driverInfo.getConnectionUrl(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver name", driverInfo.getProductName(), Alignment.inherit);
        this.formattingHelper.writeNameValueRow("driver version", driverInfo.getProductVersion(), Alignment.inherit);
        if (driverInfo.hasDriverClassName()) {
            this.formattingHelper.writeNameValueRow("driver class name", driverInfo.getDriverClassName(), Alignment.inherit);
            this.formattingHelper.writeNameValueRow("is JDBC compliant", Boolean.toString(driverInfo.isJdbcCompliant()), Alignment.inherit);
            this.formattingHelper.writeNameValueRow("supported JDBC version", "%d.%d".formatted(driverInfo.getJdbcMajorVersion(), driverInfo.getJdbcMinorVersion()), Alignment.inherit);
        }
        this.formattingHelper.writeObjectEnd();
        if (driverInfo.hasDriverClassName() && !(jdbcDriverProperties = driverInfo.getDriverProperties()).isEmpty()) {
            this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.section, "JDBC Driver Properties");
            for (JdbcDriverProperty driverProperty : jdbcDriverProperties) {
                this.formattingHelper.writeObjectStart();
                this.printJdbcDriverProperty(driverProperty);
                this.formattingHelper.writeObjectEnd();
            }
        }
    }

    @Override
    public void handleInfoEnd() {
    }

    @Override
    public void handleInfoStart() {
        if (!this.printVerboseDatabaseInfo() || ((SchemaTextOptions)this.options).isNoInfo() || !((SchemaTextOptions)this.options).isShowDatabaseInfo() && !((SchemaTextOptions)this.options).isShowJdbcDriverInfo()) {
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "System Information");
    }

    @Override
    public void handleRoutinesEnd() {
    }

    @Override
    public void handleRoutinesStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideRoutines)) {
            LOGGER.log(Level.FINER, "Not showing routines");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Routines");
    }

    @Override
    public void handleSequencesEnd() {
    }

    @Override
    public void handleSequencesStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSequences)) {
            LOGGER.log(Level.FINER, "Not showing sequences");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Sequences");
    }

    @Override
    public void handleSynonymsEnd() {
    }

    @Override
    public void handleSynonymsStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideSynonyms)) {
            LOGGER.log(Level.FINER, "Not showing synonyms");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Synonyms");
    }

    @Override
    public void handleTablesEnd() {
    }

    @Override
    public void handleTablesStart() {
        if (((SchemaTextOptions)this.options).is(HideDatabaseObjectsType.hideTables)) {
            LOGGER.log(Level.FINER, "Not showing tables");
            return;
        }
        this.formattingHelper.writeHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Tables");
    }

    private List<TableConstraint> filterPrintableConstraints(Collection<TableConstraint> constraintsCollection) {
        EnumSet<TableConstraintType> printableConstraints = EnumSet.of(TableConstraintType.check, TableConstraintType.unique);
        ArrayList<TableConstraint> constraints = new ArrayList<TableConstraint>();
        for (TableConstraint constraint : constraintsCollection) {
            List<TableConstraintColumn> constrainedColumns = constraint.getConstrainedColumns();
            boolean hasNoNameOrColumns = ((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideTableConstraintNames) && constrainedColumns.isEmpty() && !constraint.hasRemarks();
            boolean isNotPkOrFk = printableConstraints.contains(constraint.getType());
            if (hasNoNameOrColumns || !isNotPkOrFk) continue;
            constraints.add(constraint);
        }
        return constraints;
    }

    private String makeFkRuleString(ForeignKey foreignKey) {
        Object updateRuleString = "";
        ForeignKeyUpdateRule updateRule = foreignKey.getUpdateRule();
        if (updateRule != null && updateRule != ForeignKeyUpdateRule.unknown) {
            updateRuleString = ", on update " + updateRule.toString();
        }
        Object deleteRuleString = "";
        ForeignKeyUpdateRule deleteRule = foreignKey.getDeleteRule();
        if (deleteRule != null && deleteRule != ForeignKeyUpdateRule.unknown) {
            deleteRuleString = ", on delete " + deleteRule.toString();
        }
        String ruleString = deleteRule != null && updateRule == deleteRule && updateRule != ForeignKeyUpdateRule.unknown ? ", with " + deleteRule.toString() : (String)updateRuleString + (String)deleteRuleString;
        return ruleString;
    }

    private void printAlternateKeys(Table table) {
        if (table == null || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideAlternateKeys)) {
            LOGGER.log(Level.FINER, "Not showing alternate keys");
            return;
        }
        Collection<PrimaryKey> alternateKeys = table.getAlternateKeys();
        if (alternateKeys == null || alternateKeys.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Alternate Keys", "section");
        this.formattingHelper.writeEmptyRow();
        for (TableConstraint tableConstraint : alternateKeys) {
            String akName;
            String name = this.identifiers.quoteName(tableConstraint);
            if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideAlternateKeyNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing alternate key names for <%s>", table));
                akName = name;
            } else {
                akName = "";
            }
            String type = ((TableConstraintType)((Object)tableConstraint.getType())).getValue().toLowerCase();
            this.formattingHelper.writeNameRow(akName, "[" + type + "]");
            this.printRemarks(tableConstraint);
            this.printTableColumns(tableConstraint.getConstrainedColumns(), false);
        }
    }

    private void printColumnDataType(ColumnDataType columnDataType) {
        boolean isUserDefined = columnDataType.getType() == DataTypeType.user_defined;
        String dataType = "[%sdata type]".formatted(isUserDefined ? "user defined " : "");
        String typeName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? columnDataType.getName() : columnDataType.getFullName();
        if (Utility.isBlank(typeName)) {
            return;
        }
        String nullable = SchemaTextFormatter.negate(columnDataType.isNullable(), "nullable");
        String autoIncrementable = SchemaTextFormatter.negate(columnDataType.isAutoIncrementable(), "auto-incrementable");
        String createParameters = columnDataType.getCreateParameters();
        String definedWith = "defined with " + (Utility.isBlank(createParameters) ? "no parameters" : createParameters);
        this.formattingHelper.writeNameRow(typeName, dataType);
        this.formattingHelper.writeDescriptionRow(definedWith);
        this.formattingHelper.writeDescriptionRow(nullable);
        this.formattingHelper.writeDescriptionRow(autoIncrementable);
        this.formattingHelper.writeDescriptionRow(columnDataType.getSearchable().toString());
        if (isUserDefined) {
            ColumnDataType baseColumnDataType = columnDataType.getBaseType();
            String baseTypeName = baseColumnDataType == null ? "" : (((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? baseColumnDataType.getName() : baseColumnDataType.getFullName());
            this.formattingHelper.writeDetailRow("", "based on", baseTypeName);
            String remarks = columnDataType.getRemarks();
            if (!Utility.isBlank(remarks)) {
                this.formattingHelper.writeDetailRow("", "remarks", remarks);
            }
        }
    }

    private void printColumnReferences(boolean isForeignKey, Table table, TableReference foreignKey) {
        MetaDataUtility.ForeignKeyCardinality fkCardinality = MetaDataUtility.findForeignKeyCardinality(foreignKey);
        for (ColumnReference columnRef : foreignKey) {
            String relationship;
            String pkColumnName;
            Column pkColumn = columnRef.getPrimaryKeyColumn();
            Column fkColumn = columnRef.getForeignKeyColumn();
            Table referencedTable = (Table)columnRef.getPrimaryKeyColumn().getParent();
            Table dependentTable = (Table)columnRef.getForeignKeyColumn().getParent();
            boolean isPkColumnFiltered = this.isTableFiltered(referencedTable);
            boolean isFkColumnFiltered = this.isTableFiltered(dependentTable);
            boolean isIncoming = false;
            if (referencedTable.equals(table)) {
                pkColumnName = this.identifiers.quoteName(pkColumn);
                isIncoming = true;
            } else {
                pkColumnName = ((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName(pkColumn) : this.identifiers.quoteFullName(pkColumn);
            }
            String fkColumnName = dependentTable.equals(table) ? this.identifiers.quoteName(fkColumn) : (((SchemaTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName(fkColumn) : this.identifiers.quoteFullName(fkColumn));
            String keySequenceString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                int keySequence = columnRef.getKeySequence();
                keySequenceString = "%2d".formatted(keySequence);
            }
            if (isIncoming) {
                String fkHyperlink = isFkColumnFiltered ? fkColumnName : this.formattingHelper.createAnchor(fkColumnName, "#" + this.nodeId(dependentTable));
                arrow = isForeignKey ? this.formattingHelper.createLeftArrow() : this.formattingHelper.createWeakLeftArrow();
                relationship = "%s %s%s %s".formatted(pkColumnName, arrow, fkCardinality.toString(), fkHyperlink);
            } else {
                String pkHyperlink = isPkColumnFiltered ? pkColumnName : this.formattingHelper.createAnchor(pkColumnName, "#" + this.nodeId(referencedTable));
                arrow = isForeignKey ? this.formattingHelper.createRightArrow() : this.formattingHelper.createWeakRightArrow();
                relationship = "%s %s%s %s".formatted(fkColumnName, fkCardinality.toString(), arrow, pkHyperlink);
            }
            this.formattingHelper.writeDetailRow(keySequenceString, relationship, "", false, false, "");
        }
    }

    private void printDefinition(DefinedObject definedObject) {
        if (definedObject == null || !definedObject.hasDefinition() || !this.isVerbose()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Definition", "section");
        this.formattingHelper.writeNameRow("", "[definition]");
        this.formattingHelper.writeWideRow(definedObject.getDefinition(), "definition");
    }

    private void printDependantObjectDefinition(DefinedObject definedObject) {
        if (definedObject == null || !definedObject.hasDefinition() || !this.isVerbose()) {
            return;
        }
        this.formattingHelper.writeWideRow(definedObject.getDefinition(), "definition");
    }

    private void printForeignKeys(Table table) {
        if (table == null || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideForeignKeys)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing foreign keys for <%s>", table));
            return;
        }
        Collection<ForeignKey> foreignKeysCollection = table.getForeignKeys();
        if (foreignKeysCollection.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Foreign Keys", "section");
        ArrayList<ForeignKey> foreignKeys = new ArrayList<ForeignKey>(foreignKeysCollection);
        Collections.sort(foreignKeys, NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.options).isAlphabeticalSortForForeignKeys()));
        for (ForeignKey foreignKey : foreignKeys) {
            if (foreignKey == null) continue;
            String name = this.identifiers.quoteName(foreignKey);
            String ruleString = this.makeFkRuleString(foreignKey);
            this.formattingHelper.writeEmptyRow();
            String fkName = "";
            if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideForeignKeyNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing foreign key names for <%s>", table));
                fkName = name;
            }
            String fkDetails = "[foreign key" + ruleString + "]";
            this.formattingHelper.writeNameRow(fkName, fkDetails);
            this.printRemarks(foreignKey);
            this.printColumnReferences(true, table, foreignKey);
            this.printDependantObjectDefinition(foreignKey);
        }
    }

    private void printIndexes(Collection<Index> indexesCollection) {
        if (indexesCollection.isEmpty() || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideIndexes)) {
            LOGGER.log(Level.FINER, "Not showing indexes");
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Indexes", "section");
        ArrayList<Index> indexes = new ArrayList<Index>(indexesCollection);
        Collections.sort(indexes, NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
        for (Index index : indexes) {
            if (index == null) continue;
            this.formattingHelper.writeEmptyRow();
            String indexName = "";
            if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideIndexNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing index names for <%s>", index));
                indexName = this.identifiers.quoteName(index);
            }
            IndexType indexType = index.getIndexType();
            Object indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + SPACE;
            }
            String indexDetails = "[" + (index.isUnique() ? "" : "non-") + "unique " + (String)indexTypeString + "index]";
            this.formattingHelper.writeNameRow(indexName, indexDetails);
            this.printRemarks(index);
            if (!this.isBrief()) {
                this.printTableColumns(index.getColumns(), false);
            }
            this.printDependantObjectDefinition(index);
            if (!index.hasFilterCondition()) continue;
            this.formattingHelper.writeNameRow("", "[filter condition]");
            this.formattingHelper.writeWideRow(index.getFilterCondition(), "definition");
        }
    }

    private void printJdbcDriverProperty(JdbcDriverProperty driverProperty) {
        String required = (driverProperty.isRequired() ? "" : "not ") + "required";
        StringBuilder details = new StringBuilder();
        details.append(required);
        if (driverProperty.getChoices() != null && !driverProperty.getChoices().isEmpty()) {
            details.append("; choices ").append(driverProperty.getChoices());
        }
        String value = driverProperty.getValue();
        this.formattingHelper.writeNameRow(driverProperty.getName(), "[driver property]");
        this.formattingHelper.writeDescriptionRow(driverProperty.getDescription());
        this.formattingHelper.writeDescriptionRow(details.toString());
        this.formattingHelper.writeDetailRow("", "value", ObjectToString.listOrObjectToString(value));
    }

    private void printPrimaryKey(PrimaryKey primaryKey) {
        if (primaryKey == null || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hidePrimaryKeys)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing primary key <%s>", primaryKey));
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Primary Key", "section");
        this.formattingHelper.writeEmptyRow();
        String name = this.identifiers.quoteName(primaryKey);
        String pkName = "";
        if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hidePrimaryKeyNames)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing primary key name for <%s>", primaryKey));
            pkName = name;
        }
        pkName = Utility.trimToEmpty(pkName);
        this.formattingHelper.writeNameRow(pkName, "[primary key]");
        this.printRemarks(primaryKey);
        this.printTableColumns(primaryKey.getConstrainedColumns(), false);
        this.printDependantObjectDefinition(primaryKey);
    }

    private void printPrivileges(Collection<Privilege<Table>> privileges) {
        if (privileges.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Privileges and Grants", "section");
        for (Privilege<Table> privilege : privileges) {
            if (privilege == null) continue;
            String privilegeName = privilege.getName();
            if (Utility.isBlank(privilegeName)) {
                privilegeName = "";
            }
            this.formattingHelper.writeEmptyRow();
            this.formattingHelper.writeNameRow(privilegeName, "[privilege]");
            for (Grant<Table> grant : privilege.getGrants()) {
                String grantor = Utility.isBlank(grant.getGrantor()) ? "" : grant.getGrantor();
                String grantee = Utility.isBlank(grant.getGrantee()) ? "" : grant.getGrantee();
                String grantedFrom = "%s %s %s%s".formatted(grantor, this.formattingHelper.createRightArrow(), grantee, grant.isGrantable() ? " (grantable)" : "");
                this.formattingHelper.writeDetailRow("", grantedFrom, "");
            }
        }
    }

    private void printRemarks(DescribedObject object) {
        if (object == null || !object.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeWideRow(object.getRemarks(), "remarks");
    }

    private void printRoutineParameters(List<? extends RoutineParameter<?>> parameters) {
        if (parameters.isEmpty() || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideRoutineParameters)) {
            LOGGER.log(Level.FINER, "Not showing routine parameters");
            return;
        }
        parameters.sort(NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.options).isAlphabeticalSortForRoutineParameters()));
        for (RoutineParameter<?> parameter : parameters) {
            String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? parameter.getColumnDataType().getStandardTypeName() : parameter.getColumnDataType().getDatabaseSpecificTypeName();
            StringBuilder columnType = new StringBuilder(64);
            columnType.append(columnTypeName).append(parameter.getWidth());
            if (parameter.getParameterMode() != null) {
                columnType.append(", ").append(parameter.getParameterMode().toString());
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(parameter.getOrdinalPosition() + 1);
            }
            this.formattingHelper.writeDetailRow(ordinalNumberString, this.identifiers.quoteName(parameter), columnType.toString());
        }
    }

    private void printRoutineReferences(Routine routine) {
        if (routine == null) {
            return;
        }
        Collection<? extends DatabaseObject> references = routine.getReferencedObjects();
        if (references.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("References", "section");
        this.formattingHelper.writeEmptyRow();
        for (DatabaseObject databaseObject : references) {
            String objectName = this.quoteName(databaseObject);
            String objectType = "[" + MetaDataUtility.getTypeName(databaseObject).toLowerCase() + "]";
            this.formattingHelper.writeNameRow(objectName, objectType);
        }
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isAutoIncremented()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "auto-incremented");
    }

    private void printTableColumnDefaultValue(Column column) {
        if (column == null || !column.hasDefaultValue()) {
            return;
        }
        String defaultValue = column.getDefaultValue();
        if ("NULL".equalsIgnoreCase(defaultValue)) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "default " + defaultValue);
    }

    private void printTableColumnEnumValues(Column column) {
        if (column == null || !column.isColumnDataTypeKnown() || !column.getColumnDataType().isEnumerated()) {
            return;
        }
        String enumValues = "'%s'".formatted(String.join((CharSequence)"', ", column.getColumnDataType().getEnumValues()));
        this.formattingHelper.writeDetailRow("", "", enumValues);
    }

    private void printTableColumnGenerated(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isGenerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "generated");
    }

    private void printTableColumnHidden(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isHidden()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", "hidden");
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks() || ((SchemaTextOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.writeDetailRow("", "", column.getRemarks(), true, false, "remarks");
    }

    private void printTableColumns(List<? extends Column> columns, boolean extraDetails) {
        if (columns.isEmpty()) {
            return;
        }
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            Object columnDetails;
            if (!this.isColumnSignificant(column)) continue;
            String columnName = this.identifiers.quoteName(column);
            boolean emphasize = false;
            if (column instanceof IndexColumn) {
                IndexColumn indexColumn = (IndexColumn)column;
                columnDetails = indexColumn.getSortSequence().name();
            } else if (column instanceof TableConstraintColumn) {
                columnDetails = "";
            } else {
                String columnTypeName = ((SchemaTextOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getStandardTypeName() : column.getColumnDataType().getDatabaseSpecificTypeName();
                String columnType = columnTypeName + column.getWidth();
                String nullable = this.columnNullable(columnTypeName, column.isNullable());
                columnDetails = columnType + nullable;
                emphasize = column.isPartOfPrimaryKey();
            }
            String ordinalNumberString = "";
            if (((SchemaTextOptions)this.options).isShowOrdinalNumbers()) {
                ordinalNumberString = String.valueOf(column.getOrdinalPosition());
            }
            this.formattingHelper.writeDetailRow(ordinalNumberString, columnName, (String)columnDetails, true, emphasize, "");
            if (!extraDetails) continue;
            this.printTableColumnDefaultValue(column);
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnGenerated(column);
            this.printTableColumnEnumValues(column);
            this.printTableColumnHidden(column);
            this.printTableColumnRemarks(column);
            if (!(column instanceof DefinedObject)) continue;
            DefinedObject object = (DefinedObject)((Object)column);
            this.printDependantObjectDefinition(object);
        }
    }

    private void printTableConstraints(Collection<TableConstraint> constraintsCollection) {
        if (((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideTableConstraints)) {
            LOGGER.log(Level.FINER, "Not showing table constraints");
            return;
        }
        List<TableConstraint> constraints = this.filterPrintableConstraints(constraintsCollection);
        if (constraints.isEmpty()) {
            return;
        }
        Collections.sort(constraints, NamedObjectSort.getNamedObjectSort(((SchemaTextOptions)this.options).isAlphabeticalSortForIndexes()));
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Table Constraints", "section");
        for (TableConstraint constraint : constraints) {
            String constraintName;
            if (constraint == null) continue;
            if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideTableConstraintNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing table constraint name for <%s>", constraint));
                constraintName = this.identifiers.quoteName(constraint);
            } else {
                constraintName = "";
            }
            String constraintType = ((TableConstraintType)((Object)constraint.getType())).getValue().toLowerCase();
            String constraintDetails = "[" + constraintType + " constraint]";
            this.formattingHelper.writeEmptyRow();
            this.formattingHelper.writeNameRow(constraintName, constraintDetails);
            this.printRemarks(constraint);
            if (!this.isBrief()) {
                List<TableConstraintColumn> constrainedColumns = constraint.getConstrainedColumns();
                this.printTableColumns(constrainedColumns, false);
            }
            this.printDependantObjectDefinition(constraint);
        }
    }

    private void printTableUsedByObjects(Table table) {
        if (table == null) {
            return;
        }
        Collection<DatabaseObject> usedByObjects = table.getUsedByObjects();
        if (usedByObjects.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Used By Objects", "section");
        this.formattingHelper.writeEmptyRow();
        for (DatabaseObject referencingObject : usedByObjects) {
            String objectName = this.quoteName(referencingObject);
            String objectType = "[" + MetaDataUtility.getTypeName(referencingObject).toLowerCase() + "]";
            this.formattingHelper.writeNameRow(objectName, objectType);
        }
    }

    private void printTableRowCount(Table table) {
        if (((SchemaTextOptions)this.options).isHideTableRowCounts() || !TableRowCountsUtility.hasRowCount(table)) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Additional Information", "section");
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeNameRow(TableRowCountsUtility.getRowCountMessage(table), "[row count]");
    }

    private void printTriggers(Collection<Trigger> triggers) {
        if (triggers.isEmpty() || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideTriggers)) {
            LOGGER.log(Level.FINER, "Not showing triggers");
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Triggers", "section");
        for (Trigger trigger : triggers) {
            String triggerName;
            ArrayList<EventManipulationType> eventManipulationTypes;
            if (trigger == null) continue;
            StringBuilder timingBuffer = new StringBuilder();
            ConditionTimingType conditionTiming = trigger.getConditionTiming();
            if (conditionTiming != null && conditionTiming != ConditionTimingType.unknown) {
                timingBuffer.append((Object)conditionTiming);
            }
            if ((eventManipulationTypes = new ArrayList<EventManipulationType>(trigger.getEventManipulationTypes())) != null && eventManipulationTypes.get(0) != EventManipulationType.unknown) {
                if (timingBuffer.length() > 0) {
                    timingBuffer.append(SPACE);
                }
                for (EventManipulationType eventManipulationType : eventManipulationTypes) {
                    timingBuffer.append((Object)eventManipulationType);
                    if (eventManipulationTypes.indexOf((Object)eventManipulationType) >= eventManipulationTypes.size() - 1) continue;
                    timingBuffer.append(" or ");
                }
            }
            if (trigger.getActionOrientation() != null && trigger.getActionOrientation() != ActionOrientationType.unknown) {
                timingBuffer.append(", per ").append((Object)trigger.getActionOrientation());
            }
            String timing = timingBuffer.toString();
            String triggerType = "[trigger]";
            triggerType = triggerType.toLowerCase(Locale.ENGLISH);
            String actionCondition = trigger.getActionCondition();
            String actionStatement = trigger.getActionStatement();
            this.formattingHelper.writeEmptyRow();
            if (((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideTriggerNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing trigger name for <%s>", trigger));
                triggerName = "";
            } else {
                triggerName = this.identifiers.quoteName(trigger);
            }
            this.formattingHelper.writeNameRow(triggerName, triggerType);
            this.formattingHelper.writeDescriptionRow(timing);
            if (((SchemaTextOptions)this.options).isHideTriggerActionStatements() || Utility.isBlank(actionStatement)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing trigger action statement for <%s>", trigger));
            } else {
                this.formattingHelper.writeNameRow("", "[action statement]");
                this.formattingHelper.writeWideRow(actionStatement, "definition");
            }
            if (Utility.isBlank(actionCondition)) continue;
            this.formattingHelper.writeNameRow("", "[action condition]");
            this.formattingHelper.writeWideRow(actionCondition, "definition");
        }
    }

    private void printViewTableUsage(Table table) {
        if (table == null || !MetaDataUtility.isView(table)) {
            return;
        }
        View view = (View)table;
        Collection<Table> tableUsage = view.getTableUsage();
        if (tableUsage.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Table Usage", "section");
        this.formattingHelper.writeEmptyRow();
        for (Table usedTable : tableUsage) {
            String tableName = this.quoteName(usedTable);
            String tableType = "[" + String.valueOf(usedTable.getTableType()) + "]";
            this.formattingHelper.writeNameRow(tableName, tableType);
        }
    }

    private void printWeakAssociations(Table table) {
        if (table == null || ((SchemaTextOptions)this.options).is(HideDependantDatabaseObjectsType.hideWeakAssociations)) {
            LOGGER.log(Level.FINER, new StringFormat("Not showing weak association for <%s>", table));
            return;
        }
        Collection<WeakAssociation> weakAssociationsCollection = table.getWeakAssociations();
        if (weakAssociationsCollection == null || weakAssociationsCollection.isEmpty()) {
            return;
        }
        this.formattingHelper.writeEmptyRow();
        this.formattingHelper.writeWideRow("Weak Associations", "section");
        ArrayList<WeakAssociation> weakAssociations = new ArrayList<WeakAssociation>(weakAssociationsCollection);
        weakAssociations.sort(Comparator.naturalOrder());
        for (WeakAssociation weakAssociation : weakAssociations) {
            if (weakAssociation == null) continue;
            String name = this.identifiers.quoteName(weakAssociation);
            this.formattingHelper.writeEmptyRow();
            String fkName = "";
            if (!((SchemaTextOptions)this.options).is(HideDatabaseObjectNamesType.hideWeakAssociationNames)) {
                LOGGER.log(Level.FINER, new StringFormat("Not showing weak associations name for <%s>", weakAssociation));
                fkName = name;
            }
            String fkDetails = "[weak association]";
            this.formattingHelper.writeNameRow(fkName, "[weak association]");
            this.printRemarks(weakAssociation);
            this.printColumnReferences(false, table, weakAssociation);
        }
    }
}

