/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.extern.decimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.firebirdsql.extern.decimal.Decimal;
import org.firebirdsql.extern.decimal.DecimalCodec;
import org.firebirdsql.extern.decimal.DecimalFactory;
import org.firebirdsql.extern.decimal.DecimalFormat;
import org.firebirdsql.extern.decimal.DecimalType;
import org.firebirdsql.extern.decimal.OverflowHandling;

public final class Decimal128
extends Decimal<Decimal128> {
    public static final Decimal128 POSITIVE_INFINITY = new Decimal128(1, DecimalType.INFINITY);
    public static final Decimal128 NEGATIVE_INFINITY = new Decimal128(-1, DecimalType.INFINITY);
    public static final Decimal128 POSITIVE_NAN = new Decimal128(1, DecimalType.NAN);
    public static final Decimal128 NEGATIVE_NAN = new Decimal128(-1, DecimalType.NAN);
    public static final Decimal128 POSITIVE_SIGNALING_NAN = new Decimal128(1, DecimalType.SIGNALING_NAN);
    public static final Decimal128 NEGATIVE_SIGNALING_NAN = new Decimal128(-1, DecimalType.SIGNALING_NAN);
    private static final Decimal128Factory DECIMAL_128_FACTORY = new Decimal128Factory();
    private static final DecimalCodec<Decimal128> DECIMAL_128_CODEC = new DecimalCodec<Decimal128>(DECIMAL_128_FACTORY);

    private Decimal128(int signum, DecimalType decimalType) {
        super(signum, decimalType);
    }

    private Decimal128(int signum, BigDecimal bigDecimal) {
        super(signum, bigDecimal);
    }

    @Override
    DecimalCodec<Decimal128> getDecimalCodec() {
        return DECIMAL_128_CODEC;
    }

    @Override
    DecimalFactory<Decimal128> getDecimalFactory() {
        return DECIMAL_128_FACTORY;
    }

    public static Decimal128 parseBytes(byte[] decBytes) {
        return DECIMAL_128_CODEC.parseBytes(decBytes);
    }

    public static Decimal128 valueOf(BigDecimal value) {
        return Decimal128.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal128 valueOf(BigDecimal value, OverflowHandling overflowHandling) {
        return (Decimal128)DECIMAL_128_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal128 valueOf(BigInteger value) {
        return Decimal128.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal128 valueOf(BigInteger value, OverflowHandling overflowHandling) {
        return (Decimal128)DECIMAL_128_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal128 valueOfExact(BigInteger value) {
        return (Decimal128)DECIMAL_128_FACTORY.valueOfExact(value);
    }

    public static Decimal128 valueOf(double value) {
        return Decimal128.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal128 valueOf(double value, OverflowHandling overflowHandling) {
        return (Decimal128)DECIMAL_128_FACTORY.valueOf(value, overflowHandling);
    }

    public static Decimal128 valueOf(Decimal<?> decimal) {
        return Decimal128.valueOf(decimal, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal128 valueOf(Decimal<?> decimal, OverflowHandling overflowHandling) {
        if (decimal instanceof Decimal128) {
            return (Decimal128)decimal;
        }
        return (Decimal128)DECIMAL_128_FACTORY.valueOf(decimal, overflowHandling);
    }

    public static Decimal128 valueOf(String value) {
        return Decimal128.valueOf(value, OverflowHandling.ROUND_TO_INFINITY);
    }

    public static Decimal128 valueOf(String value, OverflowHandling overflowHandling) {
        return (Decimal128)DECIMAL_128_FACTORY.valueOf(value, overflowHandling);
    }

    private static class Decimal128Factory
    extends Decimal.AbstractDecimalFactory<Decimal128> {
        private Decimal128Factory() {
            super(Decimal128.class, DecimalFormat.Decimal128, POSITIVE_INFINITY, NEGATIVE_INFINITY, POSITIVE_NAN, NEGATIVE_NAN, POSITIVE_SIGNALING_NAN, NEGATIVE_SIGNALING_NAN);
        }

        @Override
        public Decimal128 createDecimal(int signum, BigDecimal value) {
            return new Decimal128(signum, this.validateRange(value));
        }
    }
}

