/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFConnection;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.CHANGE_NOTIFICATION})
class NTFListener
extends Thread {
    private ArrayList<NTFConnection> connections;
    private final Monitor connectionsMonitor;
    private int nbOfConnections;
    private boolean needsToBeClosed;
    NTFManager dcnManager;
    ServerSocketChannel ssChannel;
    int tcpport;
    public Properties socketOptions;
    private Exception[] connectionCreationExceptionArr;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    NTFListener(NTFManager _dcnManager, ServerSocketChannel _ssChannel, int _tcpport, @Blind(value=PropertiesBlinder.class) Properties _socketOptions, Exception[] _connectionCreationExceptionArr) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null, _dcnManager, _ssChannel, _tcpport, TraceControllerImpl.blind(PropertiesBlinder.class, _socketOptions), _connectionCreationExceptionArr);
            }
            this.connectionsMonitor = Monitor.newInstance();
            this.nbOfConnections = 0;
            this.needsToBeClosed = false;
            this.dcnManager = _dcnManager;
            this.connections = new ArrayList(10);
            this.ssChannel = _ssChannel;
            this.tcpport = _tcpport;
            this.socketOptions = _socketOptions;
            this.connectionCreationExceptionArr = _connectionCreationExceptionArr;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFListener.class, $$$methodRef$$$4, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block29: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, new Object[0]);
                }
                try {
                    Selector selector = Selector.open();
                    this.ssChannel.register(selector, 16);
                    block14: while (true) {
                        selector.select();
                        if (this.needsToBeClosed) {
                            selector.close();
                            this.ssChannel.close();
                            break;
                        }
                        Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                        while (true) {
                            block32: {
                                if (!iterator.hasNext()) continue block14;
                                SelectionKey aKey = iterator.next();
                                if ((aKey.readyOps() & 0x10) != 16) continue;
                                if (bl) {
                                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + ") thread: OP_ACCEPT");
                                }
                                ServerSocketChannel server = (ServerSocketChannel)aKey.channel();
                                SocketChannel connectionChannel = server.accept();
                                try {
                                    NTFConnection conn;
                                    block30: {
                                        Monitor.CloseableLock lock;
                                        block31: {
                                            conn = new NTFConnection(this.dcnManager, connectionChannel, this);
                                            lock = this.connectionsMonitor.acquireCloseableLock();
                                            Throwable throwable = null;
                                            try {
                                                this.connections.add(conn);
                                                if (lock == null) break block30;
                                                if (throwable == null) break block31;
                                            }
                                            catch (Throwable throwable3) {
                                                try {
                                                    throwable = throwable3;
                                                    Throwable throwable4 = throwable3;
                                                    if (bl) {
                                                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, throwable4);
                                                    }
                                                    throw throwable4;
                                                }
                                                catch (Throwable throwable5) {
                                                    if (lock != null) {
                                                        if (throwable != null) {
                                                            try {
                                                                lock.close();
                                                            }
                                                            catch (Throwable throwable6) {
                                                                throwable.addSuppressed(throwable6);
                                                            }
                                                        } else {
                                                            lock.close();
                                                        }
                                                    }
                                                    Throwable throwable7 = throwable5;
                                                    if (bl) {
                                                        ClioSupport.throwing($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, throwable7);
                                                    }
                                                    throw throwable7;
                                                }
                                            }
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block30;
                                        }
                                        lock.close();
                                    }
                                    conn.start();
                                    if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                                        this.connectionCreationExceptionArr[0] = null;
                                    }
                                }
                                catch (IOException ioe) {
                                    if (bl) {
                                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + "): ERROR: got IOException during connection creation in listener thread execution: " + ioe.getMessage());
                                    }
                                    if (this.connectionCreationExceptionArr == null || this.connectionCreationExceptionArr.length <= 0) break block32;
                                    this.connectionCreationExceptionArr[0] = ioe;
                                }
                            }
                            iterator.remove();
                        }
                        break;
                    }
                }
                catch (IOException ioe) {
                    if (!bl) break block29;
                    OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + "): ERROR: got IOException during thread execution: " + ioe.getMessage());
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFListener (tcpport=" + this.tcpport + "): end of run method. Thread will be closed.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFListener.class, $$$methodRef$$$0, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeThisListener() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block20: {
                Monitor.CloseableLock lock;
                block21: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, new Object[0]);
                    }
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "NTFListener (tcpport=" + this.tcpport + ") closing listener");
                    }
                    lock = this.connectionsMonitor.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        for (NTFConnection conn : this.connections) {
                            conn.closeThisConnection();
                            conn.interrupt();
                        }
                        this.needsToBeClosed = true;
                        if (lock == null) break block20;
                        if (throwable == null) break block21;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFListener.class, $$$methodRef$$$1, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void releaseConnection(NTFConnection nTFConnection) {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, nTFConnection);
                    }
                    lock = this.connectionsMonitor.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        void conn;
                        this.connections.remove(conn);
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "NTFListener (tcpport=" + this.tcpport + ") connection released");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFListener.class, $$$methodRef$$$2, this, throwable8);
            }
            throw throwable;
        }
    }

    Exception getRegistrationException() {
        boolean bl = (0x10000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.connectionCreationExceptionArr != null && this.connectionCreationExceptionArr.length > 0) {
                Exception exception = this.connectionCreationExceptionArr[0];
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, exception);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, null);
                }
                return exception;
            }
            Exception exception = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, exception);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFListener.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$4 = NTFListener.class.getDeclaredConstructor(NTFManager.class, ServerSocketChannel.class, Integer.TYPE, Properties.class, Exception[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFListener.class.getDeclaredMethod("getRegistrationException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFListener.class.getDeclaredMethod("releaseConnection", NTFConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFListener.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFListener.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

