# frozen_string_literal: true

# The code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
module Cucumber
  module Messages
    ##
    # Represents the TestRunHookFinished message in Cucumber's {message protocol}[https://github.com/cucumber/messages].
    ##
    ##
    class TestRunHookFinished < Message
      ##
      # Identifier for the hook execution that has finished
      ##
      attr_reader :test_run_hook_started_id

      attr_reader :result

      attr_reader :timestamp

      def initialize(
        test_run_hook_started_id: '',
        result: TestStepResult.new,
        timestamp: Timestamp.new
      )
        @test_run_hook_started_id = test_run_hook_started_id
        @result = result
        @timestamp = timestamp
        super()
      end

      ##
      # Returns a new TestRunHookFinished from the given hash.
      # If the hash keys are camelCased, they are properly assigned to the
      # corresponding snake_cased attributes.
      #
      #   Cucumber::Messages::TestRunHookFinished.from_h(some_hash) # => #<Cucumber::Messages::TestRunHookFinished:0x... ...>
      ##
      def self.from_h(hash)
        return nil if hash.nil?

        new(
          test_run_hook_started_id: hash[:testRunHookStartedId],
          result: TestStepResult.from_h(hash[:result]),
          timestamp: Timestamp.from_h(hash[:timestamp])
        )
      end
    end
  end
end
