// SPDX-FileCopyrightText: 2019 Niels Ole Salscheider <ole@salscheider.org>
// SPDX-FileCopyrightText: 2025 Linus Jahn <lnj@kaidan.im>
//
// SPDX-License-Identifier: LGPL-2.1-or-later

#ifndef QXMPPCALLSTREAM_H
#define QXMPPCALLSTREAM_H

#include <QXmppLogger.h>

#include <functional>

typedef struct _GstPad GstPad;
typedef struct _GstElement GstElement;

class QXmppCallStreamPrivate;
class QXmppIceConnection;
class QXmppCall;
class QXmppCallPrivate;

class QXMPP_EXPORT QXmppCallStream : public QXmppLoggable
{
    Q_OBJECT

public:
    QString creator() const;
    QString media() const;
    QString name() const;
    int id() const;
    void setReceivePadCallback(std::function<void(GstPad *)> cb);
    void setSendPadCallback(std::function<void(GstPad *)> cb);

private:
    QXmppCallStream(GstElement *pipeline, GstElement *rtpbin, QString media, QString creator, QString name, int id, bool useDtls, QObject *parent);

    QXmppCallStreamPrivate *d;

    friend class QXmppCallStreamPrivate;
    friend class QXmppCall;
    friend class QXmppCallPrivate;
};

#endif
