/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend.model;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.frontend.SwitcherVirtualFile;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import com.intellij.platform.recentFiles.shared.RecentFilesMutableState;
import com.intellij.platform.recentFiles.shared.RecentFilesState;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u00020\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesMutableState;", "Lcom/intellij/platform/recentFiles/shared/RecentFilesMutableState;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "checkValidity", "", "model", "chooseStateToReadFrom", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/recentFiles/shared/RecentFilesState;", "filesKind", "Lcom/intellij/platform/recentFiles/shared/RecentFileKind;", "isSingleFileOpenedInMultipleEditors", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.recentFiles.frontend"})
public final class FrontendRecentFilesMutableState
extends RecentFilesMutableState<SwitcherVirtualFile> {
    public FrontendRecentFilesMutableState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    public boolean checkValidity(@NotNull SwitcherVirtualFile model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        VirtualFile virtualFile = model.getVirtualFile();
        return !(virtualFile != null ? !virtualFile.isValid() : false);
    }

    @NotNull
    public final MutableStateFlow<RecentFilesState<SwitcherVirtualFile>> chooseStateToReadFrom(@NotNull RecentFileKind filesKind) {
        Intrinsics.checkNotNullParameter((Object)filesKind, (String)"filesKind");
        return switch (WhenMappings.$EnumSwitchMapping$0[filesKind.ordinal()]) {
            case 1 -> this.getRecentlyEditedFilesState();
            case 2 -> this.getRecentlyOpenedFilesState();
            case 3 -> {
                List capturedSwitcherModelState = ((RecentFilesState)this.getRecentlyOpenedPinnedFilesState().getValue()).getEntries();
                if (capturedSwitcherModelState.size() == 1 && this.isSingleFileOpenedInMultipleEditors(((SwitcherVirtualFile)CollectionsKt.single((List)capturedSwitcherModelState)).getVirtualFile())) {
                    yield this.getRecentlyOpenedPinnedFilesState();
                }
                if (capturedSwitcherModelState.isEmpty() || capturedSwitcherModelState.size() == 1) {
                    yield this.getRecentlyOpenedFilesState();
                }
                yield this.getRecentlyOpenedPinnedFilesState();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean isSingleFileOpenedInMultipleEditors(VirtualFile file) {
        if (file == null) {
            return false;
        }
        return FileEditorManager.getInstance((Project)this.getProject()).getAllEditors(file).length > 1;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecentFileKind.values().length];
            try {
                nArray[RecentFileKind.RECENTLY_EDITED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED_UNPINNED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

