/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.api.data.GHCommitHash;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"sortCommits", "", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "commits", "", "lastCommitSha", "", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHPRChangesDataProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRChangesDataProviderImpl.kt\norg/jetbrains/plugins/github/pullrequest/data/provider/GHPRChangesDataProviderImplKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,168:1\n1#2:169\n*E\n"})
public final class GHPRChangesDataProviderImplKt {
    private static final List<GHCommit> sortCommits(Collection<GHCommit> commits2, String lastCommitSha) {
        ImmutableGraph.Builder builder;
        Map commitsBySha = new LinkedHashMap();
        GHCommit lastCommit = null;
        for (GHCommit commit : commits2) {
            if (Intrinsics.areEqual((Object)commit.getOid(), (Object)lastCommitSha)) {
                lastCommit = commit;
            }
            commitsBySha.put(commit.getOid(), commit);
        }
        if (lastCommit == null) {
            boolean $i$a$-checkNotNull-GHPRChangesDataProviderImplKt$sortCommits$22 = false;
            String $i$a$-checkNotNull-GHPRChangesDataProviderImplKt$sortCommits$22 = "Could not determine last commit";
            throw new IllegalStateException($i$a$-checkNotNull-GHPRChangesDataProviderImplKt$sortCommits$22.toString());
        }
        Set processedCommits = new LinkedHashSet();
        ImmutableGraph.Builder $this$sortCommits_u24lambda_u241 = builder = GraphBuilder.directed().allowsSelfLoops(false).immutable();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$sortCommits_u24lambda_u241);
        GHPRChangesDataProviderImplKt.sortCommits$addCommits((ImmutableGraph.Builder<GHCommit>)$this$sortCommits_u24lambda_u241, processedCommits, commitsBySha, lastCommit);
        ImmutableGraph immutableGraph = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableGraph, (String)"build(...)");
        ImmutableGraph graph = immutableGraph;
        Iterable iterable = Traverser.forGraph((SuccessorsFunction)((SuccessorsFunction)graph)).depthFirstPostOrder((Object)lastCommit);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"depthFirstPostOrder(...)");
        return CollectionsKt.toList((Iterable)iterable);
    }

    private static final void sortCommits$addCommits(ImmutableGraph.Builder<GHCommit> $this$sortCommits_u24addCommits, Set<String> processedCommits, Map<String, GHCommit> commitsBySha, GHCommit commit) {
        boolean alreadyProcessed;
        boolean bl = alreadyProcessed = !processedCommits.add(commit.getOid());
        if (alreadyProcessed) {
            return;
        }
        $this$sortCommits_u24addCommits.addNode((Object)commit);
        for (GHCommitHash parent : commit.getParents()) {
            GHCommit parentCommit = commitsBySha.get(parent.getOid());
            if (parentCommit == null) continue;
            $this$sortCommits_u24addCommits.putEdge((Object)commit, (Object)parentCommit);
            GHPRChangesDataProviderImplKt.sortCommits$addCommits($this$sortCommits_u24addCommits, processedCommits, commitsBySha, parentCommit);
        }
    }

    public static final /* synthetic */ List access$sortCommits(Collection commits2, String lastCommitSha) {
        return GHPRChangesDataProviderImplKt.sortCommits(commits2, lastCommitSha);
    }
}

