/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.jcef.impl;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/jcef/impl/FileSchemeResourcesProcessor;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "baseFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectRoot", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;)V", "canProvide", "", "resourceName", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
public final class FileSchemeResourcesProcessor
implements ResourceProvider {
    @Nullable
    private final VirtualFile baseFile;
    @Nullable
    private final VirtualFile projectRoot;

    public FileSchemeResourcesProcessor(@Nullable VirtualFile baseFile, @Nullable VirtualFile projectRoot2) {
        this.baseFile = baseFile;
        this.projectRoot = projectRoot2;
    }

    @Override
    public boolean canProvide(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        return this.baseFile != null && this.projectRoot != null;
    }

    @Override
    @Nullable
    public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
        if (StringsKt.startsWith$default((String)resourceName, (String)"file:/", (boolean)false, (int)2, null)) {
            object = VfsUtil.findFileByIoFile((File)new File(new URL(resourceName).getPath()), (boolean)true);
        } else {
            VirtualFile virtualFile = this.projectRoot;
            object = virtualFile != null ? virtualFile.findFileByRelativePath(resourceName) : null;
        }
        if (object == null) {
            return null;
        }
        VirtualFile resource = object;
        return ResourceProvider.Companion.loadExternalResource$default(ResourceProvider.Companion, resource, null, 2, null);
    }
}

