/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order.counting;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.counting.BinaryIndexedTree;
import org.eclipse.elk.alg.layered.p3order.counting.CrossMinUtil;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public final class CrossingsCounter {
    private final int[] portPositions;
    private BinaryIndexedTree indexTree;
    private final Deque<Integer> ends;
    private int[] nodeCardinalities;
    private static final PortSide INDEXING_SIDE = PortSide.WEST;
    private static final PortSide STACK_SIDE = PortSide.EAST;

    public CrossingsCounter(int[] portPositions) {
        this.portPositions = portPositions;
        this.ends = new ArrayDeque<Integer>();
    }

    public int countCrossingsBetweenLayers(LNode[] leftLayerNodes, LNode[] rightLayerNodes) {
        List<LPort> ports = this.initPortPositionsCounterClockwise(leftLayerNodes, rightLayerNodes);
        this.indexTree = new BinaryIndexedTree(ports.size());
        return this.countCrossingsOnPorts(ports);
    }

    public int countInLayerCrossingsOnSide(LNode[] nodes, PortSide side) {
        List<LPort> ports = this.initPortPositionsForInLayerCrossings(nodes, side);
        return this.countInLayerCrossingsOnPorts(ports);
    }

    public int countNorthSouthPortCrossingsInLayer(LNode[] layer) {
        List<LPort> ports = this.initPositionsForNorthSouthCounting(layer);
        this.indexTree = new BinaryIndexedTree(ports.size());
        return this.countNorthSouthCrossingsOnPorts(ports);
    }

    public Pair<Integer, Integer> countCrossingsBetweenPortsInBothOrders(LPort upperPort, LPort lowerPort) {
        List<LPort> ports = this.connectedPortsSortedByPosition(upperPort, lowerPort);
        int upperLowerCrossings = this.countCrossingsOnPorts(ports);
        this.indexTree.clear();
        this.switchPorts(upperPort, lowerPort);
        Collections.sort(ports, (a, b) -> Integer.compare(this.positionOf((LPort)a), this.positionOf((LPort)b)));
        int lowerUpperCrossings = this.countCrossingsOnPorts(ports);
        this.indexTree.clear();
        this.switchPorts(lowerPort, upperPort);
        return Pair.of(upperLowerCrossings, lowerUpperCrossings);
    }

    public Pair<Integer, Integer> countInLayerCrossingsBetweenNodesInBothOrders(LNode upperNode, LNode lowerNode, PortSide side) {
        List<LPort> ports = this.connectedInLayerPortsSortedByPosition(upperNode, lowerNode, side);
        int upperLowerCrossings = this.countInLayerCrossingsOnPorts(ports);
        this.switchNodes(upperNode, lowerNode, side);
        this.indexTree.clear();
        Collections.sort(ports, (a, b) -> Integer.compare(this.positionOf((LPort)a), this.positionOf((LPort)b)));
        int lowerUpperCrossings = this.countInLayerCrossingsOnPorts(ports);
        this.switchNodes(lowerNode, upperNode, side);
        this.indexTree.clear();
        return Pair.of(upperLowerCrossings, lowerUpperCrossings);
    }

    public void initForCountingBetween(LNode[] leftLayerNodes, LNode[] rightLayerNodes) {
        List<LPort> ports = this.initPortPositionsCounterClockwise(leftLayerNodes, rightLayerNodes);
        this.indexTree = new BinaryIndexedTree(ports.size());
    }

    public List<LPort> initPortPositionsForInLayerCrossings(LNode[] nodes, PortSide side) {
        ArrayList<LPort> ports = new ArrayList<LPort>();
        this.initPositions(nodes, ports, side, true, true);
        this.indexTree = new BinaryIndexedTree(ports.size());
        return ports;
    }

    public void switchPorts(LPort topPort, LPort bottomPort) {
        int topPortPos = this.portPositions[topPort.id];
        this.portPositions[topPort.id] = this.portPositions[bottomPort.id];
        this.portPositions[bottomPort.id] = topPortPos;
    }

    public void switchNodes(LNode wasUpperNode, LNode wasLowerNode, PortSide side) {
        Iterable<LPort> ports = CrossMinUtil.inNorthSouthEastWestOrder(wasUpperNode, side);
        for (LPort port : ports) {
            this.portPositions[port.id] = this.positionOf(port) + this.nodeCardinalities[wasLowerNode.id];
        }
        ports = CrossMinUtil.inNorthSouthEastWestOrder(wasLowerNode, side);
        for (LPort port : ports) {
            this.portPositions[port.id] = this.positionOf(port) - this.nodeCardinalities[wasUpperNode.id];
        }
    }

    private List<LPort> connectedInLayerPortsSortedByPosition(LNode upperNode, LNode lowerNode, PortSide side) {
        TreeSet<LPort> ports = new TreeSet<LPort>((a, b) -> Integer.compare(this.positionOf((LPort)a), this.positionOf((LPort)b)));
        LNode[] lNodeArray = new LNode[]{upperNode, lowerNode};
        int n = lNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            for (LPort port : CrossMinUtil.inNorthSouthEastWestOrder(node, side)) {
                for (LEdge edge : port.getConnectedEdges()) {
                    if (edge.isSelfLoop()) continue;
                    ports.add(port);
                    if (!this.isInLayer(edge)) continue;
                    ports.add(this.otherEndOf(edge, port));
                }
            }
            ++n2;
        }
        return Lists.newArrayList(ports);
    }

    private List<LPort> connectedPortsSortedByPosition(LPort upperPort, LPort lowerPort) {
        TreeSet<LPort> ports = new TreeSet<LPort>((a, b) -> Integer.compare(this.positionOf((LPort)a), this.positionOf((LPort)b)));
        LPort[] lPortArray = new LPort[]{upperPort, lowerPort};
        int n = lPortArray.length;
        int n2 = 0;
        while (n2 < n) {
            LPort port = lPortArray[n2];
            ports.add(port);
            for (LEdge edge : port.getConnectedEdges()) {
                if (this.isPortSelfLoop(edge)) continue;
                ports.add(this.otherEndOf(edge, port));
            }
            ++n2;
        }
        return Lists.newArrayList(ports);
    }

    private int countCrossingsOnPorts(Iterable<LPort> ports) {
        int crossings = 0;
        for (LPort port : ports) {
            this.indexTree.removeAll(this.positionOf(port));
            for (LEdge edge : port.getConnectedEdges()) {
                int endPosition = this.positionOf(this.otherEndOf(edge, port));
                if (endPosition <= this.positionOf(port)) continue;
                crossings += this.indexTree.rank(endPosition);
                this.ends.push(endPosition);
            }
            while (!this.ends.isEmpty()) {
                this.indexTree.add(this.ends.pop());
            }
        }
        return crossings;
    }

    private int countInLayerCrossingsOnPorts(Iterable<LPort> ports) {
        int crossings = 0;
        for (LPort port : ports) {
            this.indexTree.removeAll(this.positionOf(port));
            int numBetweenLayerEdges = 0;
            for (LEdge edge : port.getConnectedEdges()) {
                if (this.isInLayer(edge)) {
                    int endPosition = this.positionOf(this.otherEndOf(edge, port));
                    if (endPosition <= this.positionOf(port)) continue;
                    crossings += this.indexTree.rank(endPosition);
                    this.ends.push(endPosition);
                    continue;
                }
                ++numBetweenLayerEdges;
            }
            crossings += this.indexTree.size() * numBetweenLayerEdges;
            while (!this.ends.isEmpty()) {
                this.indexTree.add(this.ends.pop());
            }
        }
        return crossings;
    }

    private int countNorthSouthCrossingsOnPorts(Iterable<LPort> ports) {
        int crossings = 0;
        ArrayList<Pair<LPort, Integer>> targetsAndDegrees = Lists.newArrayList();
        for (LPort port : ports) {
            this.indexTree.removeAll(this.positionOf(port));
            targetsAndDegrees.clear();
            switch (port.getNode().getType()) {
                case NORMAL: {
                    LNode lNode = port.getProperty(InternalProperties.PORT_DUMMY);
                    assert (lNode != null);
                    lNode.getPorts().forEach(p -> {
                        boolean bl = targetsAndDegrees.add(Pair.of(p, p.getDegree()));
                    });
                    break;
                }
                case LONG_EDGE: {
                    port.getNode().getPorts().stream().filter(p -> p != port).findFirst().ifPresent(p -> {
                        boolean bl = targetsAndDegrees.add(Pair.of(p, p.getDegree()));
                    });
                    break;
                }
                case NORTH_SOUTH_PORT: {
                    LPort dummyPort = (LPort)port.getProperty(InternalProperties.ORIGIN);
                    targetsAndDegrees.add(Pair.of(dummyPort, port.getDegree()));
                }
            }
            for (Pair pair : targetsAndDegrees) {
                int endPosition = this.positionOf((LPort)pair.getFirst());
                if (endPosition <= this.positionOf(port)) continue;
                crossings += this.indexTree.rank(endPosition) * (Integer)pair.getSecond();
                this.ends.push(endPosition);
            }
            while (!this.ends.isEmpty()) {
                this.indexTree.add(this.ends.pop());
            }
        }
        return crossings;
    }

    private void initPositions(LNode[] nodes, List<LPort> ports, PortSide side, boolean topDown, boolean getCardinalities) {
        int numPorts = ports.size();
        if (getCardinalities) {
            this.nodeCardinalities = new int[nodes.length];
        }
        int i = this.start(nodes, topDown);
        while (this.end(i, topDown, nodes)) {
            LNode node = nodes[i];
            List<LPort> nodePorts = this.getPorts(node, side, topDown);
            if (getCardinalities) {
                this.nodeCardinalities[node.id] = nodePorts.size();
            }
            for (LPort port : nodePorts) {
                this.portPositions[port.id] = numPorts++;
            }
            ports.addAll(nodePorts);
            i += this.step(topDown);
        }
    }

    private List<LPort> initPortPositionsCounterClockwise(LNode[] leftLayerNodes, LNode[] rightLayerNodes) {
        ArrayList<LPort> ports = new ArrayList<LPort>();
        this.initPositions(leftLayerNodes, ports, PortSide.EAST, true, false);
        this.initPositions(rightLayerNodes, ports, PortSide.WEST, false, false);
        return ports;
    }

    private List<LPort> initPositionsForNorthSouthCounting(LNode[] nodes) {
        ArrayList<LPort> ports = Lists.newArrayList();
        ArrayDeque<LNode> stack = new ArrayDeque<LNode>();
        LNode lastLayoutUnit = null;
        int index = 0;
        int i = 0;
        while (i < nodes.length) {
            LNode current = nodes[i];
            if (this.isLayoutUnitChanged(lastLayoutUnit, current)) {
                index = this.emptyStack(stack, ports, STACK_SIDE, index);
            }
            if (current.hasProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT)) {
                lastLayoutUnit = current.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT);
            }
            switch (current.getType()) {
                case NORMAL: {
                    for (LPort p2 : this.getNorthSouthPortsWithIncidentEdges(current, PortSide.NORTH)) {
                        this.portPositions[p2.id] = index++;
                        ports.add(p2);
                    }
                    index = this.emptyStack(stack, ports, STACK_SIDE, index);
                    for (LPort p2 : this.getNorthSouthPortsWithIncidentEdges(current, PortSide.SOUTH)) {
                        this.portPositions[p2.id] = index++;
                        ports.add(p2);
                    }
                    break;
                }
                case NORTH_SOUTH_PORT: {
                    if (!current.getPortSideView(INDEXING_SIDE).isEmpty()) {
                        LPort p2;
                        p2 = current.getPortSideView(INDEXING_SIDE).get(0);
                        this.portPositions[p2.id] = index++;
                        ports.add(p2);
                    }
                    if (current.getPortSideView(STACK_SIDE).isEmpty()) break;
                    stack.push(current);
                    break;
                }
                case LONG_EDGE: {
                    for (LPort p2 : current.getPortSideView(PortSide.WEST)) {
                        this.portPositions[p2.id] = index++;
                        ports.add(p2);
                    }
                    current.getPortSideView(PortSide.EAST).forEach(p -> stack.push(current));
                }
            }
            ++i;
        }
        this.emptyStack(stack, ports, STACK_SIDE, index);
        return ports;
    }

    private int emptyStack(Deque<LNode> stack, List<LPort> ports, PortSide side, int startIndex) {
        int index = startIndex;
        while (!stack.isEmpty()) {
            LNode dummy = stack.pop();
            LPort p = dummy.getPortSideView(side).get(0);
            this.portPositions[p.id] = index++;
            ports.add(p);
        }
        return index;
    }

    private List<LPort> getPorts(LNode node, PortSide side, boolean topDown) {
        if (side == PortSide.EAST) {
            if (topDown) {
                return node.getPortSideView(side);
            }
            return Lists.reverse(node.getPortSideView(side));
        }
        if (topDown) {
            return Lists.reverse(node.getPortSideView(side));
        }
        return node.getPortSideView(side);
    }

    private Iterable<LPort> getNorthSouthPortsWithIncidentEdges(LNode node, PortSide side) {
        return Iterables.filter(node.getPortSideView(side), p -> p.hasProperty(InternalProperties.PORT_DUMMY));
    }

    private int start(LNode[] nodes, boolean topDown) {
        return topDown ? 0 : nodes.length - 1;
    }

    private boolean end(int i, boolean topDown, LNode[] nodes) {
        return topDown ? i < nodes.length : i >= 0;
    }

    private int step(boolean topDown) {
        return topDown ? 1 : -1;
    }

    private boolean isInLayer(LEdge edge) {
        Layer targetLayer;
        Layer sourceLayer = edge.getSource().getNode().getLayer();
        return sourceLayer == (targetLayer = edge.getTarget().getNode().getLayer());
    }

    private int positionOf(LPort port) {
        return this.portPositions[port.id];
    }

    private LPort otherEndOf(LEdge edge, LPort fromPort) {
        return fromPort == edge.getSource() ? edge.getTarget() : edge.getSource();
    }

    private boolean isPortSelfLoop(LEdge edge) {
        return edge.getSource() == edge.getTarget();
    }

    private boolean isLayoutUnitChanged(LNode lastUnit, LNode node) {
        if (lastUnit == null || lastUnit == node || !node.hasProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT)) {
            return false;
        }
        LNode unit = node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT);
        return unit != lastUnit;
    }
}

