/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import com.selectivem.collections.GenericArrays;
import com.selectivem.collections.Hashing;
import com.selectivem.collections.IndexedImmutableSet;
import com.selectivem.collections.UnmodifiableSetImpl;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

abstract class IndexedImmutableSetImpl<E>
extends UnmodifiableSetImpl<E>
implements IndexedImmutableSet<E> {
    private final int size;
    static final Set<Object> EMPTY = new IndexedImmutableSetImpl<Object>(0){

        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return false;
        }

        @Override
        public int elementToIndex(Object element) {
            return -1;
        }

        @Override
        public Object indexToElement(int i) {
            return null;
        }
    };

    static <E> IndexedImmutableSetImpl<E> of(E e1) {
        return new OneElementSet<E>(e1);
    }

    static <E> IndexedImmutableSetImpl<E> of(E e1, E e2) {
        if (!e1.equals(e2)) {
            return new TwoElementSet<E>(e1, e2);
        }
        return new OneElementSet<E>(e1);
    }

    static <E> IndexedImmutableSetImpl<E> of(Set<E> set) {
        if (set instanceof IndexedImmutableSetImpl) {
            return (IndexedImmutableSetImpl)set;
        }
        int size = set.size();
        if (size == 0) {
            return IndexedImmutableSetImpl.empty();
        }
        if (size == 1) {
            return IndexedImmutableSetImpl.of(set.iterator().next());
        }
        if (size == 2) {
            Iterator<E> iter = set.iterator();
            return IndexedImmutableSetImpl.of(iter.next(), iter.next());
        }
        if (size < 5) {
            return new ArrayBackedSet<E>(set);
        }
        int hashTableSize = Hashing.hashTableSize(size);
        if (hashTableSize != -1 && set.size() < Short.MAX_VALUE) {
            InternalBuilder internalBuilder = new HashArrayBackedSet.Builder<E>(hashTableSize, size);
            for (E e : set) {
                internalBuilder = ((InternalBuilder)internalBuilder).with(e);
            }
            return ((InternalBuilder)internalBuilder).build();
        }
        return new SetBackedSet.Builder<E>(set).build();
    }

    static <E> InternalBuilder<E> builder(int size) {
        int hashTableSize = Hashing.hashTableSize(size);
        if (hashTableSize != -1 && size < Short.MAX_VALUE) {
            return new HashArrayBackedSet.Builder(hashTableSize, size);
        }
        return new SetBackedSet.Builder(size);
    }

    static <E> IndexedImmutableSetImpl<E> empty() {
        IndexedImmutableSetImpl result = (IndexedImmutableSetImpl)EMPTY;
        return result;
    }

    IndexedImmutableSetImpl(int size) {
        this.size = size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public abstract int elementToIndex(Object var1);

    @Override
    public abstract E indexToElement(int var1);

    static class OneElementSet<E>
    extends IndexedImmutableSetImpl<E> {
        private final E element;

        OneElementSet(E element) {
            super(1);
            this.element = element;
        }

        @Override
        public boolean contains(Object o) {
            return this.element.equals(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < 1;
                }

                @Override
                public E next() {
                    if (this.i == 0) {
                        ++this.i;
                        return element;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.element};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 1 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            result[0] = this.element;
            return result;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int elementToIndex(Object element) {
            if (element.equals(this.element)) {
                return 0;
            }
            return -1;
        }

        @Override
        public E indexToElement(int i) {
            if (i == 0) {
                return this.element;
            }
            return null;
        }
    }

    static class TwoElementSet<E>
    extends IndexedImmutableSetImpl<E> {
        private final E e1;
        private final E e2;

        TwoElementSet(E e1, E e2) {
            super(2);
            this.e1 = e1;
            this.e2 = e2;
        }

        @Override
        public boolean contains(Object o) {
            return this.e1.equals(o) || this.e2.equals(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < 2;
                }

                @Override
                public E next() {
                    if (this.i == 0) {
                        ++this.i;
                        return e1;
                    }
                    if (this.i == 1) {
                        ++this.i;
                        return e2;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return new Object[]{this.e1, this.e2};
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] result = a.length >= 2 ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), 2);
            result[0] = this.e1;
            result[1] = this.e2;
            return result;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int elementToIndex(Object element) {
            if (element.equals(this.e1)) {
                return 0;
            }
            if (element.equals(this.e2)) {
                return 1;
            }
            return -1;
        }

        @Override
        public E indexToElement(int i) {
            if (i == 0) {
                return this.e1;
            }
            if (i == 1) {
                return this.e2;
            }
            return null;
        }
    }

    static final class ArrayBackedSet<E>
    extends IndexedImmutableSetImpl<E> {
        private final E[] elements;

        ArrayBackedSet(Set<E> elements) {
            super(elements.size());
            this.elements = elements.toArray();
            for (int i = 0; i < this.elements.length; ++i) {
                if (this.elements[i] != null) continue;
                throw new IllegalArgumentException("Does not support null elements");
            }
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            for (int i = 0; i < this.elements.length; ++i) {
                if (!this.elements[i].equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < elements.length;
                }

                @Override
                public E next() {
                    if (this.i >= elements.length) {
                        throw new NoSuchElementException();
                    }
                    Object element = elements[this.i];
                    ++this.i;
                    return element;
                }
            };
        }

        @Override
        public Object[] toArray() {
            return GenericArrays.copyAsObjectArray(this.elements);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return GenericArrays.copyAsTypedArray(this.elements, a);
        }

        @Override
        public int elementToIndex(Object element) {
            int l = this.elements.length;
            for (int i = 0; i < l; ++i) {
                if (!this.elements[i].equals(element)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public E indexToElement(int i) {
            if (i >= 0 && i < this.elements.length) {
                return this.elements[i];
            }
            return null;
        }
    }

    static final class HashArrayBackedSet<E>
    extends IndexedImmutableSetImpl<E> {
        static final int MAX_CAPACITY = Short.MAX_VALUE;
        final int tableSize;
        private final int size;
        private final short maxProbingDistance;
        private final E[] table;
        private final E[] flat;
        private final short[] indices;

        HashArrayBackedSet(int tableSize, int size, short maxProbingDistance, E[] table, short[] indices, E[] flat) {
            super(size);
            this.tableSize = tableSize;
            this.size = size;
            this.maxProbingDistance = maxProbingDistance;
            this.table = table;
            this.indices = indices;
            this.flat = flat;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return this.checkTable(o, this.hashPosition(o)) < 0;
        }

        @Override
        public int elementToIndex(Object o) {
            int hashPosition = this.hashPosition(o);
            if (this.table[hashPosition] == null) {
                return -1;
            }
            if (this.table[hashPosition].equals(o)) {
                return this.indices[hashPosition];
            }
            int max = hashPosition + this.maxProbingDistance;
            for (int i = hashPosition + 1; i <= max; ++i) {
                if (this.table[i] == null) {
                    return -1;
                }
                if (!this.table[i].equals(o)) continue;
                return this.indices[i];
            }
            return -1;
        }

        @Override
        public E indexToElement(int i) {
            if (i >= 0 && i < this.flat.length) {
                return this.flat[i];
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < size;
                }

                @Override
                public E next() {
                    if (this.i >= size) {
                        throw new NoSuchElementException();
                    }
                    Object element = flat[this.i];
                    ++this.i;
                    return element;
                }
            };
        }

        @Override
        public Object[] toArray() {
            return GenericArrays.copyAsObjectArray(this.flat, this.size);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return GenericArrays.copyAsTypedArray(this.flat, a, this.size);
        }

        int hashPosition(Object e) {
            return Hashing.hashPosition(this.tableSize, e);
        }

        int checkTable(Object e, int hashPosition) {
            return Hashing.checkTable(this.table, e, hashPosition, this.maxProbingDistance);
        }

        static class Builder<E>
        extends InternalBuilder<E> {
            private E[] table;
            private E[] flat;
            private short[] indices;
            private short size = 0;
            private int probingOverhead;
            private short probingOverheadFactor = (short)3;
            private final int tableSize;
            private final short maxProbingDistance;

            public Builder(int tableSize) {
                this.tableSize = tableSize;
                this.maxProbingDistance = Hashing.maxProbingDistance(tableSize);
            }

            public Builder(int tableSize, int flatSize) {
                this.tableSize = tableSize;
                this.maxProbingDistance = Hashing.maxProbingDistance(tableSize);
                if (flatSize > 0) {
                    this.flat = GenericArrays.create(flatSize);
                }
            }

            @Override
            public InternalBuilder<E> with(E e) {
                if (e == null) {
                    throw new IllegalArgumentException("Null elements are not supported");
                }
                if (this.table == null) {
                    int hashPosition = this.hashPosition(e);
                    this.table = GenericArrays.create(this.tableSize + this.maxProbingDistance);
                    this.indices = new short[this.tableSize + this.maxProbingDistance];
                    if (this.flat == null) {
                        this.flat = GenericArrays.create(this.tableSize <= 64 ? this.tableSize : this.tableSize / 2);
                    }
                    this.table[hashPosition] = e;
                    this.indices[hashPosition] = 0;
                    this.flat[0] = e;
                    this.size = (short)(this.size + 1);
                    return this;
                }
                if (this.size == Short.MAX_VALUE) {
                    return new SetBackedSet.Builder<E>(this.size).with(this.flat, this.size).with(e);
                }
                int position = this.hashPosition(e);
                if (this.table[position] == null) {
                    this.table[position] = e;
                    this.indices[position] = this.size;
                    this.extendFlat();
                    this.flat[this.size] = e;
                    this.size = (short)(this.size + 1);
                    return this;
                }
                if (this.table[position].equals(e)) {
                    return this;
                }
                int check = this.checkTable(e, position);
                if (check < 0) {
                    return this;
                }
                if (check == Integer.MAX_VALUE) {
                    int newTableSize = Hashing.nextSize(this.tableSize);
                    if (newTableSize != -1) {
                        return new Builder<E>(newTableSize).probingOverheadFactor(this.probingOverheadFactor).with(this.flat, this.size).with(e);
                    }
                    return new SetBackedSet.Builder<E>(this.size).with(this.flat, this.size).with(e);
                }
                this.table[check] = e;
                this.indices[check] = this.size;
                this.extendFlat();
                this.flat[this.size] = e;
                this.size = (short)(this.size + 1);
                this.probingOverhead += check - position;
                if (this.size >= 12 && this.probingOverhead > this.size * this.probingOverheadFactor) {
                    int newTableSize = Hashing.nextSize(this.tableSize);
                    if (newTableSize != -1) {
                        return new Builder<E>(newTableSize).probingOverheadFactor(this.probingOverheadFactor).with(this.flat, this.size);
                    }
                    return new SetBackedSet.Builder<E>(this.size).with(this.flat, this.size);
                }
                return this;
            }

            @Override
            InternalBuilder<E> with(E[] flat, int size) {
                if (this.flat == null) {
                    this.flat = flat;
                }
                InternalBuilder builder = this;
                for (int i = 0; i < size; ++i) {
                    builder = ((InternalBuilder)builder).with(flat[i]);
                }
                return builder;
            }

            @Override
            public IndexedImmutableSetImpl<E> build() {
                if (this.size == 0) {
                    return IndexedImmutableSetImpl.empty();
                }
                if (this.size == 1) {
                    return new OneElementSet<E>(this.flat[0]);
                }
                if (this.size == 2) {
                    return new TwoElementSet<E>(this.flat[0], this.flat[1]);
                }
                E[] flat = this.flat;
                if (flat.length > this.size + 16) {
                    flat = GenericArrays.create(this.size);
                    System.arraycopy(this.flat, 0, flat, 0, this.size);
                }
                return new HashArrayBackedSet<E>(this.tableSize, this.size, this.maxProbingDistance, this.table, this.indices, flat);
            }

            @Override
            int size() {
                return this.size;
            }

            @Override
            public Iterator<E> iterator() {
                if (this.size == 0) {
                    return Collections.emptyIterator();
                }
                return new Iterator<E>(){
                    int pos = 0;

                    @Override
                    public boolean hasNext() {
                        return this.pos < size;
                    }

                    @Override
                    public E next() {
                        if (this.pos < size) {
                            Object result = flat[this.pos];
                            ++this.pos;
                            return result;
                        }
                        throw new NoSuchElementException();
                    }
                };
            }

            @Override
            InternalBuilder<E> probingOverheadFactor(short probingOverheadFactor) {
                this.probingOverheadFactor = probingOverheadFactor;
                return this;
            }

            private int hashPosition(Object e) {
                return Hashing.hashPosition(this.tableSize, e);
            }

            private void extendFlat() {
                if (this.size >= this.flat.length) {
                    this.flat = GenericArrays.extend(this.flat, Math.min(this.flat.length + this.flat.length / 2 + 8, this.table.length));
                }
            }

            int checkTable(Object e, int hashPosition) {
                int max = hashPosition + this.maxProbingDistance;
                for (int i = hashPosition + 1; i <= max; ++i) {
                    if (this.table[i] == null) {
                        return i;
                    }
                    if (!this.table[i].equals(e)) continue;
                    return -1 - i;
                }
                return Integer.MAX_VALUE;
            }

            @Override
            boolean contains(Object o) {
                if (this.table == null) {
                    return false;
                }
                int hashPosition = this.hashPosition(o);
                int max = hashPosition + this.maxProbingDistance;
                for (int i = hashPosition; i <= max; ++i) {
                    if (this.table[i] == null) {
                        return false;
                    }
                    if (!this.table[i].equals(o)) continue;
                    return true;
                }
                return false;
            }
        }
    }

    static abstract class InternalBuilder<E>
    implements Iterable<E> {
        InternalBuilder() {
        }

        abstract InternalBuilder<E> with(E var1);

        abstract InternalBuilder<E> with(E[] var1, int var2);

        abstract boolean contains(Object var1);

        abstract IndexedImmutableSetImpl<E> build();

        abstract int size();

        @Override
        public abstract Iterator<E> iterator();

        public String toString() {
            StringBuilder result = new StringBuilder("[");
            boolean first = true;
            for (E e : this) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(e);
            }
            result.append("]");
            return result.toString();
        }

        InternalBuilder<E> probingOverheadFactor(short probingOverheadFactor) {
            return this;
        }
    }

    static final class SetBackedSet<E>
    extends IndexedImmutableSetImpl<E> {
        private final Map<E, Integer> elements;
        private final E[] flat;

        SetBackedSet(Map<E, Integer> elements, E[] flat) {
            super(elements.size());
            this.elements = elements;
            this.flat = flat;
        }

        @Override
        public int size() {
            return this.elements.size();
        }

        @Override
        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.elements.containsKey(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.elements.keySet().iterator();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.elements.keySet().toArray(a);
        }

        @Override
        public Object[] toArray() {
            return this.elements.keySet().toArray();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.elements.keySet().containsAll(c);
        }

        @Override
        public int elementToIndex(Object element) {
            Integer pos = this.elements.get(element);
            if (pos != null) {
                return pos;
            }
            return -1;
        }

        @Override
        public E indexToElement(int i) {
            if (i >= 0 && i < this.flat.length) {
                return this.flat[i];
            }
            return null;
        }

        static class Builder<E>
        extends InternalBuilder<E> {
            private final HashMap<E, Integer> delegate;
            private E[] flat;
            private final int expectedCapacity;

            Builder(int expectedCapacity) {
                this.delegate = new HashMap(expectedCapacity);
                this.expectedCapacity = expectedCapacity;
            }

            Builder(Collection<E> set) {
                int size = set.size();
                this.delegate = new HashMap(size);
                this.flat = GenericArrays.create(size);
                this.expectedCapacity = size;
                int i = 0;
                for (E e : set) {
                    this.delegate.put(e, i);
                    this.flat[i] = e;
                    ++i;
                }
            }

            @Override
            public Builder<E> with(E e) {
                int pos = this.delegate.size();
                this.delegate.put(e, pos);
                this.extendFlat();
                this.flat[pos] = e;
                return this;
            }

            @Override
            InternalBuilder<E> with(E[] flat, int size) {
                if (this.flat == null) {
                    this.flat = flat;
                    for (int i = 0; i < size; ++i) {
                        this.delegate.put(flat[i], i);
                    }
                } else {
                    for (int i = 0; i < size; ++i) {
                        this.with((Object)flat[i]);
                    }
                }
                return this;
            }

            @Override
            IndexedImmutableSetImpl<E> build() {
                if (this.delegate.isEmpty()) {
                    return IndexedImmutableSetImpl.empty();
                }
                return new SetBackedSet<E>(this.delegate, this.flat);
            }

            @Override
            int size() {
                return this.delegate.size();
            }

            @Override
            public Iterator<E> iterator() {
                return this.delegate.keySet().iterator();
            }

            @Override
            public String toString() {
                return this.delegate.keySet().toString();
            }

            @Override
            boolean contains(Object o) {
                return this.delegate.containsKey(o);
            }

            private void extendFlat() {
                if (this.flat == null) {
                    this.flat = GenericArrays.create(this.expectedCapacity);
                } else if (this.delegate.size() >= this.flat.length) {
                    this.flat = GenericArrays.extend(this.flat, this.flat.length + this.flat.length / 2 + 8);
                }
            }
        }
    }
}

