/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.javaagent;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.UnixDomainSocketAddress;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collection;
import net.bytebuddy.asm.Advice;
import org.opensearch.javaagent.StackCallerProtectionDomainChainExtractor;
import org.opensearch.javaagent.bootstrap.AgentPolicy;

public class SocketChannelInterceptor {
    @Advice.OnMethodEnter
    public static void intercept(@Advice.AllArguments Object[] args, @Advice.Origin Method method) throws Exception {
        block5: {
            Object host;
            Collection<ProtectionDomain> callers;
            Policy policy;
            block4: {
                policy = AgentPolicy.getPolicy();
                if (policy == null) {
                    return;
                }
                StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
                callers = walker.walk(StackCallerProtectionDomainChainExtractor.INSTANCE);
                Object object = args[0];
                if (!(object instanceof InetSocketAddress)) break block4;
                InetSocketAddress address = (InetSocketAddress)object;
                if (AgentPolicy.isTrustedHost((String)address.getHostString())) break block5;
                host = address.getHostString() + ":" + address.getPort();
                SocketPermission permission = new SocketPermission((String)host, "connect,resolve");
                for (ProtectionDomain domain : callers) {
                    if (policy.implies(domain, permission)) continue;
                    throw new SecurityException("Denied access to: " + (String)host + ", domain " + String.valueOf(domain));
                }
                break block5;
            }
            host = args[0];
            if (host instanceof UnixDomainSocketAddress) {
                UnixDomainSocketAddress address = (UnixDomainSocketAddress)host;
                NetPermission permission = new NetPermission("accessUnixDomainSocket");
                for (ProtectionDomain domain : callers) {
                    if (policy.implies(domain, permission)) continue;
                    throw new SecurityException("Denied access to: " + String.valueOf(address) + ", domain " + String.valueOf(domain));
                }
            }
        }
    }
}

