# -*- coding:binary -*-

require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::Kerberos::Client do
  subject do
    mod = ::Msf::Exploit.new
    mod.extend described_class

    mod.send(:initialize)
    mod
  end

  # KDC_ERR_PREAUTH_FAILED - Additional pre-authentication required
  let(:as_rep_err_preauth_required) do
    decode_kerb_response(
      "\x7e\x81\xae\x30\x81\xab\xa0\x03\x02\x01\x05\xa1\x03\x02\x01\x1e"\
      "\xa4\x11\x18\x0f\x32\x30\x32\x32\x30\x35\x32\x36\x31\x35\x34\x32"\
      "\x33\x33\x5a\xa5\x05\x02\x03\x06\x1c\x2b\xa6\x03\x02\x01\x19\xa9"\
      "\x0c\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xaa\x1f\x30"\
      "\x1d\xa0\x03\x02\x01\x01\xa1\x16\x30\x14\x1b\x06\x6b\x72\x62\x74"\
      "\x67\x74\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xac\x51"\
      "\x04\x4f\x30\x4d\x30\x16\xa1\x03\x02\x01\x0b\xa2\x0f\x04\x0d\x30"\
      "\x0b\x30\x09\xa0\x03\x02\x01\x17\xa1\x02\x04\x00\x30\x12\xa1\x03"\
      "\x02\x01\x13\xa2\x0b\x04\x09\x30\x07\x30\x05\xa0\x03\x02\x01\x17"\
      "\x30\x09\xa1\x03\x02\x01\x02\xa2\x02\x04\x00\x30\x09\xa1\x03\x02"\
      "\x01\x10\xa2\x02\x04\x00\x30\x09\xa1\x03\x02\x01\x0f\xa2\x02\x04"\
      "\x00"
    )
  end

  # KDC_ERR_C_PRINCIPAL_UNKNOWN
  let(:as_rep_err_c_principal_unknown) do
    decode_kerb_response(
      "\x7e\x5a\x30\x58\xa0\x03\x02\x01\x05\xa1\x03\x02\x01\x1e\xa4\x11" \
      "\x18\x0f\x32\x30\x32\x32\x30\x35\x31\x33\x30\x30\x31\x35\x35\x33" \
      "\x5a\xa5\x05\x02\x03\x02\xd0\xf5\xa6\x03\x02\x01\x06\xa9\x0c\x1b" \
      "\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xaa\x1f\x30\x1d\xa0" \
      "\x03\x02\x01\x01\xa1\x16\x30\x14\x1b\x06\x6b\x72\x62\x74\x67\x74" \
      "\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c"
    )
  end

  # KDC_ERR_PREAUTH_FAILED - Pre-authentication information was invalid
  let(:as_rep_err_preauth_failed) do
    decode_kerb_response(
      "\x7e\x81\x8d\x30\x81\x8a\xa0\x03\x02\x01\x05\xa1\x03\x02\x01\x1e" \
      "\xa4\x11\x18\x0f\x32\x30\x32\x32\x30\x35\x32\x36\x31\x35\x34\x33" \
      "\x32\x38\x5a\xa5\x05\x02\x03\x0e\x51\x88\xa6\x03\x02\x01\x18\xa9" \
      "\x0c\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xaa\x1f\x30" \
      "\x1d\xa0\x03\x02\x01\x01\xa1\x16\x30\x14\x1b\x06\x6b\x72\x62\x74" \
      "\x67\x74\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xac\x30" \
      "\x04\x2e\x30\x2c\x30\x16\xa1\x03\x02\x01\x0b\xa2\x0f\x04\x0d\x30" \
      "\x0b\x30\x09\xa0\x03\x02\x01\x17\xa1\x02\x04\x00\x30\x12\xa1\x03" \
      "\x02\x01\x13\xa2\x0b\x04\x09\x30\x07\x30\x05\xa0\x03\x02\x01\x17"
    )
  end

  # KRB_AP_ERR_SKEW - Clock skew too great
  let(:as_rep_err_skew) do
    decode_kerb_response(
      "\x7e\x5a\x30\x58\xa0\x03\x02\x01\x05\xa1\x03\x02\x01\x1e\xa4\x11" \
      "\x18\x0f\x32\x30\x32\x32\x30\x35\x31\x32\x32\x33\x33\x37\x33\x35" \
      "\x5a\xa5\x05\x02\x03\x04\x66\x1e\xa6\x03\x02\x01\x25\xa9\x0c\x1b" \
      "\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xaa\x1f\x30\x1d\xa0" \
      "\x03\x02\x01\x01\xa1\x16\x30\x14\x1b\x06\x6b\x72\x62\x74\x67\x74" \
      "\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c"
    )
  end

  let(:as_rep_success_preauth) do
    decode_kerb_response(
      "\x6b\x82\x05\xa3\x30\x82\x05\x9f\xa0\x03\x02\x01\x05\xa1\x03\x02" \
      "\x01\x0b\xa2\x2c\x30\x2a\x30\x28\xa1\x03\x02\x01\x13\xa2\x21\x04" \
      "\x1f\x30\x1d\x30\x1b\xa0\x03\x02\x01\x12\xa1\x14\x1b\x12\x50\x4f" \
      "\x44\x38\x2e\x4c\x41\x4e\x6e\x6f\x2e\x70\x72\x65\x61\x75\x74\x68" \
      "\xa3\x0a\x1b\x08\x50\x4f\x44\x38\x2e\x4c\x41\x4e\xa4\x17\x30\x15" \
      "\xa0\x03\x02\x01\x01\xa1\x0e\x30\x0c\x1b\x0a\x6e\x6f\x2e\x70\x72" \
      "\x65\x61\x75\x74\x68\xa5\x82\x04\x09\x61\x82\x04\x05\x30\x82\x04" \
      "\x01\xa0\x03\x02\x01\x05\xa1\x0a\x1b\x08\x50\x4f\x44\x38\x2e\x4c" \
      "\x41\x4e\xa2\x1d\x30\x1b\xa0\x03\x02\x01\x02\xa1\x14\x30\x12\x1b" \
      "\x06\x6b\x72\x62\x74\x67\x74\x1b\x08\x50\x4f\x44\x38\x2e\x4c\x41" \
      "\x4e\xa3\x82\x03\xcd\x30\x82\x03\xc9\xa0\x03\x02\x01\x12\xa1\x03" \
      "\x02\x01\x02\xa2\x82\x03\xbb\x04\x82\x03\xb7\x99\x95\xd9\xec\xba" \
      "\x54\xd8\x84\x21\x1c\x22\x9a\x14\x2c\xab\xa9\x8f\xfd\xb0\x5f\x43" \
      "\xa6\x7b\xb7\x8c\xfb\x82\x58\x62\xcb\x4d\xc7\xda\x7a\x18\x95\x89" \
      "\x14\x41\xa1\xd0\x8c\xd7\xc0\x8d\x3f\x86\xd6\x50\x7e\xf7\x43\x76" \
      "\x19\x9f\x6d\x77\x10\xe1\xf7\x1f\x63\xf1\xf8\x87\x05\x7d\x97\xc0" \
      "\xda\x5c\xf4\x6f\x8c\x02\x16\xd2\x85\x12\x24\x50\x1d\x69\x93\x07" \
      "\x35\x32\x9f\x7b\xb3\xc7\x6b\xf5\xdf\xd5\xea\xed\x5b\xa2\x10\x14" \
      "\x86\xbd\x44\xbd\x4c\x27\x13\xe5\xa1\xf9\xd2\xb8\x07\x0e\xf3\xb8" \
      "\x7a\x0f\x82\x15\x7a\x5c\x0b\x98\xe5\x32\x9b\x69\x70\x66\xe7\xde" \
      "\x5e\x3b\x3c\x6d\xd7\xcb\x04\xaa\x39\xe6\x35\xcc\x2e\xd3\x10\x99" \
      "\xf6\xec\x8a\x9f\xd8\x24\x5f\xce\xc8\x68\x22\xfd\x24\x71\x2c\x23" \
      "\xce\x84\x3c\xb3\xb0\xc9\x78\x8e\x97\x77\x80\xaf\xde\xc5\x16\x35" \
      "\x31\xfe\xfe\xec\xb8\x17\x78\x3f\xf3\x06\xe8\x86\x82\xa4\xb8\x97" \
      "\xe6\x2a\xc5\x54\x08\x7f\x65\x03\xed\x29\xdc\xc8\xf2\xbf\xc2\x58" \
      "\x7e\xd3\xa5\x97\x22\xec\x40\xd2\x9d\x13\xea\xfb\xe1\xbf\x52\x4f" \
      "\xac\x9e\x29\x80\x35\xee\xc2\x55\x8a\x04\xdd\x0a\x21\x60\x92\xb8" \
      "\xc7\x87\xa9\x07\x40\x53\xc0\x15\xde\x07\xdb\xe9\x0a\x78\x7a\xf7" \
      "\x9a\x1d\x0f\x18\x54\x83\xa1\xb7\xdf\x59\xb2\xb7\x3f\xec\xa4\x1a" \
      "\xd5\x1e\x79\x8e\xec\xfa\xda\x5d\x46\x7c\x49\x14\x61\xdb\xa3\x77" \
      "\x66\xde\x4f\x5b\x5f\x36\xbf\xc8\x75\xd5\x06\xb4\xf9\x38\x0f\xa2" \
      "\x06\xed\x12\x53\x7f\x34\x79\x45\x4f\x95\x10\xe7\x17\x8b\x13\x1f" \
      "\x81\x77\xe4\xcb\x1e\x46\xfb\x6f\x57\xbc\x37\x53\x2a\xa2\xf4\xec" \
      "\x0e\xa1\x02\xaa\x35\xbc\x66\xc0\xcd\x65\x12\x9d\xd2\xfe\xae\xd5" \
      "\xa5\x8e\x10\x34\x6d\x6e\x87\x31\xfd\xb5\xa4\x6d\x60\x35\x90\x10" \
      "\x0b\x2c\x76\x17\x51\x44\x72\x5d\x2d\x47\x4e\xfa\x63\x96\x70\x31" \
      "\x6e\xef\x6a\xfb\x47\xd2\x46\x23\x6c\x92\xc6\x1d\x3b\xfc\x79\x66" \
      "\xde\xb9\xba\x63\x2f\x53\x26\xa4\x9a\x91\x53\xa3\xd4\x76\x2f\x86" \
      "\xf4\x31\xa2\x50\xca\x6f\x30\x01\x87\xf3\x35\x63\xe4\x16\x00\x56" \
      "\xf4\x64\x80\xc2\x90\x7b\x14\x5a\x6a\x6c\x85\x75\x6d\x74\x5e\x90" \
      "\xbf\xc6\x7a\x63\xee\xca\x46\x12\x67\x04\x99\xd9\xc2\xca\x3f\x99" \
      "\x2c\x65\x72\x5a\x15\x13\x7e\x61\x33\x05\x0f\xac\x49\xb1\x38\x8c" \
      "\x20\xd9\x56\x34\x93\x89\x6d\x65\xd7\x40\x1a\x68\x37\xb8\x6f\x2f" \
      "\xf2\x6d\xa0\xd3\x0b\x20\x7c\x9d\x91\xb0\x47\x8c\xca\xc8\xd6\x8b" \
      "\x23\x13\xb3\x13\x12\x5e\x98\x6f\x69\x6a\x6f\x26\x8e\xb8\x4d\x85" \
      "\x8c\x9e\x76\x12\x31\xdb\x21\xe4\xcb\x90\xdf\xbc\xfb\x0d\xef\xb5" \
      "\xc5\x01\xd2\x4b\x4f\x40\x8c\x8f\x99\x20\x60\x30\xcc\xad\xa6\x2c" \
      "\x58\xc2\xa8\x10\x99\x80\xb9\x0a\xa1\x3f\x0a\xf6\x8a\x3a\x54\x6a" \
      "\xfa\x4f\x47\xf5\x0c\x9d\x56\xcf\x90\x43\x8a\x65\xd3\x93\xfc\x76" \
      "\x1b\x92\xd7\x05\x78\x6f\xda\x70\x2d\x70\xdf\x05\xa7\xd4\x6f\xd9" \
      "\xd6\x8a\x99\x95\x06\xe0\xf0\x6d\x52\xe0\xd8\x36\x9f\xa4\x1f\xee" \
      "\x84\x05\xf2\x0f\xc7\x70\xba\x8b\x61\xf8\xe2\x33\xe2\x7a\x96\x5e" \
      "\x14\xbc\x7f\x49\xe7\x4e\x97\x7e\x9a\x70\x96\xc0\xf6\xcb\x6f\x5d" \
      "\x06\x22\x31\x06\x4d\xdf\xdc\xe8\x77\x91\x88\x06\x87\xf6\x3c\x47" \
      "\x92\xca\xe9\x87\x38\x3d\xaf\x40\x33\x3c\xd6\xdd\x35\x8d\x12\x24" \
      "\x35\xc3\xf0\xa5\x9e\x8b\xa4\xe1\x94\x27\x55\x10\x59\x3c\xcb\x1e" \
      "\x35\x10\xb4\x10\x6d\xf3\x17\xf7\xea\x5e\x31\x55\xd1\x4c\x9e\xd1" \
      "\xde\x08\x61\xce\xcb\x94\xcc\x3f\x86\x65\x99\x21\x5c\x96\x33\x22" \
      "\x9e\xc5\x6d\x0a\xf5\x28\x63\x0d\x9c\xbd\x32\x41\x81\x2d\x46\xdd" \
      "\xf6\x00\x5c\x88\x62\x15\x87\x13\x60\xd1\xa1\x6a\x67\xbc\x45\x71" \
      "\x38\xec\xba\x78\xf6\xd0\x1f\x32\x21\x37\x79\x60\xc7\x48\xb7\xe0" \
      "\x9c\x55\x65\x73\xe6\x3b\x5d\x6a\xf0\xf8\x6f\x38\x41\xe5\x8b\xde" \
      "\xa2\x62\x57\x1b\x33\x0d\x00\xa2\xec\x18\x6f\x2e\xfc\x46\xa4\x49" \
      "\xdd\x5a\x5e\x7a\x6d\xfb\x96\xfe\x74\x22\xd7\x57\x3c\x00\x31\x1c" \
      "\x56\x6e\xae\xa9\x15\x45\x54\xec\x8e\xef\x32\x01\xb8\xf8\x41\xff" \
      "\x9f\x4c\x21\x68\xa4\x22\xb7\x36\x7c\x68\x68\x05\x50\x1a\xd7\xf4" \
      "\xd6\x33\x6f\xcb\x53\x5e\x87\x38\x4e\x76\x81\x77\x98\x50\x5c\xa2" \
      "\xf4\x34\x88\x81\xdb\x43\x9a\x2f\x60\x9b\xe1\xb9\x3c\x87\xf5\x3c" \
      "\x7a\x7e\x97\x1f\x53\x69\x02\x0e\x67\x97\xdb\x05\x42\x38\x35\x71" \
      "\x51\x2d\xa4\xb8\x04\x1c\x44\xeb\x8d\x81\xc1\xd7\xcf\x25\x39\x86" \
      "\x03\xc1\x74\x98\x01\x8e\x2c\x16\xa3\x99\xdf\x38\xa0\xcd\xf9\x8f" \
      "\xe0\x98\xa6\x82\x01\x31\x30\x82\x01\x2d\xa0\x03\x02\x01\x12\xa1" \
      "\x03\x02\x01\x04\xa2\x82\x01\x1f\x04\x82\x01\x1b\xb3\x98\xdd\x38" \
      "\x7b\xd0\xae\xe1\xf3\x76\x0f\xa8\x3c\x2a\x9b\x85\xb0\x7d\x64\xf3" \
      "\xb1\xd9\x78\xf3\x28\x05\xc7\x3f\xb4\x09\xcc\xdc\x6e\x4c\xdd\xc9" \
      "\xf8\xc9\x7a\x19\xa3\xda\x86\xc9\x15\x1d\x95\x8b\x90\x05\x8e\x1e" \
      "\x73\xca\xa1\x1c\xfa\x86\x10\x01\x2d\x5d\x29\x0c\x03\x3e\x67\xaa" \
      "\xf6\xc9\xde\xf9\x7a\xd7\xa2\x4e\xb3\x25\xb3\x57\x26\xfc\x44\x92" \
      "\x04\x08\xd1\x59\x50\x36\x0e\x2a\xd7\xbc\x26\x95\xcd\xda\xce\x87" \
      "\x32\x2c\x20\x69\xfb\x34\x94\x25\xe2\x33\x5f\xea\xb1\x37\xff\x7f" \
      "\x23\xf2\x7f\x26\x02\x08\x51\x55\xe5\x24\x4b\x01\x2e\x62\xcc\x98" \
      "\xd6\x2f\x0e\x5d\x50\x8a\x78\xe0\x87\xa0\x46\xa3\x5f\x01\x36\x61" \
      "\x65\xa9\x78\x21\x0f\xe8\x26\x1a\x12\xdd\xb7\x1a\x08\x3a\xcc\x0a" \
      "\xc9\xb4\x92\x2f\x5c\xe1\x1b\x4a\xaf\x07\x33\xe1\x5f\xf3\xc9\x5e" \
      "\xc5\x0d\xff\x79\x7b\x84\x9d\x82\x60\xf8\x12\x13\x3e\xf1\xea\xf7" \
      "\xe5\x0d\xf2\xe0\x83\x1c\x16\xf7\x61\x3b\x6d\x66\xc1\xbf\x60\x32" \
      "\x71\xdd\x4e\xcf\x77\x92\xc1\xc4\xa0\x88\x1b\x5f\x30\x22\x3b\x31" \
      "\x3a\x12\x35\xd2\x8b\x12\x51\x26\x12\x75\xab\x8e\xfd\x5a\xfe\x6c" \
      "\xe6\x26\x60\xa4\xfd\x06\xd0\x81\x8d\x68\x5f\x59\x43\x0f\x6b\xdd" \
      "\x6d\x91\xd1\x15\x32\xd3\x13\xc1\x2b\xb3\xec\x5b\x52\xee\x8d\x2d" \
      "\x8e\x25\x3c\xea\x30\xe6\x09"
    )
  end

  # Success - no error
  let(:as_rep_success) do
    decode_kerb_response(
      "\x6b\x82\x05\x5b\x30\x82\x05\x57\xa0\x03\x02\x01\x05\xa1\x03\x02" \
      "\x01\x0b\xa3\x0c\x1b\x0a\x44\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c" \
      "\xa4\x17\x30\x15\xa0\x03\x02\x01\x01\xa1\x0e\x30\x0c\x1b\x0a\x62" \
      "\x61\x73\x69\x63\x5f\x75\x73\x65\x72\xa5\x82\x04\x13\x61\x82\x04" \
      "\x0f\x30\x82\x04\x0b\xa0\x03\x02\x01\x05\xa1\x0c\x1b\x0a\x44\x45" \
      "\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xa2\x1f\x30\x1d\xa0\x03\x02\x01" \
      "\x01\xa1\x16\x30\x14\x1b\x06\x6b\x72\x62\x74\x67\x74\x1b\x0a\x44" \
      "\x45\x4d\x4f\x2e\x4c\x4f\x43\x41\x4c\xa3\x82\x03\xd3\x30\x82\x03" \
      "\xcf\xa0\x03\x02\x01\x17\xa1\x03\x02\x01\x02\xa2\x82\x03\xc1\x04" \
      "\x82\x03\xbd\x2e\xe3\xe5\x8e\xb6\xe1\x0f\x3c\xf4\x03\x7d\xf0\xfd" \
      "\x7f\x76\xc6\x7d\x55\xc4\x91\x28\x48\xbd\xe0\xe2\xbe\xc5\xc2\xe7" \
      "\x62\x02\xc8\x67\x50\x96\xa8\x3e\x3e\x6c\x89\xa2\x0f\x7d\xaa\x98" \
      "\x2a\x92\x69\x1f\xf2\x6b\x4b\x5f\xcd\x8e\x51\xe5\xab\x72\x57\x01" \
      "\xd6\x55\x37\x34\xdc\x7c\x69\x63\x3d\xff\x97\xc5\x58\xb5\x5f\x3f" \
      "\xce\x3a\xdb\xa7\xf9\x73\x63\x19\xa1\xe3\x50\x86\xb3\xf7\x1d\xbf" \
      "\x8c\x63\x05\xce\x98\x82\x6a\x19\x69\x88\x52\xc6\x55\x4b\x6b\x06" \
      "\x8c\x20\xba\xa6\x5e\x4f\x7e\xd9\x62\xe0\xf7\xcc\x31\x76\xc1\x4f" \
      "\xc3\x8b\x20\x32\x00\x2f\x41\x59\xaf\x5b\x6c\x92\xd9\xaf\x6d\xc2" \
      "\xd3\x0a\x76\xce\x92\xf2\xcb\x89\x4c\x47\xe8\xb7\xf0\x5d\xdf\x97" \
      "\xbf\x74\x18\x4f\xe3\x8b\x3c\xf3\x21\x46\xb6\x16\x15\x5e\xc2\x57" \
      "\x16\xfe\x6b\xb2\x76\xb6\x42\x31\xfb\x6a\xe4\xc2\xb3\xf7\x99\x30" \
      "\xd0\x4b\x74\xb2\x16\x11\x92\x36\x32\xb0\xec\x7b\xe4\x7d\xa1\xb1" \
      "\xbe\x52\x10\x25\x95\xb5\x0f\x14\xe8\xd4\x84\xd9\x2d\xf1\x67\x54" \
      "\xd3\x24\x02\xb1\x69\xa0\x3c\x62\x69\x6e\x59\xec\xbd\xa0\xb4\xb4" \
      "\xe7\x31\xb9\xa9\x53\xb8\x76\x31\xf8\x24\x45\x18\x5e\x03\xed\x13" \
      "\xd3\xc3\xef\x79\x13\xea\x14\x69\x8b\x22\xe2\x2d\x56\x4c\xdd\x76" \
      "\xe2\xe0\xe6\x1b\x0e\xb8\xc1\xe8\xd0\x86\xcf\x23\x08\xba\xa5\xd5" \
      "\xd2\x12\x3e\x8f\x11\x52\x07\x40\x2c\xa6\x0c\x92\x31\x57\xaa\xcb" \
      "\x4e\xa2\xba\x69\x78\xab\x8b\xcd\x37\xd8\x78\xe7\x40\x42\x21\x4f" \
      "\xa9\x2d\x4f\xac\x56\x50\xe8\xd1\xc5\xe5\xdf\x82\x2d\x6e\xbe\xa5" \
      "\x5f\xf9\x84\xe0\xc2\x27\x5c\x77\x56\xac\x92\x6e\x3d\x33\x44\xa0" \
      "\x8e\xe9\xc4\x21\x2a\x9c\x2e\xe8\xcd\x26\xd9\x72\x53\xb1\xcb\x4a" \
      "\xc3\x2e\xb9\x54\x6f\x15\xfd\x16\xa4\x50\xbf\xe0\x0f\x2f\x48\x64" \
      "\x98\x2e\xb8\x91\xa8\xaa\x8d\x36\x4a\x48\x5e\x05\xe3\x72\x42\xa1" \
      "\xb9\x84\x54\x90\x8e\x01\x04\x06\x89\xef\x3c\x11\x31\x75\x25\xac" \
      "\x08\xe9\x0d\xb9\x35\x10\x69\x3e\xbe\x0e\x61\x02\x25\xdc\xf3\x17" \
      "\xdb\xd5\x49\xe8\xc1\xc6\x1b\x0e\x0a\x20\x64\x8c\xcf\x0e\x65\xc5" \
      "\x49\xb1\xba\x70\x1f\xdd\x07\x62\xd4\xce\xa3\x0a\xa1\xbc\x95\xed" \
      "\x2b\x5a\x6f\x8a\x35\x78\xa5\x97\x99\xab\x3f\x0d\x78\x3d\x5a\xcf" \
      "\xbc\xfc\xfe\xdc\xf0\x89\xef\xeb\x4c\x22\xd2\xde\x20\x6b\x52\x32" \
      "\x6d\x81\x5f\x64\x70\xef\xd7\x88\x90\x34\x94\x75\xa6\x60\xbe\x54" \
      "\x3b\x6a\x26\x8c\xe7\xaa\x5a\x26\x93\xec\x79\xf6\x23\x68\xef\xf5" \
      "\xc7\x24\x0b\x78\x63\xf4\x7e\x31\x3b\xcb\x77\x22\xd0\x39\xf0\x41" \
      "\xcc\x94\x81\x5c\xd4\xf2\x13\xd7\xe9\x08\x69\xfb\xbe\xbf\x4d\xfe" \
      "\x59\x89\x6a\xeb\x5a\xef\x96\x92\x5b\x80\x23\x8a\xcc\xc0\x1f\x03" \
      "\xd9\x99\x2b\x92\xe9\xea\x5b\x90\xce\x75\x8a\x6e\xd7\xcc\xae\xc6" \
      "\xa4\x5e\x73\x34\x6a\x08\x3e\xe9\xca\x2b\xc9\x41\x72\xe4\xd6\x6d" \
      "\x88\x1c\x8e\x98\xc9\xa4\x9d\x69\x0b\x2c\x65\x1b\xb1\xbf\x78\xca" \
      "\x92\xd2\x0f\x0f\x01\x47\xf3\x02\x0e\x23\x15\xde\x18\x1c\x4e\x33" \
      "\x7a\x65\x37\xaa\x70\x13\x3b\xd3\x45\x71\x1f\xc4\xbc\xa8\xc9\xf3" \
      "\xe0\xe4\x2e\x52\x3f\x0d\xed\xc5\x4f\xf3\x5d\xe8\xe9\xaa\x97\x4c" \
      "\x48\xf9\x01\xab\x0a\x3f\x36\xf7\xa6\x30\xef\x31\xc7\x1e\x46\xa3" \
      "\x97\x59\x57\xbf\x22\xe5\xe9\xf5\x4b\xc9\x52\x68\x51\xcb\x15\xb1" \
      "\xd9\x00\x51\x06\xfb\x54\xbc\x28\xa3\xa7\x6d\x3b\xb1\x8e\x36\x0a" \
      "\x3c\x39\xce\xda\x46\x7f\xed\x22\x42\x0e\xa7\x41\xe6\x64\xe8\x7f" \
      "\x25\xd0\x77\x0f\x45\xf9\xbe\xb6\x8c\x9f\x33\x76\x49\x13\x2b\x2e" \
      "\x19\x50\x6c\xee\x52\x6b\x6b\xf8\x13\xf4\x4e\x3c\xeb\x0c\x6e\x03" \
      "\xb6\x71\xab\xea\xbb\xed\x71\xac\xc3\x1e\x7a\x19\x31\x2c\x87\x52" \
      "\xb8\x5d\x4c\x75\x31\x2a\xe1\xc0\x9b\x49\x65\xe1\xb5\xcc\xbc\xd6" \
      "\x01\x85\xb5\x34\x60\x25\x9d\x89\xe2\x34\xa8\x45\xe7\x77\xbf\x23" \
      "\xa5\x4b\xc5\x5d\x14\xfc\x65\x1a\x95\xd7\xcf\x05\xde\x6a\x5d\xcc" \
      "\xa8\xed\x22\x66\x0c\x9d\xcc\x9f\x53\x3a\xa0\xd2\xfb\x41\xa3\x9e" \
      "\x3b\xcb\xb0\xd1\xbe\x3f\xe0\xab\xf9\x37\xc2\x11\x19\xe8\x6a\x57" \
      "\x26\x77\x12\x49\x44\xb4\xd0\xe7\xba\x08\x45\x7f\x9b\x13\xf0\x4a" \
      "\x5e\x6c\x30\x5a\xaf\x4e\x70\x2f\x7e\x1a\xb8\xde\xe9\x48\x66\xf7" \
      "\x84\x43\xed\xb6\x6c\xac\xb6\x9f\xaa\xc7\x7d\xc9\x27\x63\xde\x01" \
      "\xf0\x93\x15\x7a\x7e\x34\x2d\x5f\xdc\xca\x6d\xa0\xb5\x3a\x7c\xfb" \
      "\xd2\x5a\x00\x2e\xfa\xfb\x19\x90\xb2\xd1\xe6\x0e\x20\x03\x2a\xca" \
      "\x32\xbd\x52\x20\x37\xca\x46\x1f\x0f\x8f\x51\xf1\xee\xb3\x47\x27" \
      "\xa6\x82\x01\x0b\x30\x82\x01\x07\xa0\x03\x02\x01\x17\xa1\x03\x02" \
      "\x01\x03\xa2\x81\xfa\x04\x81\xf7\x35\xc5\x7a\x5b\xa5\x68\x28\xdd" \
      "\x87\x03\xf4\x13\x0a\xc3\xb0\xe6\x20\xf5\xbb\x22\x47\xec\x7d\x35" \
      "\x6e\x15\xde\x1c\x37\xfe\x8b\x92\xba\x84\x29\xec\x19\xbb\x95\xa4" \
      "\x50\xc2\x38\xf2\x9a\x75\xf6\x0e\xcc\x20\x6a\xfb\xea\x9a\x72\xb5" \
      "\x58\x3b\xb4\x6b\x9e\x5d\xcb\x52\x7c\x94\x00\x2a\xfd\x22\xcf\x3c" \
      "\x73\xb9\xa8\x22\xf6\x29\xff\x37\x34\x8f\x43\x65\xb8\xf3\x10\x2a" \
      "\x63\xc5\xc3\x5e\xbc\xf0\xd6\x7f\x8f\x18\xc1\x07\xc5\xa3\x16\x6e" \
      "\x12\x5f\x6f\xf1\xb7\x66\x63\xf0\xe1\xf6\x6f\x41\xda\x53\x40\xec" \
      "\xac\x68\x2b\xe9\x17\x40\xe2\xfa\x83\x94\x28\x8a\x60\x7d\x6e\x1b" \
      "\xd4\xaf\xe7\x98\x98\x4e\x3d\x52\x8c\xb9\x2b\xd5\x0a\xbb\x12\x21" \
      "\xcd\xa0\x3f\x21\xd6\x14\x78\x92\x37\x5b\x8b\xa4\x9e\xab\xf2\xf4" \
      "\xca\x23\x2d\x06\xf7\xa1\x6d\x07\xb1\xe8\x66\xce\x52\x0b\x60\xe5" \
      "\x51\x7b\xe8\x4e\x30\x47\x24\x04\xdc\xeb\xb3\x2f\x59\x87\x92\xa7" \
      "\x14\x4b\xbe\x4b\xf1\x34\x6f\x94\x8a\x1a\x36\x00\xac\xee\xff\x87" \
      "\xd5\x58\xe8\xa4\x92\x6e\xfb\x8b\x72\x96\xbb\x04\x09\x01\xd3\xb8" \
      "\x9e\x54\x62\x48\x73\x6d\xe6\x13\xbb\x3c\xe8\x26\x88\xe4\xcc"
    )
  end

  def decode_kerb_response(data)
    Rex::Proto::Kerberos::Client.new.send(:decode_kerb_response, data)
  end

  describe '#send_request_tgt_pkinit' do
    let(:pfx) do
      cert_string = <<~EOF
        MIIMhgIBAzCCDFAGCSqGSIb3DQEHAaCCDEEEggw9MIIMOTCCBt8GCSqGSIb3
        DQEHBqCCBtAwggbMAgEAMIIGxQYJKoZIhvcNAQcBMBwGCiqGSIb3DQEMAQYw
        DgQIgPy56+eB0goCAggAgIIGmOkWeSvCf4O/HACpvP0fcX/jlUajBJw0DtvZ
        dnDHUHj4bZfjhoG7dOcCVO8wuSM8djnfXOtNcK+JUJSiMYN9uO1FpUex5v1H
        Dl/H5SqqfH+iqu4/fDNDx+q/vJzzQKFJ7I+spSa4KnsFO/upU4f7B1TUtEOC
        AG4CtM5Za2dXdCmbjReh812Rp1UUxhlCkbb177cj1WP0j+25Clu96q/gXNeI
        CiwrEinbxCmPI5GcK68dwGEEYiGoBOsLWdRMBhwP0xt289sLPoKTnM07c+Ww
        CDdlEtFI0AQhxAPbOYlQ5x7rT5tjUtzsefz/yYghH4MkmOi5YKVZd5KvS6O0
        Ux3rhfXt4NS0vD+aATCDvxZ8mi9WDGH096lQm6KuOueljSaV6tIoJ+TZiQph
        lvB8vlcpM3KvJTLqHS+tRKwRxZe1YGBthkLp9QFshaDmtx0e1q4HsiJm4yba
        wf7R+EDoNxrP0lTAObY6QrZXiqHLPKbj4b30qYdsWmrV9v0EtbZN/U6P7ZFI
        zcmw+dH13E50YLG7ytl0PSY6f7UcFmCtVjyCeHQU7Pk1hNUZ9J8nusMlWrA5
        K+8QSJmpIzpdGT0dKnCWq7LN2uEkiHyOYFxWQUP4q6n+WaqcVDRMRG5MEl3Y
        HoVQxqpM1itb4cgg2iByfVX5Baga34ZYbbCr/luJgbINRvzlDNBM9dpptXJ7
        hf2YTpFrfj99RyBPPzU92GgFnqoSFn56/QKmef67V36Qjfj81cDxeAQ2SQo1
        QsClMy58bFGqrDBvLZ6vZy4bxH4agvKYFLvx2JlEDi5cpJtRc1zYi59z2NDv
        l/dCNer5tA/7oosAHOm8AMXOkkoLGfK+dlpa9brJqkIWzM8n4by1ruV+5G8d
        GuVkjqSUij8ziN0wdMG8tDFt6Y3f4EgpOCcAxpC8MBiz2gp+H5xdOkmxGUz3
        6MCBY13J1LBypT57eax0znhm7+g1QDPRTpGP9JweJER7eS2Frq9ODrTVxIoC
        yj/qzdjnvYRq5NDTeHH4H1SPacXcJRU/aOS8O4IZJjzRP3AVBqwVzusIOxbv
        FhgkEw1kUfuMjXkONLO5ziMuE5Xi8ErS+dLEK8m4BvZe8iGO0vdl3kamI58F
        OZDSp6qTsf3/YUGLeR66nKVe9jnbJJ5mK3cWMS3RWkO6+GFs9K3s47Y5iF2z
        OX2LrZNd4u1FdccUXmX5SgOY4VJoFOOQ8sGy7nCcn3Ri6tNzLqYAS8veHSob
        kST66XOrElkcgAw37mHXiJ16wWD/HWXSaSv9+42mutOR1l2y/Gh+N5nXc7Vv
        mk+9u71C7i4dIAYsq79H2U6TahYU/FGu62fZIkHfDVFJOz1sjuJgl4jokLs/
        mPPYNf9dN3e0ipqAxCx/WkeH8lD2V+7i+6RLTI1UIrsy/kA/naIIHtaIOElE
        IdhkNkBQyI4bneQKh0WuXeBCWnUO7TAap0bG6Utyq2Jr7YAfwXZmWF4lrl89
        BA+RDu6+Y9rM2TNitwRvxnc/sGHweh70/IRHBO8jIhPBn02Z9RxDrXtvtHdh
        qRjxMPGoGLLCcbBKT4/ZkSIGV2wI4ZFlGm3gR0qgeZVMQ4K7Y0b6VhhD880i
        UZgthF1ScRGUOte5Z98v+uX/Pv9dUQGKRmAWNgZZQ9Jc/gH+3pf0dYq9xo/f
        ZapH+bp26d63LkXqv6BbcW/Ij9fvzmO1COSbf442hRuTVDP3NyYGfqderu/1
        eN+tySHofCeRem0GQBe9HLDrRY+rmbxTLoq7xiQOA15ZR5LuNlj/U9Xah/o+
        GCp82VHuK+nmfbULQ5w0Oh2v5//uKH/ex73PfP5Dyo3YFRbV2gqpQsMc6tcf
        PWjfsQW+F3UweP7TcJROflZerpMHVPkgC+gTXsOZRLFNxboMSmK9+AFto/10
        FCqH6GMs2nNBTdar/9umZe6zl6+cEs8C869cb/fmWEnv5SUZWpT2OK5zB7e/
        TjR4ykSiG/LehvnxIAt1lreApTHdTatAXFyyPaqfEw1E4YO73iO5PouZG+FL
        8R3uomPMp0LcmpPm+SyXBAghf1STt51jpHVEc8pc3Rrymgr/xUTlyj2TSf6a
        08jwmgybREgWicy9N3ErZLR95KY7V4pnBeKplG0DypFakQPZuBv9tph9sbpA
        M4XzDCSe0CW6LHmdMu49qfcNJhhg8WL2w7ByUDOmnlLPlpZRttz45lQUssbN
        QD6sWoH6jwLjKIoCVkwwlfohyuIlZOgx/x/cv2PbAKeRUrZeP3HXxRbFMIIF
        UgYJKoZIhvcNAQcBoIIFQwSCBT8wggU7MIIFNwYLKoZIhvcNAQwKAQKgggTu
        MIIE6jAcBgoqhkiG9w0BDAEDMA4ECAUPKVFnmFvtAgIIAASCBMg2fCv//SH2
        xg4ihTz+4pNd+xBhfTXwaNYwgUH4q1VxW1VD8iOWj1geOH7IsGRLq7T8hNjD
        RXMAE4pyDMBMKFQokGD0Zopp4pXL+6DSBCilT4mK67T2X3EsMRNER8XUoB6r
        PSDvk4o63WQ9Ne+SvobqB/hbcVq2tH0LxBbznikrI7J84OQOhzY+L/mbYV1R
        rPAj51XgS2M0Ogl/kzr/lnmXFDTyw7ThLvgCzt9rEoLekh9OpxESboAR7swl
        Ynim8HRVpp2SAa+WKkHlDbCWk4SNjvhWpFwdGJxL7O6ZIGq62f/UEjbVy5yA
        LnJnZBHNga4iM1rxHsyfeH26y/FY9pSw/BBxcImhBxExTd1Z4l/f9gc91B3S
        Ssvr6bRHBE51KS6b2R9/pAIZYVXN5oLU6jzFrxuWvBcbKUunvw7yZBQbHOOh
        1TQxCvX3xBBTBsMSRBB7nihxWpH7PgCFBHiQ8CxQMyS9ap6cvp2Bf4qjfPHE
        LaVXxrlJQ7t7gpJ2wPqxlC9bCkvH9F14j0+62jD8Ofq39ZdYjELCM0LxAR5A
        rJ2AM4Hl8veVko5e2OStsNIMsd4+StneNQQ3IIxpM6AeUMujOzQMUikj/S3J
        VdyLrPl2fTCnaY4fpl0bWEDYKyAGi7Kjs5FrLRJsE0kX0MrRsKVs0NOoti51
        v6d05Qs7TgfMIFturSRkk3BGC/Xp25U6PrwRKqO3NsUHO+8GYrGDFO/GfW8k
        fO6N7DdBMXVyI0tsYxhDSZvjmv2EFmTKz7EBBSBQvf27Dy0Hw42YItVTPyZK
        bzLexddpZmAU410cthopk08OR4JjmCOqTkfIWtF+ivfAguYOMMIfct4W0UgM
        08sMKPayagqv+TZJT4pawCrmMuRE0XGrOjOqoiz5RDe074qsjwMTESKncuRG
        OwzMMSIAToQFVerhW5i+7m6wzpxd/k4O9CyoXbVGwM9D0TEvpLTd6ouoEVDb
        ID66QXdf/YvQCZ/bu0nq/h3qE9HaRtOVDW9WUyuzDLnJoTYKPiXKR2FBVl92
        UkOc1zhD67Zhaj7ax8fPdJwv5zr0ovJuB/09+JF1IuGXGsThf1O/QbW/713l
        QVJiI6k2NVGOPkFtHkNE0SuGOuygetw+lTLflhFt/YTeafm0Thz3awgHWhv5
        HsblIzckk7G57eesP3u1YLZ7ZcbnQqtNfwuxQgT8KvdNv3skAlgz01Aq73Z0
        UMpoV7gN3DJnE9Zpp7oqYswbR7hmEAj5MKUl644rgrQ8XaembvnF+CRu+cOi
        Sq0neAkdeIBcw92PJBnHYaSyqSzPG1JKhbu/cpmwzYbYS3aOy7WSphbjQorc
        g68FNbHvlcH+y05M4F7LlV8wIRQmmO2fqw3UgcqIbwpd63j72SOU5lhnua+y
        a8gJNYDflc4z8qAOejBKy3cNzYmN3k2trn7ldirdAIETt2DBwtT7muXPZzm8
        bdmpJLOe8w1yk+LEIrSO/MBSN+dcJ5RYkGv09Wl864ufbjEjHVy0WAG73FZZ
        jvtabUeXlr5VwJX1LqvKKA2vu00LC/9J5DF+WkNvquY90KjoTVTcvLY3qNS8
        3LjKiyW0kNGPix3c0qCbbclcC9T87HtIf9e+oCD4OMFo9kFtiE1N35JwL8al
        5DAxNjAPBgkqhkiG9w0BCRQxAh4AMCMGCSqGSIb3DQEJFTEWBBSxQ8NE4vhV
        ZrR4mpY5Wmy43NZn8DAtMCEwCQYFKw4DAhoFAAQUBJLM9HgQ9MyzGIMzfC+4
        sOG5gYYECCOTwax2BRAH
      EOF

      cert = OpenSSL::PKCS12.new(Base64.decode64(cert_string), '')
      cert
    end

    # Success - no error
    let(:as_rep_success) do
      pkinit_response = <<~EOF
        a4IPCTCCDwWgAwIBBaEDAgELooIIvjCCCLowggi2oQMCARGiggitBIIIqaCC
        CKUwggihgIIIeTCCCHUGCSqGSIb3DQEHAqCCCGYwgghiAgEDMQswCQYFKw4D
        AhoFADCBuAYHKwYBBQIDAqCBrASBqTCBpqCBiAOBhQACgYEAw7l8V0njjkXl
        aMjxG6XcDGbxAldiYMsLSxEJ7QX6439x6g2MDTrw5FKJCPNJSj+JOyhG9g5m
        +GX4z615Pc7nxgAhkNGHpvP3EPHDGvufJRk+9RU6g2nDLvR6hj6Mpt4aMA6o
        aisHOezi4ISEHpllZyKw+Kbbz/dWxrmCT4bb0rahBgIEKZ1nx6IRGA8yMDIy
        MTEyODIyMDMxMFqgggXPMIIFyzCCBLOgAwIBAgITFgAAAAJ/t8m7NZmvIgAA
        AAAAAjANBgkqhkiG9w0BAQsFADBDMRUwEwYKCZImiZPyLGQBGRYFbG9jYWwx
        FDASBgoJkiaJk/IsZAEZFgRhZGYzMRQwEgYDVQQDEwthZGYzLURDMy1DQTAe
        Fw0yMjExMjgxMzEzMDlaFw0yMzExMjgxMzEzMDlaMBkxFzAVBgNVBAMTDmRj
        My5hZGYzLmxvY2FsMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA
        6AvxelytTQpx2h/I/SvxwE1KxWqxOox0m08ukGmf+ojnH4bvUsUUZpBi+mRM
        kOajBVfTyT9qIkdVByDGJT+E0vD6BG4fxOvsXJyT8coJR3ZLEsYQvayd5BZE
        M+TfeI66KGVrRZGLt7U8NFIRUczRanNbLCd8BsCHfNx7KQd82CuZGC32l9jV
        h1ClEVKNnn0uk4Yw4z4d0EetUWK69ZHfRK2Y1nx+0A7C/IDCP1bwoTaUxGVm
        e+DN5kRaZrhdtA6dhmFL4IZW1kMFINkH8NSvayiMWtW2r/rrdfaWlsuMe4ob
        Jp2LEc1a9W9Tg7sRBEU1CxPPzIThkqeTCKy/WrfxwwIDAQABo4IC4DCCAtww
        LwYJKwYBBAGCNxQCBCIeIABEAG8AbQBhAGkAbgBDAG8AbgB0AHIAbwBsAGwA
        ZQByMB0GA1UdJQQWMBQGCCsGAQUFBwMCBggrBgEFBQcDATAOBgNVHQ8BAf8E
        BAMCBaAweAYJKoZIhvcNAQkPBGswaTAOBggqhkiG9w0DAgICAIAwDgYIKoZI
        hvcNAwQCAgCAMAsGCWCGSAFlAwQBKjALBglghkgBZQMEAS0wCwYJYIZIAWUD
        BAECMAsGCWCGSAFlAwQBBTAHBgUrDgMCBzAKBggqhkiG9w0DBzAdBgNVHQ4E
        FgQUtLDOLg5c1UUn/YoT/HhI7XdFMmYwHwYDVR0jBBgwFoAU2a27dSYdeH6z
        1ZEEioxbeQvKO5QwgcQGA1UdHwSBvDCBuTCBtqCBs6CBsIaBrWxkYXA6Ly8v
        Q049YWRmMy1EQzMtQ0EsQ049ZGMzLENOPUNEUCxDTj1QdWJsaWMlMjBLZXkl
        MjBTZXJ2aWNlcyxDTj1TZXJ2aWNlcyxDTj1Db25maWd1cmF0aW9uLERDPWFk
        ZjMsREM9bG9jYWw/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdD9iYXNlP29i
        amVjdENsYXNzPWNSTERpc3RyaWJ1dGlvblBvaW50MIG8BggrBgEFBQcBAQSB
        rzCBrDCBqQYIKwYBBQUHMAKGgZxsZGFwOi8vL0NOPWFkZjMtREMzLUNBLENO
        PUFJQSxDTj1QdWJsaWMlMjBLZXklMjBTZXJ2aWNlcyxDTj1TZXJ2aWNlcyxD
        Tj1Db25maWd1cmF0aW9uLERDPWFkZjMsREM9bG9jYWw/Y0FDZXJ0aWZpY2F0
        ZT9iYXNlP29iamVjdENsYXNzPWNlcnRpZmljYXRpb25BdXRob3JpdHkwOgYD
        VR0RBDMwMaAfBgkrBgEEAYI3GQGgEgQQjz4p0G/vtESwpSrqSJmOmIIOZGMz
        LmFkZjMubG9jYWwwDQYJKoZIhvcNAQELBQADggEBABHQFEksHm4LJ0D6aiTZ
        1nyVT13EfrTkcwfJmnFv+/+mjYDz2bzn9073izILSK2EW91kfObCklhPYJo7
        gPmNKjVB8pJbX8jE0AOY46QxzrDkwyGwRjRYTtjwXHDKbaIaQHXXh2TDRWfL
        AbUa2JqIJeC3WtAfQ/8RkMq7Zfmatcf9v7lVKvvLCIG+SCCAedtwU10weswc
        0fnfrPevvQD4zZS44S4Zx5HDrKDqXqalBobO3UdLnwWYvOhaqk6nkbRUrkjf
        NHu+6SiKa6DVkbzQ3tLuFAYhZd1LbXNtAZbBFA9JWCyZEyH21H4WE6zVO1Vl
        h6NxtfPLgPBB3oK/8Pb7AmAxggHAMIIBvAIBATBaMEMxFTATBgoJkiaJk/Is
        ZAEZFgVsb2NhbDEUMBIGCgmSJomT8ixkARkWBGFkZjMxFDASBgNVBAMTC2Fk
        ZjMtREMzLUNBAhMWAAAAAn+3ybs1ma8iAAAAAAACMAkGBSsOAwIaBQCgPTAW
        BgkqhkiG9w0BCQMxCQYHKwYBBQIDAjAjBgkqhkiG9w0BCQQxFgQUARFzJqbw
        JrfNiB7Y9P2zldy9LccwDQYJKoZIhvcNAQEBBQAEggEAt+I1b5L4zFyZxvLE
        iqBH1q8VpVxNdMgAg14Oimk/RFfA4+cRlnWdm64XwRY16G5JnNh0T9SzmwCm
        t5RlxfSj6EZkw0W58FRjKPs/jRRNjzAV/cuc/9v4Cl78Vj21DfQAXgKG1I7z
        ZhLSgtu6c7NIQQgq0thZRwaGvCAvOSW09Mlj56ke5vNw+x9SFnu17pWCU8PO
        oZpH7JIZEpNQejQsp/MwmZXxJkEPFrcWgoZxpVfVmbFSmhtQSqBehoPs9KyF
        nQf9KPfFDp8T7h6RoONy6vChdFVogsHyEq20YmIQfIOFn4+YCXsWwwoCT43a
        QdMV5JIpgGUTgiBZLaDuU3xZH6EiBCCOyYypIoIchRxYS+flHwBgdXca1i6v
        GUvwajyR9YCF26MMGwpBREYzLkxPQ0FMpBowGKADAgEBoREwDxsNQWRtaW5p
        c3RyYXRvcqWCBOphggTmMIIE4qADAgEFoQwbCkFERjMuTE9DQUyiHzAdoAMC
        AQGhFjAUGwZrcmJ0Z3QbCmFkZjMubG9jYWyjggSqMIIEpqADAgESoQMCAQKi
        ggSYBIIElPkKnWSHxSwfVnyScyQbAZU3xkylltzhkTAZSMculnaqYtwzzThl
        ZXWYpAScbI1RchDIBgRwQ17Dwj/aWUf2a2ao/EKzIGccQjs2pY1jJO1qYgis
        ga7QdkqIQfrI9ruKszhdyJfEE4jrVD3aTnnQcFMuyrkITLVL3imY9Sb9j2QV
        PBheDes6sTQT8ix7Zqvmapr+x8DGYKStT1JwgN5JER5LN3t5jWfTljuLNSLg
        1AohCdCfFM6v4yRuWz/4QwkD1tLEr1PlNJBYfAAtG7qxTHbtcVGVro5lY7bC
        fpT//1mgaBQG7DdGFXVQZ0CQ6catl/UWCAT5c5pLNPQLSoVDl88eCse1EjfN
        S9cJhIbmZqhvLly2l3jg2nE9Gj/k1NYpcoZRu3uFIGzFAN5khqMvwzdZ73mD
        0TpwXuQa5t2khaCNif9IR1v/yJ0L83Uu7E2zf1oNl+nH1m5+UtJGZnUhMSUW
        FtuPemXWm0Cze+f+pG8+RdQH7CX0sMSKX6f73NQljMwTnHhNeiRJqjDDni5F
        kJnHGjtbLLFyVGS5xKbtuc8yJ7iW9KbLskt/tgYtY8d68O40QN1/KcqMPsBc
        XL5TPzfVPtZqsLH9xNxT3lf0Tth6zwXCnjhhGiDj9S7Q6OGVYTUiEBIPTW73
        N/pML+7YAz1dvJz30EG8nN2Iz1DD6o3V5bOYOgCebLNhXhNvCzC0VM0iDgxE
        VtIoCXGlKnBe6H1g8d+/41JTYaDlXpZGtsYZieNIrWqznufX+w0UgzDjmF+m
        g+1x8Cn8nlbwlwRZk/iNKSorS4SmJi9uMIr47hyRunRmrRiJ4K9GbpjZMWET
        EWdYaaNQpWAFqviCUrCxeVh6k5A0HE/JFQrFM4ok0TaW/uvsaqecL3LNU7ic
        Fr29wB8FgLbXeO0jlxNu/nQlTSZvfX4k4uNARW6rbOaQVgsBjXoae3qHB4H7
        llv7V1GsO3TmwFthSk/t/dNzF8FnrNcPJMBBNCUeA87IDcdtu0WG8M0O5ucI
        v/phKRZ1Ce6Zj9tADo9n9b9Z8ejl0aLNj2HedHvwLQGEtMcFnQ3Z03yFEyD7
        ypn9Qn1K0AIdDHUsXfPClPGtniML/0O1HjvzP6Z5zzaL7yoabHjpFLk0JXGR
        iT45144EHekiDNSBndkOF+CV2c6Tzq8rqznTHytIHZpq5dfnXpWCUHEwWtKX
        PGu7wEqO8nEZNZX3L2mQKvUX2A05wfBCAQiZ4h1eYnZeCzTnGOvqhHWKQ35P
        kCLxhQUQ3w/gGrnYPuW9zRSqVf5WUhaXk2vxEqKMjbekuGMgQJawXWo4UZu5
        Irh8nYUcsovdc7NaPubpdeuRmzJQXAoSWuTsUdU4IJZ+qbcIwmRfqGY5ayih
        5p7NGUb/u/TwPyd1OrCkrDYYmeZ9tqgv09RnxIA9zWcTr4Zw41dPtknjiK44
        rlF92OgvyvUHsRWuk9zgUCV9kurqdwZET23Sf8abcrPnsjjYyAozE1zNbUFx
        n5eesIOX6cB/mwg3WjNUt00iPpnzcMe9g1w8qNw6qLV6vDd+MWNzr5Dmr0eu
        kk2lGelQUfG3poIBHTCCARmgAwIBEqKCARAEggEMxIFR3IliLCO2dyA7boAI
        BEgwINPqRmNKU8fWvsA9Mwmz8CydL6LviRz+hmT8qzFD4RqWXvP9MyuMx3WL
        y1ESZukmO/W6+xyV2jo84qlyk4MWyMrSzTHQQWbnW5HiJf+X2qbHyItIewcO
        gX/b5w6rNb738umvePb0QNc4lJrY9ml4lcgXpgzu8krUjcRTn9IeYs40zXg5
        Hgy/LsSKJLSVbM+M84LW+wyfQGthfAp4asKZCISaF+yQMEmsGb/Y8zVNsZCL
        yU5toVLzMeZDtHbot2dysOEMEw9+uSsH2s5MoA9blI7wVMajgUzGNy/XgqjO
        DMKItGyr4fB5Z0NXQTgb3N0JN5f8KD6HjPDIpw==
      EOF

      decode_kerb_response(Base64.decode64(pkinit_response))
    end

    let(:mock_client) do
      instance_double(Rex::Proto::Kerberos::Client, close: nil)
    end

    let(:mock_decrypted_part) { double :mock_decrypted_part }
    let(:mock_kerberos_responses) { [] }

    before(:each) do
      allow(mock_client).to receive(:send_recv).and_return(*mock_kerberos_responses)
      allow(Rex::Proto::Kerberos::Client).to receive(:new).and_return(mock_client)
      # Skip decryption as part of the test; The use of build_dh in the implementation makes it impossible to decrypt the enc_part,
      # as the call to generate_key can't be mocked in openssl3, only in openssl 1.1.1
      allow(subject).to receive(:decrypt_kdc_as_rep_enc_part).and_return(mock_decrypted_part)
    end

    context 'when the authentication succeeds' do
      let(:mock_kerberos_responses) do
        [as_rep_success]
      end

      it 'returns the ticket' do
        res = subject.send_request_tgt_pkinit(
          server_name: 'krbtgt/adf3.local',
          username: 'Administrator',
          realm: 'adf3.local',
          pfx: pfx,
        )

        expect(res.ticket.realm).to eq('ADF3.LOCAL')
        expect(res.ticket.sname.name_string).to eq(['krbtgt', 'adf3.local'])
        expect(res.preauth_required).to be true
        expect(res.decrypted_part).to eq(mock_decrypted_part)
        expect(res.krb_enc_key).to include({ enctype: 18, key: a_string_matching(/\A.{32}\Z/m) })
        expect(mock_client).to have_received(:send_recv).once
      end
    end
  end

  describe '#send_request_tgt' do
    let(:mock_client) do
      instance_double(Rex::Proto::Kerberos::Client, close: nil)
    end

    let(:mock_kerberos_responses) { [] }

    before(:each) do
      allow(mock_client).to receive(:send_recv).and_return(*mock_kerberos_responses)
      allow(Rex::Proto::Kerberos::Client).to receive(:new).and_return(mock_client)
    end

    context 'when the account is unknown' do
      let(:mock_kerberos_responses) do
        [as_rep_err_c_principal_unknown]
      end

      it 'raises an erorr' do
        expect do
          subject.send_request_tgt(
            server_name: 'krbtgt/DEMO.local',
            client_name: 'unknown_user',
            password: 'password',
            realm: 'DEMO.local'
          )
        end.to raise_error(Rex::Proto::Kerberos::Model::Error::KerberosError, /Client not found in Kerberos database/)
        expect(mock_client).to have_received(:send_recv).once
      end
    end

    context 'when kerberos preauth is not required' do
      let(:mock_kerberos_responses) do
        [as_rep_success_preauth]
      end

      it 'returns the ticket' do
        res = subject.send_request_tgt(
          server_name: 'krbtgt/POD8.lan',
          client_name: 'no.preauth',
          password: nil,
          realm: 'POD8.lan'
        )

        expect(res.ticket.realm).to eq('POD8.LAN')
        expect(res.ticket.sname.name_string).to eq(['krbtgt', 'POD8.LAN'])
        expect(res.preauth_required).to be false
        expect(res.decrypted_part).to be_nil
        expect(res.krb_enc_key).to be_nil
        expect(mock_client).to have_received(:send_recv).once
      end

      it 'decrypts the ticket when the password is correct' do
        res = subject.send_request_tgt(
          server_name: 'krbtgt/POD8.lan',
          client_name: 'no.preauth',
          password: 'Password123!',
          realm: 'POD8.lan'
        )

        expect(res.ticket.realm).to eq('POD8.LAN')
        expect(res.ticket.sname.name_string).to eq(['krbtgt', 'POD8.LAN'])
        expect(res.preauth_required).to be false
        expect(res.decrypted_part.sname.name_string).to eq(['krbtgt','POD8.LAN']) # This verifies it decrypts
        expect(res.krb_enc_key[:enctype]).to eq(Rex::Proto::Kerberos::Crypto::Encryption::AES256)
        expect(mock_client).to have_received(:send_recv).once
      end

      it 'decrypts the ticket when the key is correct' do
        enc_key = Rex::Proto::Kerberos::Crypto::Aes256CtsSha1.new.string_to_key('Password123!', 'POD8.LANno.preauth')
        res = subject.send_request_tgt(
          server_name: 'krbtgt/POD8.lan',
          client_name: 'no.preauth',
          offered_etypes: [Rex::Proto::Kerberos::Crypto::Encryption::AES256],
          password: nil,
          key: enc_key,
          realm: 'POD8.lan'
        )

        expect(res.ticket.realm).to eq('POD8.LAN')
        expect(res.ticket.sname.name_string).to eq(['krbtgt', 'POD8.LAN'])
        expect(res.preauth_required).to be false
        expect(res.decrypted_part.sname.name_string).to eq(['krbtgt','POD8.LAN']) # This verifies it decrypts
        expect(res.krb_enc_key[:enctype]).to eq(Rex::Proto::Kerberos::Crypto::Encryption::AES256)
        expect(mock_client).to have_received(:send_recv).once
      end

      it 'returns the ticket when the password is incorrect' do
        res = subject.send_request_tgt(
          server_name: 'krbtgt/POD8.lan',
          client_name: 'no.preauth',
          password: 'wrong password',
          realm: 'POD8.lan'
        )

        expect(res.ticket.realm).to eq('POD8.LAN')
        expect(res.ticket.sname.name_string).to eq(['krbtgt', 'POD8.LAN'])
        expect(res.preauth_required).to be false
        expect(res.decrypted_part).to be_nil
        expect(res.krb_enc_key).to be_nil
        expect(mock_client).to have_received(:send_recv).once
      end

      it 'returns the ticket when the key is incorrect' do
        enc_key = Rex::Proto::Kerberos::Crypto::Aes256CtsSha1.new.string_to_key('wrong password', 'POD8.LANno.preauth')
        res = subject.send_request_tgt(
          server_name: 'krbtgt/POD8.lan',
          client_name: 'no.preauth',
          offered_etypes: [Rex::Proto::Kerberos::Crypto::Encryption::AES256],
          password: nil,
          key: enc_key,
          realm: 'POD8.lan'
        )

        expect(res.ticket.realm).to eq('POD8.LAN')
        expect(res.ticket.sname.name_string).to eq(['krbtgt', 'POD8.LAN'])
        expect(res.preauth_required).to be false
        expect(res.decrypted_part).to be_nil
        expect(res.krb_enc_key).to be_nil
        expect(mock_client).to have_received(:send_recv).once
      end

    end

    context 'when kerberos preauth is required' do
      context 'when the authentication succeeds' do
        let(:mock_kerberos_responses) do
          [as_rep_err_preauth_required, as_rep_success]
        end

        it 'returns the ticket' do
          res = subject.send_request_tgt(
            server_name: 'krbtgt/DEMO.local',
            client_name: 'basic_user',
            password: 'password',
            realm: 'DEMO.local'
          )

          expect(res.ticket.realm).to eq('DEMO.LOCAL')
          expect(res.ticket.sname.name_string).to eq(['krbtgt', 'DEMO.LOCAL'])
          expect(res.preauth_required).to be true
          expect(res.decrypted_part.srealm).to eq('DEMO.LOCAL')
          expect(res.decrypted_part.sname.name_string).to eq(['krbtgt', 'DEMO.LOCAL'])
          expect(res.decrypted_part.flags.enabled_flag_names).to eq(%i[FORWARDABLE PROXIABLE RENEWABLE INITIAL PRE_AUTHENT])
          expect(res.krb_enc_key).to eq({ enctype: 23, key: "\x88F\xF7\xEA\xEE\x8F\xB1\x17\xAD\x06\xBD\xD80\xB7Xl", salt: nil})
          expect(mock_client).to have_received(:send_recv).twice
        end
      end

      context 'when the authentication fails' do
        let(:mock_kerberos_responses) do
          [as_rep_err_preauth_required, as_rep_err_preauth_failed]
        end

        it 'returns the ticket' do
          expect do
            subject.send_request_tgt(
              server_name: 'krbtgt/DEMO.local',
              client_name: 'basic_user',
              password: 'password',
              realm: 'DEMO.local'
            )
          end.to raise_error(Rex::Proto::Kerberos::Model::Error::KerberosError, /Pre-authentication information was invalid/)
          expect(mock_client).to have_received(:send_recv).twice
        end
      end

      context 'when a clock skew error is returned' do
        let(:mock_kerberos_responses) do
          [as_rep_err_preauth_required, as_rep_err_skew]
        end

        it 'raises an error' do
          expect do
            subject.send_request_tgt(
              server_name: 'krbtgt/DEMO.local',
              client_name: 'basic_user',
              password: 'password',
              realm: 'DEMO.local'
            )
          end.to raise_error(Rex::Proto::Kerberos::Model::Error::KerberosError, /Clock skew too great.*off by \d+ seconds/)
          expect(mock_client).to have_received(:send_recv).twice
        end
      end
    end
  end
end
