/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.annotation.processing.Processor;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class Compiler {
    private Processor processor;
    private DiagnosticListener<JavaFileObject> diagnosticListener;
    private List<String> options = new ArrayList<String>();
    private File classOutput;
    private File sourceOutput;

    private static File createTempDir() throws IOException {
        File dir = Files.createTempDirectory("codegen", new FileAttribute[0]).toFile();
        dir.deleteOnExit();
        return dir;
    }

    public Compiler(Processor processor) {
        this(processor, new DiagnosticCollector<JavaFileObject>());
    }

    public Compiler(Processor processor, DiagnosticListener<JavaFileObject> diagnosticListener) {
        this.processor = processor;
        this.diagnosticListener = diagnosticListener;
    }

    public Compiler() {
        this(null);
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Compiler addOption(String option) {
        this.options.add(option);
        return this;
    }

    public File getClassOutput() {
        return this.classOutput;
    }

    public void setClassOutput(File classOutput) {
        this.classOutput = classOutput;
    }

    public File getSourceOutput() {
        return this.sourceOutput;
    }

    public void setSourceOutput(File sourceOutput) {
        this.sourceOutput = sourceOutput;
    }

    public boolean compile(Class ... types) throws Exception {
        return this.compile(Arrays.asList(types));
    }

    public boolean compile(List<Class> types) throws Exception {
        ArrayList<File> tmpFiles = new ArrayList<File>();
        for (Class type : types) {
            String source;
            String className = type.getCanonicalName();
            String fileName = className.replace(".", "/") + ".java";
            ClassLoader loader = type.getClassLoader();
            InputStream is = loader.getResourceAsStream(fileName);
            if (is == null) {
                throw new IllegalStateException("Can't find source on classpath: " + fileName);
            }
            try (Scanner scanner = new Scanner(is, "UTF-8").useDelimiter("\\A");){
                source = scanner.next();
            }
            String tmpFileName = System.getProperty("java.io.tmpdir") + "/" + fileName;
            File f = new File(tmpFileName);
            File parent = f.getParentFile();
            parent.mkdirs();
            try (PrintStream out = new PrintStream(new FileOutputStream(tmpFileName));){
                out.print(source);
            }
            tmpFiles.add(f);
        }
        return this.compile(tmpFiles.toArray(new File[tmpFiles.size()]));
    }

    public boolean compile(File ... sourceFiles) throws Exception {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fm = compiler.getStandardFileManager(this.diagnosticListener, null, null);
        if (this.classOutput == null) {
            this.classOutput = Compiler.createTempDir();
        }
        if (this.sourceOutput == null) {
            this.sourceOutput = Compiler.createTempDir();
        }
        fm.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singletonList(this.classOutput));
        fm.setLocation(StandardLocation.SOURCE_OUTPUT, Collections.singletonList(this.sourceOutput));
        Iterable<? extends JavaFileObject> fileObjects = fm.getJavaFileObjects(sourceFiles);
        NullWriter out = new NullWriter();
        JavaCompiler.CompilationTask task = compiler.getTask(out, fm, this.diagnosticListener, this.options, null, fileObjects);
        List<Processor> processors = Collections.singletonList(this.processor);
        task.setProcessors(processors);
        try {
            return task.call();
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

