/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.conn;

import liquibase.Scope;
import liquibase.change.ColumnConfig;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.executor.jvm.ChangelogJdbcMdcListener;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class MySQLCustomChangeLogHistoryService
extends StandardChangeLogHistoryService {
    private boolean serviceInitialized;

    public boolean supports(Database database) {
        return database instanceof MySQLDatabase;
    }

    public void init() throws DatabaseException {
        super.init();
        if (this.serviceInitialized) {
            return;
        }
        this.serviceInitialized = true;
        ExecutorService executorService = (ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class);
        if (executorService.getExecutor("jdbc", this.getDatabase()) instanceof LoggingExecutor) {
            return;
        }
        if (!this.existsDatabaseChangelogPK()) {
            this.createDatabaseChangelogPK();
        }
    }

    public int getPriority() {
        return super.getPriority() + 1;
    }

    private boolean existsDatabaseChangelogPK() throws DatabaseException {
        try {
            PrimaryKey example = new PrimaryKey();
            Table table = new Table();
            table.setSchema(new Schema(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName()));
            table.setName(this.getDatabaseChangeLogTableName());
            example.setTable(table);
            return SnapshotGeneratorFactory.getInstance().has((DatabaseObject)example, this.getDatabase());
        }
        catch (InvalidExampleException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private void createDatabaseChangelogPK() throws DatabaseException {
        block2: {
            AddPrimaryKeyStatement pkStatement = this.getAddDatabaseChangeLogPKStatement();
            try {
                ChangelogJdbcMdcListener.execute((Database)this.getDatabase(), ex -> ex.execute((SqlStatement)pkStatement));
                this.getDatabase().commit();
            }
            catch (DatabaseException e) {
                if (this.existsDatabaseChangelogPK()) break block2;
                throw e;
            }
        }
    }

    public AddPrimaryKeyStatement getAddDatabaseChangeLogPKStatement() {
        return new AddPrimaryKeyStatement(this.getLiquibaseCatalogName(), this.getLiquibaseSchemaName(), this.getDatabaseChangeLogTableName(), ColumnConfig.arrayFromNames((String)"ID, AUTHOR, FILENAME"), "PK_DATABASECHANGELOG");
    }
}

