/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import java.util.List;
import java.util.Locale;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.StaleObjectStateException;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.LockingStrategyException;
import org.hibernate.dialect.lock.PessimisticEntityLockException;
import org.hibernate.dialect.lock.internal.LockingExecutionContext;
import org.hibernate.engine.OptimisticLockStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.LockTimeoutException;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SimpleFromClauseAccessImpl;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.SqlTypedMappingJdbcParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.sql.results.spi.NoRowException;
import org.hibernate.sql.results.spi.SingleResultConsumer;
import org.hibernate.stat.spi.StatisticsImplementor;

public class SqlAstBasedLockingStrategy
implements LockingStrategy {
    private final EntityMappingType entityToLock;
    private final LockMode lockMode;
    private final Locking.Scope lockScope;

    public SqlAstBasedLockingStrategy(EntityPersister lockable, LockMode lockMode, Locking.Scope lockScope) {
        this.entityToLock = lockable.getRootEntityDescriptor();
        this.lockMode = lockMode;
        this.lockScope = lockScope;
    }

    @Override
    public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, LockingStrategyException {
        SessionFactoryImplementor factory = session.getFactory();
        LockOptions lockOptions = new LockOptions(this.lockMode);
        lockOptions.setScope(this.lockScope);
        lockOptions.setTimeOut(timeout);
        QuerySpec rootQuerySpec = new QuerySpec(true);
        NavigablePath entityPath = new NavigablePath(this.entityToLock.getRootPathName());
        EntityIdentifierMapping idMapping = this.entityToLock.getIdentifierMapping();
        LoaderSqlAstCreationState sqlAstCreationState = new LoaderSqlAstCreationState(rootQuerySpec, new SqlAliasBaseManager(), new SimpleFromClauseAccessImpl(), lockOptions, (fetchParent, creationState) -> ImmutableFetchList.EMPTY, true, new LoadQueryInfluencers(factory), factory.getSqlTranslationEngine());
        TableGroup rootTableGroup = this.entityToLock.createRootTableGroup(true, entityPath, null, null, () -> p -> {}, sqlAstCreationState);
        rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        sqlAstCreationState.getFromClauseAccess().registerTableGroup(entityPath, rootTableGroup);
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        SelectableMapping firstIdColumn = idMapping.getSelectable(0);
        sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(rootTableGroup.getPrimaryTableReference(), firstIdColumn), firstIdColumn.getJdbcMapping().getJdbcJavaType(), null, session.getTypeConfiguration());
        BasicResult idResult = new BasicResult(0, null, idMapping.getJdbcMapping(0));
        int jdbcParamCount = this.entityToLock.getVersionMapping() != null ? idMapping.getJdbcTypeCount() + 1 : idMapping.getJdbcTypeCount();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(jdbcParamCount);
        idMapping.breakDownJdbcValues(id, (valueIndex, value, jdbcValueMapping) -> SqlAstBasedLockingStrategy.handleRestriction(value, jdbcValueMapping, rootQuerySpec, sqlAstCreationState, rootTableGroup, jdbcParameterBindings), session);
        if (this.entityToLock.getVersionMapping() != null) {
            this.entityToLock.getVersionMapping().breakDownJdbcValues(version, (valueIndex, value, jdbcValueMapping) -> SqlAstBasedLockingStrategy.handleRestriction(value, jdbcValueMapping, rootQuerySpec, sqlAstCreationState, rootTableGroup, jdbcParameterBindings), session);
        }
        SelectStatement selectStatement = new SelectStatement(rootQuerySpec, List.of(idResult));
        JdbcOperationQuerySelect selectOperation = session.getDialect().getSqlAstTranslatorFactory().buildSelectTranslator(factory, selectStatement).translate(jdbcParameterBindings, sqlAstCreationState);
        JdbcSelectExecutor jdbcSelectExecutor = factory.getJdbcServices().getJdbcSelectExecutor();
        LockingExecutionContext lockingExecutionContext = new LockingExecutionContext(session);
        try {
            jdbcSelectExecutor.executeQuery(selectOperation, (JdbcParameterBindings)jdbcParameterBindings, (ExecutionContext)lockingExecutionContext, null, idResult.getResultJavaType().getJavaTypeClass(), 1, SingleResultConsumer.instance());
        }
        catch (LockTimeoutException e) {
            throw new PessimisticEntityLockException(object, String.format(Locale.ROOT, "Lock timeout exceeded attempting to lock row(s) for %s", object), e);
        }
        catch (NoRowException e) {
            if (this.entityToLock.optimisticLockStyle() != OptimisticLockStyle.NONE) {
                StatisticsImplementor statistics = session.getFactory().getStatistics();
                if (statistics.isStatisticsEnabled()) {
                    statistics.optimisticFailure(this.entityToLock.getEntityName());
                }
                throw new StaleObjectStateException(this.entityToLock.getEntityName(), id, "No rows were returned from JDBC query for versioned entity");
            }
            throw e;
        }
    }

    private static void handleRestriction(Object value, SelectableMapping jdbcValueMapping, QuerySpec rootQuerySpec, LoaderSqlAstCreationState sqlAstCreationState, TableGroup rootTableGroup, JdbcParameterBindings jdbcParameterBindings) {
        SqlTypedMappingJdbcParameter jdbcParameter = new SqlTypedMappingJdbcParameter(jdbcValueMapping);
        rootQuerySpec.applyPredicate(new ComparisonPredicate(sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(rootTableGroup.getTableReference(jdbcValueMapping.getContainingTableExpression()), jdbcValueMapping), ComparisonOperator.EQUAL, jdbcParameter));
        JdbcMapping jdbcMapping = jdbcValueMapping.getJdbcMapping();
        jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, value));
    }
}

