/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.jboss.logging.Logger;
import org.keycloak.events.EventType;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.grants.OAuth2GrantTypeBase;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.Urls;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ServiceAccountTokenRequestContext;
import org.keycloak.services.clientpolicy.context.ServiceAccountTokenResponseContext;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.AuthenticationSessionManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class ClientCredentialsGrantType
extends OAuth2GrantTypeBase {
    private static final Logger logger = Logger.getLogger(ClientCredentialsGrantType.class);

    public Response process(OAuth2GrantType.Context context) {
        this.setContext(context);
        if (this.client.isBearerOnly()) {
            this.event.detail("reason", "Bearer-only client not allowed to retrieve service account");
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Bearer-only client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (this.client.isPublicClient()) {
            this.event.detail("reason", "Public client not allowed to retrieve service account");
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Public client not allowed to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        if (!this.client.isServiceAccountsEnabled()) {
            this.event.detail("reason", "Client not enabled to retrieve service account");
            this.event.error("invalid_client");
            throw new CorsErrorResponseException(this.cors, "unauthorized_client", "Client not enabled to retrieve service account", Response.Status.UNAUTHORIZED);
        }
        UserModel clientUser = this.session.users().getServiceAccount(this.client);
        if (clientUser == null) {
            this.event.detail("reason", "The associated service account for the client does not exist");
            this.event.error("user_not_found");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "The associated service account for the client does not exist", Response.Status.UNAUTHORIZED);
        }
        String clientUsername = clientUser.getUsername();
        this.event.detail("username", clientUsername);
        this.event.user(clientUser);
        if (!clientUser.isEnabled()) {
            this.event.detail("reason", "User '" + clientUsername + "' disabled");
            this.event.error("user_disabled");
            throw new CorsErrorResponseException(this.cors, "invalid_request", "User '" + clientUsername + "' disabled", Response.Status.UNAUTHORIZED);
        }
        String scope = this.getRequestedScopes();
        RootAuthenticationSessionModel rootAuthSession = new AuthenticationSessionManager(this.session).createAuthenticationSession(this.realm, false);
        AuthenticationSessionModel authSession = rootAuthSession.createAuthenticationSession(this.client);
        authSession.setAuthenticatedUser(clientUser);
        authSession.setProtocol("openid-connect");
        authSession.setClientNote("iss", Urls.realmIssuer(this.session.getContext().getUri().getBaseUri(), this.realm.getName()));
        authSession.setClientNote("scope", scope);
        this.setAuthorizationDetailsNoteIfIncluded(authSession);
        UserSessionModel.SessionPersistenceState sessionPersistenceState = UserSessionModel.SessionPersistenceState.PERSISTENT;
        if (!this.useRefreshToken()) {
            sessionPersistenceState = UserSessionModel.SessionPersistenceState.TRANSIENT;
        }
        UserSessionModel userSession = new UserSessionManager(this.session).createUserSession(authSession.getParentSession().getId(), this.realm, clientUser, clientUsername, this.clientConnection.getRemoteHost(), "client_auth", false, null, null, sessionPersistenceState);
        this.event.session(userSession);
        AuthenticationManager.setClientScopesInSession(this.session, authSession);
        ClientSessionContext clientSessionCtx = TokenManager.attachAuthenticationSession(this.session, userSession, authSession);
        clientSessionCtx.setAttribute("grant_type", (Object)context.getGrantType());
        userSession.setNote("clientId", this.client.getClientId());
        userSession.setNote("client_id", this.client.getClientId());
        userSession.setNote("clientHost", this.clientConnection.getRemoteHost());
        userSession.setNote("clientAddress", this.clientConnection.getRemoteHost());
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new ServiceAccountTokenRequestContext((MultivaluedMap<String, String>)this.formParams, clientSessionCtx.getClientSession()));
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        this.updateUserSessionFromClientAuth(userSession);
        clientSessionCtx.getClientSession().setNote("first.offline.access", Boolean.TRUE.toString());
        return this.createTokenResponse(clientUser, userSession, clientSessionCtx, scope, true, responseBuilder -> new ServiceAccountTokenResponseContext((MultivaluedMap<String, String>)this.formParams, clientSessionCtx.getClientSession(), (TokenManager.AccessTokenResponseBuilder)responseBuilder));
    }

    public EventType getEventType() {
        return EventType.CLIENT_LOGIN;
    }

    @Override
    protected boolean useRefreshToken() {
        return this.clientConfig.isUseRefreshTokenForClientCredentialsGrant();
    }

    private void setAuthorizationDetailsNoteIfIncluded(AuthenticationSessionModel authSession) {
        String authorizationDetails = (String)this.formParams.getFirst((Object)"authorization_details");
        if (authorizationDetails != null) {
            authSession.setClientNote("authorization_details", authorizationDetails);
        }
    }
}

