/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.AsyncObserverExceptionHandler;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ArcContainerImpl;
import io.quarkus.arc.impl.AsyncEventDeliveryStage;
import io.quarkus.arc.impl.EventContextImpl;
import io.quarkus.arc.impl.EventMetadataImpl;
import io.quarkus.arc.impl.EventObjectTypeResolverBuilder;
import io.quarkus.arc.impl.HierarchyDiscovery;
import io.quarkus.arc.impl.TypeCachePollutionUtils;
import io.quarkus.arc.impl.TypeResolver;
import io.quarkus.arc.impl.Types;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.NotificationOptions;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.EventMetadata;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

class EventImpl<T>
implements Event<T> {
    private static final int DEFAULT_CACHE_CAPACITY = 4;
    private static final NotificationOptions EMPTY_OPTIONS = NotificationOptions.builder().build();
    private final HierarchyDiscovery injectionPointTypeHierarchy;
    private final Type eventType;
    private final Set<Annotation> qualifiers;
    private final ConcurrentMap<Class<?>, Notifier<? super T>> notifiers;
    private final InjectionPoint injectionPoint;
    private volatile transient Notifier<? super T> lastNotifier;
    private static final Logger LOGGER = Logger.getLogger(EventImpl.class);

    EventImpl(Type eventType, Set<Annotation> qualifiers, InjectionPoint injectionPoint) {
        this.eventType = this.initEventType(eventType);
        this.injectionPointTypeHierarchy = new HierarchyDiscovery(this.eventType);
        this.qualifiers = Set.copyOf(qualifiers);
        this.notifiers = new ConcurrentHashMap(4);
        this.injectionPoint = injectionPoint;
    }

    public void fire(T event) {
        Objects.requireNonNull(event, "Event cannot be null");
        this.getNotifier(event.getClass()).notify(event, ObserverExceptionHandler.IMMEDIATE_HANDLER, false);
    }

    public <U extends T> CompletionStage<U> fireAsync(U event) {
        return this.fireAsync(event, EMPTY_OPTIONS);
    }

    public <U extends T> CompletionStage<U> fireAsync(final U event, NotificationOptions options) {
        Objects.requireNonNull(options);
        final Notifier<T> notifier = this.getNotifier(event.getClass());
        Executor executor = options.getExecutor();
        if (executor == null) {
            executor = Arc.container().getExecutorService();
        }
        if (notifier.isEmpty()) {
            return AsyncEventDeliveryStage.completed(event, executor);
        }
        Supplier notifyLogic = new Supplier<U>(){

            @Override
            public U get() {
                CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler(new ArrayList<Throwable>(), Arc.container().instance(AsyncObserverExceptionHandler.class, new Annotation[0]).get());
                notifier.notify(event, exceptionHandler, true);
                EventImpl.this.handleExceptions(exceptionHandler);
                return event;
            }
        };
        CompletableFuture completableFuture = CompletableFuture.supplyAsync(notifyLogic, executor);
        return new AsyncEventDeliveryStage(completableFuture, executor);
    }

    private Notifier<? super T> getNotifier(Class<?> runtimeType) {
        Notifier<? super T> notifier = this.lastNotifier;
        if (notifier != null && notifier.runtimeType.equals(runtimeType)) {
            return notifier;
        }
        this.lastNotifier = this.notifiers.computeIfAbsent(runtimeType, new Function<Class<?>, Notifier<? super T>>(){

            @Override
            public Notifier<? super T> apply(Class<?> clazz) {
                return EventImpl.this.createNotifier(clazz);
            }
        });
        return this.lastNotifier;
    }

    public Event<T> select(Annotation ... qualifiers) {
        ArcContainerImpl.instance().registeredQualifiers.verify(qualifiers);
        HashSet<Annotation> mergedQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergedQualifiers, qualifiers);
        return new EventImpl<T>(this.eventType, mergedQualifiers, this.injectionPoint);
    }

    public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
        if (Types.containsTypeVariable(subtype)) {
            throw new IllegalArgumentException("Event#select(Class<U>, Annotation...) cannot be used with type variable parameter");
        }
        ArcContainerImpl.instance().registeredQualifiers.verify(qualifiers);
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(subtype, mergerdQualifiers, this.injectionPoint);
    }

    public <U extends T> Event<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        ArcContainerImpl.instance().registeredQualifiers.verify(qualifiers);
        if (Types.containsTypeVariable(subtype.getType())) {
            throw new IllegalArgumentException("Event#select(TypeLiteral, Annotation...) cannot be used with type variable parameter");
        }
        HashSet<Annotation> mergerdQualifiers = new HashSet<Annotation>(this.qualifiers);
        Collections.addAll(mergerdQualifiers, qualifiers);
        return new EventImpl<T>(subtype.getType(), mergerdQualifiers, this.injectionPoint);
    }

    private Notifier<? super T> createNotifier(Class<?> runtimeType) {
        Type eventType = this.getEventType(runtimeType);
        return EventImpl.createNotifier(runtimeType, eventType, this.qualifiers, ArcContainerImpl.unwrap(Arc.container()), this.injectionPoint);
    }

    static <T> Notifier<T> createNotifier(Class<?> runtimeType, Type eventType, Set<Annotation> qualifiers, ArcContainerImpl container, InjectionPoint injectionPoint) {
        return EventImpl.createNotifier(runtimeType, eventType, qualifiers, container, !Arc.container().strictCompatibility(), injectionPoint);
    }

    static <T> Notifier<T> createNotifier(Class<?> runtimeType, Type eventType, Set<Annotation> qualifiers, ArcContainerImpl container, boolean activateRequestContext, InjectionPoint injectionPoint) {
        HashSet<Annotation> normalizedQualifiers = new HashSet<Annotation>(qualifiers);
        if (normalizedQualifiers.isEmpty()) {
            normalizedQualifiers.add((Annotation)Default.Literal.INSTANCE);
        }
        normalizedQualifiers.add((Annotation)Any.Literal.INSTANCE);
        EventMetadataImpl metadata = new EventMetadataImpl(normalizedQualifiers, eventType, injectionPoint);
        ArrayList notifierObserverMethods = new ArrayList(container.resolveObserverMethods(eventType, normalizedQualifiers));
        return new Notifier(runtimeType, notifierObserverMethods, metadata, activateRequestContext);
    }

    private Type initEventType(Type type) {
        ParameterizedType parameterizedType;
        if (TypeCachePollutionUtils.isParameterizedType(type) && Event.class.isAssignableFrom(Types.getRawType((parameterizedType = TypeCachePollutionUtils.asParameterizedType(type)).getRawType()))) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    private Type getEventType(Class<?> runtimeType) {
        Type resolvedType = runtimeType;
        if (Types.containsTypeVariable(resolvedType)) {
            resolvedType = this.injectionPointTypeHierarchy.resolveType(resolvedType);
        }
        if (Types.containsTypeVariable(resolvedType)) {
            Type canonicalEventType = Types.getCanonicalType(runtimeType);
            TypeResolver objectTypeResolver = new EventObjectTypeResolverBuilder(this.injectionPointTypeHierarchy.getResolver().getResolvedTypeVariables(), new HierarchyDiscovery(canonicalEventType).getResolver().getResolvedTypeVariables()).build();
            resolvedType = objectTypeResolver.resolveType(canonicalEventType);
        }
        if (Types.containsTypeVariable(resolvedType)) {
            throw new IllegalArgumentException("CDI event payload cannot contain unresolved type variable; found type: " + String.valueOf(resolvedType));
        }
        return resolvedType;
    }

    private void handleExceptions(ObserverExceptionHandler handler) {
        List<Throwable> handledExceptions = handler.getHandledExceptions();
        if (!handledExceptions.isEmpty()) {
            CompletionException exception = null;
            exception = handledExceptions.size() == 1 ? new CompletionException(handledExceptions.get(0)) : new CompletionException(null);
            for (Throwable handledException : handledExceptions) {
                exception.addSuppressed(handledException);
            }
            throw exception;
        }
    }

    static class Notifier<T> {
        private final Class<?> runtimeType;
        private final List<ObserverMethod<? super T>> observerMethods;
        final EventMetadata eventMetadata;
        private final boolean hasTxObservers;
        private final boolean activateRequestContext;

        Notifier(Class<?> runtimeType, List<ObserverMethod<? super T>> observerMethods, EventMetadata eventMetadata) {
            this(runtimeType, observerMethods, eventMetadata, true);
        }

        Notifier(Class<?> runtimeType, List<ObserverMethod<? super T>> observerMethods, EventMetadata eventMetadata, boolean activateRequestContext) {
            this.runtimeType = runtimeType;
            this.observerMethods = observerMethods;
            this.eventMetadata = eventMetadata;
            boolean hasTxObservers = false;
            for (ObserverMethod<T> method : observerMethods) {
                if (!Notifier.isTxObserver(method)) continue;
                hasTxObservers = true;
                break;
            }
            this.hasTxObservers = hasTxObservers;
            this.activateRequestContext = activateRequestContext;
        }

        void notify(T event) {
            this.notify(event, ObserverExceptionHandler.IMMEDIATE_HANDLER, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void notify(T event, ObserverExceptionHandler exceptionHandler, boolean async) {
            if (!this.isEmpty()) {
                Predicate<ObserverMethod<?>> predicate;
                Predicate<ObserverMethod<?>> predicate2 = predicate = async ? ObserverMethodIsAsync.INSTANCE : ObserverMethodIsNotAsync.INSTANCE;
                if (!async && this.hasTxObservers) {
                    InstanceHandle<TransactionManager> transactionManagerInstance = Arc.container().instance(TransactionManager.class, new Annotation[0]);
                    try {
                        if (transactionManagerInstance.isAvailable() && transactionManagerInstance.get().getStatus() == 0) {
                            ArrayList deferredEvents = new ArrayList();
                            EventContextImpl<T> eventContext = new EventContextImpl<T>(event, this.eventMetadata);
                            for (ObserverMethod<? super T> observerMethod : this.observerMethods) {
                                if (!Notifier.isTxObserver(observerMethod)) continue;
                                deferredEvents.add(new DeferredEventNotification<T>(observerMethod, eventContext, Status.valueOf(observerMethod.getTransactionPhase())));
                            }
                            ArcSynchronization sync = new ArcSynchronization(deferredEvents);
                            TransactionManager transactionManager = transactionManagerInstance.get();
                            try {
                                transactionManager.getTransaction().registerSynchronization((Synchronization)sync);
                                predicate = predicate.and(ObserverMethodIsNotTxObserver.INSTANCE);
                            }
                            catch (Exception e) {
                                if (e.getCause() instanceof RollbackException || e.getCause() instanceof IllegalStateException || e.getCause() instanceof SystemException) {
                                    predicate = predicate.and(ObserverMethodIsNotAfterSuccessTxObserver.INSTANCE);
                                }
                            }
                        }
                    }
                    catch (SystemException e) {
                        LOGGER.debugf("Failure when trying to invoke TransactionManager#getStatus(). Stacktrace: %s", (Object)(e.getCause() != null ? e.getCause() : e));
                    }
                }
                if (this.activateRequestContext) {
                    ManagedContext requestContext = Arc.container().requestContext();
                    if (requestContext.isActive()) {
                        this.notifyObservers(event, exceptionHandler, predicate);
                    } else {
                        try {
                            requestContext.activate();
                            this.notifyObservers(event, exceptionHandler, predicate);
                        }
                        finally {
                            requestContext.terminate();
                        }
                    }
                } else {
                    this.notifyObservers(event, exceptionHandler, predicate);
                }
            }
        }

        private void notifyObservers(T event, ObserverExceptionHandler exceptionHandler, Predicate<ObserverMethod<?>> predicate) {
            EventContextImpl<T> eventContext = new EventContextImpl<T>(event, this.eventMetadata);
            for (ObserverMethod<? super T> observerMethod : this.observerMethods) {
                if (!predicate.test(observerMethod)) continue;
                try {
                    observerMethod.notify(eventContext);
                }
                catch (Throwable t) {
                    exceptionHandler.handle(t, observerMethod, eventContext);
                }
            }
        }

        boolean isEmpty() {
            return this.observerMethods.isEmpty();
        }

        private static boolean isTxObserver(ObserverMethod<?> observer) {
            return !observer.getTransactionPhase().equals((Object)TransactionPhase.IN_PROGRESS);
        }
    }

    protected static interface ObserverExceptionHandler {
        public static final ObserverExceptionHandler IMMEDIATE_HANDLER = (t, m, e) -> {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new ObserverException(t);
        };

        public void handle(Throwable var1, ObserverMethod<?> var2, EventContext<?> var3);

        default public List<Throwable> getHandledExceptions() {
            return Collections.emptyList();
        }
    }

    static class CollectingExceptionHandler
    implements ObserverExceptionHandler {
        private final List<Throwable> throwables;
        private final AsyncObserverExceptionHandler exceptionHandler;

        CollectingExceptionHandler(List<Throwable> throwables, AsyncObserverExceptionHandler exceptionHandler) {
            this.throwables = throwables;
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public void handle(Throwable throwable, ObserverMethod<?> observerMethod, EventContext<?> eventContext) {
            this.throwables.add(throwable);
            try {
                this.exceptionHandler.handle(throwable, observerMethod, eventContext);
            }
            catch (Exception e) {
                LOGGER.errorf((Throwable)e, "Cannot handle exception of an async observer: %s", (Object)throwable);
            }
        }

        @Override
        public List<Throwable> getHandledExceptions() {
            return this.throwables;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Status {
        ALL{

            @Override
            public boolean matches(int status) {
                return true;
            }
        }
        ,
        SUCCESS{

            @Override
            public boolean matches(int status) {
                return status == 3;
            }
        }
        ,
        FAILURE{

            @Override
            public boolean matches(int status) {
                return status != 3;
            }
        };


        public abstract boolean matches(int var1);

        public static Status valueOf(TransactionPhase transactionPhase) {
            if (transactionPhase == TransactionPhase.BEFORE_COMPLETION || transactionPhase == TransactionPhase.AFTER_COMPLETION) {
                return ALL;
            }
            if (transactionPhase == TransactionPhase.AFTER_SUCCESS) {
                return SUCCESS;
            }
            if (transactionPhase == TransactionPhase.AFTER_FAILURE) {
                return FAILURE;
            }
            throw new IllegalArgumentException("Unknown transaction phase " + String.valueOf(transactionPhase));
        }
    }

    static class DeferredEventNotification<T>
    implements Runnable {
        private ObserverMethod<? super T> observerMethod;
        private boolean isBeforeCompletion;
        private EventContext eventContext;
        private Status status;
        private static final Logger LOG = Logger.getLogger(DeferredEventNotification.class);

        DeferredEventNotification(ObserverMethod<? super T> observerMethod, EventContext eventContext, Status status) {
            this.observerMethod = observerMethod;
            this.isBeforeCompletion = observerMethod.getTransactionPhase().equals((Object)TransactionPhase.BEFORE_COMPLETION);
            this.eventContext = eventContext;
            this.status = status;
        }

        public boolean isBeforeCompletion() {
            return this.isBeforeCompletion;
        }

        public Status getStatus() {
            return this.status;
        }

        @Override
        public void run() {
            block6: {
                try {
                    ManagedContext reqContext = Arc.container().requestContext();
                    if (reqContext.isActive()) {
                        this.observerMethod.notify(this.eventContext);
                        break block6;
                    }
                    try {
                        reqContext.activate();
                        this.observerMethod.notify(this.eventContext);
                    }
                    finally {
                        reqContext.terminate();
                    }
                }
                catch (Exception e) {
                    LOG.errorf("Failure occurred while notifying a transational %s for event of type %s \n- please enable debug logging to see the full stack trace\n %s", this.observerMethod, (Object)this.eventContext.getMetadata().getType().getTypeName(), (Object)(e.getCause() != null && e.getMessage() != null ? "Cause: " + String.valueOf(e.getCause()) + " Message: " + e.getMessage() : "Exception caught: " + String.valueOf(e)));
                    LOG.debugf((Throwable)e, "Failure occurred while notifying a transational %s for event of type %s", this.observerMethod, (Object)this.eventContext.getMetadata().getType().getTypeName());
                }
            }
        }
    }

    private static class ObserverMethodIsNotAfterSuccessTxObserver
    implements Predicate<ObserverMethod<?>> {
        private static final Predicate<ObserverMethod<?>> INSTANCE = new ObserverMethodIsNotAfterSuccessTxObserver();

        private ObserverMethodIsNotAfterSuccessTxObserver() {
        }

        @Override
        public boolean test(ObserverMethod<?> observerMethod) {
            return !observerMethod.getTransactionPhase().equals((Object)TransactionPhase.AFTER_SUCCESS);
        }
    }

    private static class ObserverMethodIsNotTxObserver
    implements Predicate<ObserverMethod<?>> {
        private static final Predicate<ObserverMethod<?>> INSTANCE = new ObserverMethodIsNotTxObserver();

        private ObserverMethodIsNotTxObserver() {
        }

        @Override
        public boolean test(ObserverMethod<?> observerMethod) {
            return !Notifier.isTxObserver(observerMethod);
        }
    }

    private static class ObserverMethodIsNotAsync
    implements Predicate<ObserverMethod<?>> {
        private static final Predicate<ObserverMethod<?>> INSTANCE = new ObserverMethodIsNotAsync();

        private ObserverMethodIsNotAsync() {
        }

        @Override
        public boolean test(ObserverMethod<?> observerMethod) {
            return !observerMethod.isAsync();
        }
    }

    private static class ObserverMethodIsAsync
    implements Predicate<ObserverMethod<?>> {
        private static final Predicate<ObserverMethod<?>> INSTANCE = new ObserverMethodIsAsync();

        private ObserverMethodIsAsync() {
        }

        @Override
        public boolean test(ObserverMethod<?> observerMethod) {
            return observerMethod.isAsync();
        }
    }

    static class ArcSynchronization
    implements Synchronization {
        private List<DeferredEventNotification<?>> deferredEvents;

        ArcSynchronization(List<DeferredEventNotification<?>> deferredEvents) {
            this.deferredEvents = deferredEvents;
        }

        public void beforeCompletion() {
            for (DeferredEventNotification<?> event : this.deferredEvents) {
                if (!event.isBeforeCompletion()) continue;
                event.run();
            }
        }

        public void afterCompletion(int i) {
            for (DeferredEventNotification<?> event : this.deferredEvents) {
                if (event.isBeforeCompletion() || !event.getStatus().matches(i)) continue;
                event.run();
            }
        }
    }
}

