/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSHeader;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.util.JsonSerialization;

public abstract class JwsToken {
    protected JWSHeader jwsHeader;
    protected ObjectNode payload;
    protected String jws;
    protected JWSInput jwsInput;

    protected JwsToken(String jws) {
        this.parse(jws);
    }

    protected JwsToken(JWSHeader jwsHeader, ObjectNode payload) {
        this.jwsHeader = jwsHeader;
        this.payload = payload;
    }

    protected JwsToken(JWSHeader jwsHeader, ObjectNode payload, SignatureSignerContext signerContext) {
        this.jwsHeader = jwsHeader;
        this.payload = payload;
        this.jws = this.sign(signerContext);
    }

    public String sign(SignatureSignerContext signerContext) {
        this.jws = new JWSBuilder().header(this.jwsHeader).jsonContent(this.payload).sign(signerContext);
        try {
            this.jwsInput = new JWSInput(this.jws);
            this.jwsHeader = this.jwsInput.getHeader();
            this.payload = this.jwsInput.readJsonContent(ObjectNode.class);
        }
        catch (JWSInputException e) {
            throw new IllegalStateException(String.format("Got invalid JWS '%s'", this.jws), e);
        }
        return this.jws;
    }

    public void verifySignature(SignatureVerifierContext verifier) throws VerificationException {
        Objects.requireNonNull(verifier, "verifier must not be null");
        try {
            if (!verifier.verify(this.jwsInput.getEncodedSignatureInput().getBytes(StandardCharsets.UTF_8), this.jwsInput.getSignature())) {
                throw new VerificationException("Invalid jws signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }

    public Optional<String> getSdHashAlgorithm() {
        return Optional.ofNullable(this.payload.get("_sd_alg")).map(JsonNode::textValue);
    }

    public String getJws() {
        return this.jws;
    }

    public void setJws(String jws) {
        this.jws = jws;
    }

    public JWSInput getJwsInput() {
        return this.jwsInput;
    }

    public void setJwsInput(JWSInput jwsInput) {
        this.jwsInput = jwsInput;
        if (jwsInput != null) {
            this.setJwsHeader(jwsInput.getHeader());
            try {
                this.setPayload(jwsInput.readJsonContent(ObjectNode.class));
            }
            catch (JWSInputException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public JWSHeader getJwsHeader() {
        return this.jwsHeader;
    }

    public ObjectNode getJwsHeaderAsNode() {
        return (ObjectNode)JsonSerialization.mapper.convertValue((Object)this.jwsHeader, ObjectNode.class);
    }

    public void setJwsHeader(JWSHeader jwsHeader) {
        this.jwsHeader = jwsHeader;
    }

    public ObjectNode getPayload() {
        return this.payload;
    }

    public void setPayload(ObjectNode payload) {
        this.payload = payload;
    }

    private void parse(String jwsString) {
        try {
            this.jws = jwsString;
            this.jwsInput = new JWSInput(Objects.requireNonNull(jwsString, "jwsString must not be null"));
            this.jwsHeader = this.jwsInput.getHeader();
            this.payload = (ObjectNode)JsonSerialization.mapper.readValue(this.jwsInput.getContent(), ObjectNode.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

