/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderDataMarshaller;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.sessions.AuthenticationSessionModel;

public interface UserAuthenticationIdentityProvider<C extends IdentityProviderModel>
extends IdentityProvider<C> {
    public static final String EXTERNAL_IDENTITY_PROVIDER = "EXTERNAL_IDENTITY_PROVIDER";
    public static final String FEDERATED_ACCESS_TOKEN = "FEDERATED_ACCESS_TOKEN";

    public void preprocessFederatedIdentity(KeycloakSession var1, RealmModel var2, BrokeredIdentityContext var3);

    public void authenticationFinished(AuthenticationSessionModel var1, BrokeredIdentityContext var2);

    public void importNewUser(KeycloakSession var1, RealmModel var2, UserModel var3, BrokeredIdentityContext var4);

    public void updateBrokeredUser(KeycloakSession var1, RealmModel var2, UserModel var3, BrokeredIdentityContext var4);

    public Object callback(RealmModel var1, AuthenticationCallback var2, EventBuilder var3);

    public Response performLogin(AuthenticationRequest var1);

    public Response retrieveToken(KeycloakSession var1, FederatedIdentityModel var2);

    public void backchannelLogout(KeycloakSession var1, UserSessionModel var2, UriInfo var3, RealmModel var4);

    public Response keycloakInitiatedBrowserLogout(KeycloakSession var1, UserSessionModel var2, UriInfo var3, RealmModel var4);

    public IdentityProviderDataMarshaller getMarshaller();

    default public boolean supportsLongStateParameter() {
        return true;
    }

    public static interface AuthenticationCallback {
        public AuthenticationSessionModel getAndVerifyAuthenticationSession(String var1);

        public Response authenticated(BrokeredIdentityContext var1);

        public Response cancelled(IdentityProviderModel var1);

        public Response retryLogin(UserAuthenticationIdentityProvider<?> var1, AuthenticationSessionModel var2);

        public Response error(IdentityProviderModel var1, String var2);
    }
}

