/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.organization.admin.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.Objects;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelValidationException;
import org.keycloak.models.OrganizationModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.organization.OrganizationProvider;
import org.keycloak.organization.admin.resource.OrganizationIdentityProvidersResource;
import org.keycloak.organization.admin.resource.OrganizationInvitationResource;
import org.keycloak.organization.admin.resource.OrganizationMemberResource;
import org.keycloak.organization.validation.OrganizationsValidation;
import org.keycloak.representations.idm.OrganizationRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.AdminEventBuilder;

@Extension(name="x-smallrye-profile-admin", value="")
public class OrganizationResource {
    private final KeycloakSession session;
    private final OrganizationProvider provider;
    private final AdminEventBuilder adminEvent;
    private final OrganizationModel organization;

    public OrganizationResource(KeycloakSession session, OrganizationModel organization, AdminEventBuilder adminEvent) {
        this.session = session;
        this.provider = session == null ? null : (OrganizationProvider)session.getProvider(OrganizationProvider.class);
        this.organization = organization;
        this.adminEvent = adminEvent.resource(ResourceType.ORGANIZATION);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Returns the organization representation")
    @APIResponses(value={@APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=OrganizationRepresentation.class))})})
    public OrganizationRepresentation get() {
        return ModelToRepresentation.toRepresentation((OrganizationModel)this.organization, (boolean)false);
    }

    @DELETE
    @Tag(name="Organizations")
    @Operation(summary="Deletes the organization")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request")})
    public Response delete() {
        boolean removed = this.provider.remove(this.organization);
        if (removed) {
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
            return Response.noContent().build();
        }
        throw ErrorResponse.error("organization couldn't be deleted", Response.Status.BAD_REQUEST);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Tag(name="Organizations")
    @Operation(summary="Updates the organization")
    @APIResponses(value={@APIResponse(responseCode="204", description="No Content"), @APIResponse(responseCode="400", description="Bad Request"), @APIResponse(responseCode="409", description="Conflict")})
    public Response update(OrganizationRepresentation organizationRep) {
        if (!Objects.equals(this.organization.getName(), organizationRep.getName()) && this.provider.getAllStream(organizationRep.getName(), Boolean.valueOf(true), Integer.valueOf(-1), Integer.valueOf(-1)).findAny().isPresent()) {
            throw ErrorResponse.error("A organization with the same name already exists.", Response.Status.CONFLICT);
        }
        try {
            OrganizationsValidation.validateUrl((String)organizationRep.getRedirectUrl());
            RepresentationToModel.toModel((OrganizationRepresentation)organizationRep, (OrganizationModel)this.organization);
            this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(organizationRep).success();
            return Response.noContent().build();
        }
        catch (ModelValidationException | OrganizationsValidation.OrganizationValidationException ex) {
            throw ErrorResponse.error(ex.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    @Path(value="members")
    public OrganizationMemberResource members() {
        return new OrganizationMemberResource(this.session, this.organization, this.adminEvent);
    }

    @Path(value="invitations")
    public OrganizationInvitationResource invitations() {
        return new OrganizationInvitationResource(this.session, this.organization, this.adminEvent);
    }

    @Path(value="identity-providers")
    public OrganizationIdentityProvidersResource identityProvider() {
        return new OrganizationIdentityProvidersResource(this.session, this.organization, this.adminEvent);
    }
}

