/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.runtime.annotations.RegisterForProxy;
import java.util.ArrayList;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Type;

public class RegisterForProxyBuildStep {
    @BuildStep
    public void build(CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<NativeImageProxyDefinitionBuildItem> proxy) {
        for (AnnotationInstance annotationInstance : combinedIndexBuildItem.getIndex().getAnnotations(DotName.createSimple((String)RegisterForProxy.class.getName()))) {
            AnnotationValue targetsValue = annotationInstance.value("targets");
            ArrayList<String> types = new ArrayList<String>();
            if (targetsValue == null) {
                ClassInfo classInfo = annotationInstance.target().asClass();
                types.add(classInfo.name().toString());
                classInfo.interfaceNames().forEach(dotName -> types.add(dotName.toString()));
            } else {
                for (Type type : targetsValue.asClassArray()) {
                    types.add(type.name().toString());
                }
            }
            proxy.produce(new NativeImageProxyDefinitionBuildItem(types));
        }
    }
}

