/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.server.share.persister.PartitionFactory;
import org.apache.kafka.server.share.persister.PartitionStateSummaryData;
import org.apache.kafka.server.share.persister.PersisterResult;
import org.apache.kafka.server.share.persister.TopicData;

public class ReadShareGroupStateSummaryResult
implements PersisterResult {
    private final List<TopicData<PartitionStateSummaryData>> topicsData;

    private ReadShareGroupStateSummaryResult(List<TopicData<PartitionStateSummaryData>> topicsData) {
        this.topicsData = topicsData;
    }

    public static ReadShareGroupStateSummaryResult from(ReadShareGroupStateSummaryResponseData data) {
        return new Builder().setTopicsData(data.results().stream().map(readStateSummaryResult -> new TopicData(readStateSummaryResult.topicId(), readStateSummaryResult.partitions().stream().map(partitionResult -> PartitionFactory.newPartitionStateSummaryData(partitionResult.partition(), partitionResult.stateEpoch(), partitionResult.startOffset(), partitionResult.leaderEpoch(), partitionResult.errorCode(), partitionResult.errorMessage())).collect(Collectors.toList()))).collect(Collectors.toList())).build();
    }

    public List<TopicData<PartitionStateSummaryData>> topicsData() {
        return this.topicsData;
    }

    public static class Builder {
        private List<TopicData<PartitionStateSummaryData>> topicsData;

        public Builder setTopicsData(List<TopicData<PartitionStateSummaryData>> topicsData) {
            this.topicsData = topicsData;
            return this;
        }

        public ReadShareGroupStateSummaryResult build() {
            return new ReadShareGroupStateSummaryResult(this.topicsData);
        }
    }
}

