/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.NoSuchElementException;

class RectIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    AffineTransform affine;
    int index;

    RectIterator(Rectangle2D rectangle2D, AffineTransform affineTransform) {
        this.x = rectangle2D.getX();
        this.y = rectangle2D.getY();
        this.w = rectangle2D.getWidth();
        this.h = rectangle2D.getHeight();
        this.affine = affineTransform;
        if (this.w < 0.0 || this.h < 0.0) {
            this.index = 6;
        }
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index > 5;
    }

    @Override
    public void next() {
        ++this.index;
    }

    @Override
    public int currentSegment(float[] fArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        fArray[0] = (float)this.x;
        fArray[1] = (float)this.y;
        if (this.index == 1 || this.index == 2) {
            fArray[0] = fArray[0] + (float)this.w;
        }
        if (this.index == 2 || this.index == 3) {
            fArray[1] = fArray[1] + (float)this.h;
        }
        if (this.affine != null) {
            this.affine.transform(fArray, 0, fArray, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }

    @Override
    public int currentSegment(double[] dArray) {
        if (this.isDone()) {
            throw new NoSuchElementException("rect iterator out of bounds");
        }
        if (this.index == 5) {
            return 4;
        }
        dArray[0] = this.x;
        dArray[1] = this.y;
        if (this.index == 1 || this.index == 2) {
            dArray[0] = dArray[0] + this.w;
        }
        if (this.index == 2 || this.index == 3) {
            dArray[1] = dArray[1] + this.h;
        }
        if (this.affine != null) {
            this.affine.transform(dArray, 0, dArray, 0, 1);
        }
        return this.index == 0 ? 0 : 1;
    }
}

