/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageCodeRenderer;
import jetbrains.coverage.report.CoverageSourceData;
import jetbrains.coverage.report.CoverageStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDataBean {
    private ClassInfo myClassInfo;
    @Nullable
    private final CoverageSourceData mySourceData;

    public ClassDataBean(@NotNull ClassInfo classInfo, @Nullable CoverageSourceData sourceData) {
        this.myClassInfo = classInfo;
        this.mySourceData = sourceData;
    }

    public String getName() {
        return this.myClassInfo.getName();
    }

    public String getNamespace() {
        return this.myClassInfo.getNamespace();
    }

    public ClassInfo getClassData() {
        return this.myClassInfo;
    }

    public List<ClassDataBean> getInnerClasses() {
        ArrayList<ClassDataBean> result = new ArrayList<ClassDataBean>();
        this.collectInnerClasses(this.myClassInfo, result);
        Collections.sort(result, new Comparator<ClassDataBean>(){

            @Override
            public int compare(ClassDataBean o1, ClassDataBean o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return result;
    }

    private void collectInnerClasses(ClassInfo classInfo, List<ClassDataBean> result) {
        Collection<ClassInfo> innerClasses = classInfo.getInnerClasses();
        if (innerClasses != null) {
            for (ClassInfo cl : innerClasses) {
                result.add(new ClassDataBean(cl, this.mySourceData));
            }
            for (ClassInfo cl : innerClasses) {
                this.collectInnerClasses(cl, result);
            }
        }
    }

    public Collection<FileDataBean> getFiles() {
        if (this.mySourceData == null) {
            return Collections.emptyList();
        }
        final ArrayList<FileDataBean> data = new ArrayList<FileDataBean>(1);
        CoverageCodeRenderer renderer = new CoverageCodeRenderer(){
            private Collection<LineDataBean> myLines = new ArrayList<LineDataBean>();
            private String myCaption;

            public void writeSectionHeader(@NotNull String caption) {
                this.myCaption = caption;
            }

            public void writeCodeLine(int lineNumber, @NotNull CharSequence source, @Nullable CoverageStatus status) {
                this.myLines.add(new LineDataBean(lineNumber, source, status));
            }

            public void codeWriteFinished() {
                if (this.myLines.size() > 0 || this.myCaption != null) {
                    data.add(new FileDataBean(this.myCaption, this.myLines));
                }
                this.myLines = new ArrayList<LineDataBean>();
                this.myCaption = null;
            }
        };
        this.mySourceData.renderSourceCodeFor(this.myClassInfo, renderer);
        renderer.codeWriteFinished();
        return data;
    }

    public static final class LineDataBean {
        private int myLineNum;
        private CharSequence mySourceCode;
        private CoverageStatus myCoverageStatus;

        public LineDataBean(int lineNum, CharSequence sourceCode, @Nullable CoverageStatus coverageStatus) {
            this.myLineNum = lineNum;
            this.mySourceCode = sourceCode;
            this.myCoverageStatus = coverageStatus;
        }

        public int getLineNum() {
            return this.myLineNum;
        }

        public CharSequence getSourceCode() {
            return this.mySourceCode;
        }

        public String getCoverage() {
            return this.myCoverageStatus.name();
        }

        public boolean isExecutable() {
            return this.myCoverageStatus != null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileDataBean {
        private final String myCaption;
        private final Collection<LineDataBean> myLines;

        public FileDataBean(@Nullable String caption, @NotNull Collection<LineDataBean> lines) {
            this.myCaption = caption;
            this.myLines = lines;
        }

        @Nullable
        public String getCaption() {
            return this.myCaption;
        }

        @NotNull
        public Collection<LineDataBean> getLines() {
            return this.myLines;
        }
    }
}

