/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.webTypes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.polySymbols.webTypes.WebTypesLoadUtilKt;
import com.intellij.polySymbols.webTypes.json.WebTypes;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/polySymbols/webTypes/WebTypesJsonFilesCache;", "", "<init>", "()V", "WEB_TYPES_FILE_SUFFIX", "", "fromUrlNoCache", "Lcom/intellij/polySymbols/webTypes/json/WebTypes;", "url", "getWebTypesJson", "Ljava/io/InputStream;", "downloadWebTypesJson", "tarball", "intellij.platform.polySymbols"})
@ApiStatus.Internal
public final class WebTypesJsonFilesCache {
    @NotNull
    public static final WebTypesJsonFilesCache INSTANCE = new WebTypesJsonFilesCache();
    @NotNull
    private static final String WEB_TYPES_FILE_SUFFIX = ".web-types.json";

    private WebTypesJsonFilesCache() {
    }

    @NotNull
    public final WebTypes fromUrlNoCache(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return WebTypesLoadUtilKt.readWebTypes(this.getWebTypesJson(url));
    }

    @NotNull
    public final InputStream getWebTypesJson(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.endsWith$default((String)url, (String)"json", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)url, (String)"file:", (boolean)false, (int)2, null)) {
            return new FileInputStream(new File(new URI(url)));
        }
        File downloadedJson = new File(PathManager.getSystemPath(), "web-types/" + FilesKt.getNameWithoutExtension((File)new File(url)) + WEB_TYPES_FILE_SUFFIX);
        if (!downloadedJson.exists()) {
            downloadedJson.getParentFile().mkdirs();
            String content = this.downloadWebTypesJson(url);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode webTypesJson = mapper.readTree(content);
            mapper.writer().writeValue(downloadedJson, (Object)webTypesJson);
        }
        return new FileInputStream(downloadedJson);
    }

    private final String downloadWebTypesJson(String tarball) {
        byte[] byArray = HttpRequests.request((String)tarball).readBytes(null);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readBytes(...)");
        byte[] contents = byArray;
        BufferedInputStream bi = new BufferedInputStream(new ByteArrayInputStream(contents));
        GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
        TarArchiveInputStream input = new TarArchiveInputStream((InputStream)gzi);
        ArchiveEntry e = (ArchiveEntry)input.getNextEntry();
        while (e != null) {
            String string = e.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string, (String)WEB_TYPES_FILE_SUFFIX, (boolean)false, (int)2, null) && input.canReadEntryData(e)) {
                return FileUtil.loadTextAndClose((InputStream)((InputStream)input));
            }
            e = (ArchiveEntry)input.getNextEntry();
        }
        return null;
    }
}

