/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;

public class MavenWorkspaceMapWrapper {
    private final MavenWorkspaceMap myWorkspaceMap;
    private final Properties mySystemProperties;
    private final Map<String, Set<MavenId>> myArtifactToIdToMavenIdMapping = new HashMap<String, Set<MavenId>>();
    private static final Pattern pattern = Pattern.compile("\\$\\{([^}]+)\\}");

    public MavenWorkspaceMapWrapper(MavenWorkspaceMap workspaceMap, Properties systemProperties) {
        this.myWorkspaceMap = workspaceMap;
        this.mySystemProperties = systemProperties;
        if (null != this.myWorkspaceMap) {
            HashSet<MavenId> ids = new HashSet<MavenId>(this.myWorkspaceMap.getAvailableIds());
            for (MavenId mavenId : ids) {
                MavenId interpolated = this.interpolate(mavenId);
                if (interpolated == mavenId) continue;
                MavenWorkspaceMap.Data data = this.myWorkspaceMap.findFileAndOriginalId(mavenId);
                workspaceMap.register(interpolated, data.getFile("pom"));
            }
            for (MavenId mavenId : this.myWorkspaceMap.getAvailableIds()) {
                if (!this.myArtifactToIdToMavenIdMapping.containsKey(mavenId.getArtifactId())) {
                    this.myArtifactToIdToMavenIdMapping.put(mavenId.getArtifactId(), new HashSet());
                }
                this.myArtifactToIdToMavenIdMapping.get(mavenId.getArtifactId()).add(mavenId);
            }
        }
    }

    public MavenWorkspaceMap.Data findFileAndOriginalId(MavenId mavenId) {
        return this.myWorkspaceMap.findFileAndOriginalId(mavenId);
    }

    @NotNull
    public Set<MavenId> getAvailableIdsForArtifactId(String artifactId) {
        Set<MavenId> ids = this.myArtifactToIdToMavenIdMapping.get(artifactId);
        Set<Object> set = null == ids ? Collections.emptySet() : ids;
        if (set == null) {
            MavenWorkspaceMapWrapper.$$$reportNull$$$0(0);
        }
        return set;
    }

    private MavenId interpolate(MavenId raw) {
        String groupId = this.maybeInterpolate(raw.getGroupId());
        String artifactId = this.maybeInterpolate(raw.getArtifactId());
        String version = this.maybeInterpolate(raw.getVersion());
        if (Objects.equals(groupId, raw.getGroupId()) && Objects.equals(artifactId, raw.getArtifactId()) && Objects.equals(version, raw.getVersion())) {
            return raw;
        }
        return new MavenId(groupId, artifactId, version);
    }

    private String maybeInterpolate(String field) {
        return field != null && field.contains("${") ? this.interpolateField(field) : field;
    }

    private String interpolateField(String value) {
        Matcher matcher = pattern.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String propertyKey = matcher.group(1);
            String replacement = this.mySystemProperties.getProperty(propertyKey, "");
            matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void register(MavenId id, File file) {
        this.myWorkspaceMap.register(id, file);
        Set<MavenId> mavenIds = this.myArtifactToIdToMavenIdMapping.get(id.getArtifactId());
        if (null != mavenIds) {
            mavenIds.add(id);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/model/MavenWorkspaceMapWrapper", "getAvailableIdsForArtifactId"));
    }
}

