/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.CustomChangelistTodosTreeBuilder;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.checkin.TodoCheckinHandlerWorker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PostCommitChecksTodosTreeBuilder
extends CustomChangelistTodosTreeBuilder {
    private final Map<VirtualFile, Change> myChanges;

    public PostCommitChecksTodosTreeBuilder(@NotNull JTree tree, @NotNull Project project, @NotNull Collection<? extends Change> changes, @NotNull Collection<? extends TodoItem> todoItems) {
        if (tree == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(2);
        }
        if (todoItems == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(3);
        }
        super(tree, project, todoItems);
        this.myChanges = new HashMap<VirtualFile, Change>();
        for (Change change : changes) {
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            VirtualFile changeFile = afterPath != null ? afterPath.getVirtualFile() : null;
            if (changeFile == null) continue;
            this.myChanges.put(changeFile, change);
        }
    }

    @Override
    @NotNull
    protected Set<TodoItem> doFindAllTodoItems(@Nullable TodoFilter todoFilter) {
        Collection<Change> changes = this.myChanges.values();
        TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, changes, todoFilter);
        worker.execute();
        Set<TodoItem> set = worker.inOneList();
        if (set == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    protected Set<TodoItem> doFindTodoForFile(@NotNull PsiFile psiFile, @Nullable TodoFilter todoFilter) {
        VirtualFile file;
        Change change;
        if (psiFile == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(5);
        }
        if ((change = this.myChanges.get(file = psiFile.getVirtualFile())) == null) {
            Set<TodoItem> set = Collections.emptySet();
            if (set == null) {
                PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(6);
            }
            return set;
        }
        List<Change> changes = Collections.singletonList(change);
        TodoCheckinHandlerWorker worker = new TodoCheckinHandlerWorker(this.myProject, changes, todoFilter);
        worker.execute();
        Set<TodoItem> set = worker.inOneList();
        if (set == null) {
            PostCommitChecksTodosTreeBuilder.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoItems";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/PostCommitChecksTodosTreeBuilder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/PostCommitChecksTodosTreeBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindAllTodoItems";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindTodoForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doFindTodoForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

