/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public enum ValidationResultType {
    ACCEPTED("accepted", true),
    THIRD_PARTY("third.party", false),
    REJECTED("validation.unmatched_rule", false),
    INCORRECT_RULE("validation.incorrect_rule", false),
    UNDEFINED_RULE("validation.undefined_rule", false),
    UNREACHABLE_METADATA("validation.unreachable_metadata", true),
    DICTIONARY_NOT_FOUND("validation.dictionary_not_found", true),
    GENERAL_DICTIONARY_ERROR("validation.general_dictionary_error", true),
    UNREACHABLE_METADATA_OBSOLETE("validation.unreachable.whitelist", true),
    PERFORMANCE_ISSUE("validation.performance_issue", true),
    REQUIRED_FIELD_MISSED("validation.required_field_missed", true);

    private final String value;
    private final boolean isFinal;
    public static final Set<String> VALIDATION_TYPES;

    private ValidationResultType(String value, boolean isFinal) {
        this.value = value;
        this.isFinal = isFinal;
    }

    public String getDescription() {
        return this.value;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    static {
        VALIDATION_TYPES = Arrays.stream(ValidationResultType.values()).map(ValidationResultType::getDescription).collect(Collectors.toSet());
    }
}

