#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-iadd
version:              1.3.22
visibility:           public
id:                   hledger-iadd-1.3.22-ApZCw1AbgBc5Mg4tlGmuJj
key:                  hledger-iadd-1.3.22-ApZCw1AbgBc5Mg4tlGmuJj
license:              BSD-3-Clause
copyright:            2018 Hans-Peter Deifel
maintainer:           Hans-Peter Deifel <hpd@hpdeifel.de>
author:               Hans-Peter Deifel <hpd@hpdeifel.de>
homepage:             https://github.com/hpdeifel/hledger-iadd#readme
synopsis:             A terminal UI as drop-in replacement for hledger add
description:
    This is a terminal UI as drop-in replacement for hledger add.

    It improves in the following ways on hledger'\''s add command:

    * Interactive as-you-type completion for
    account names and descriptions with optional
    fuzzy matching.

    * Integrated calculator: Amounts can be written
    as simple sums with real-time feedback on the
    result.

    * All actions while entering a transaction can
    be undone

    * Configurable format for date input. Instead
    of @y\/m\/d@ it is also possible to use other
    formats like the german @d.m.y@.

category:             Finance, Console
abi:                  4a6096b7f3eb607da432ed1e36f0eee7
exposed:              True
exposed-modules:
    AmountParser Brick.Widgets.BetterDialog Brick.Widgets.Border.Utils
    Brick.Widgets.CommentDialog Brick.Widgets.Edit.EmacsBindings
    Brick.Widgets.HelpMessage Brick.Widgets.List.Utils
    Brick.Widgets.WrappedText ConfigParser Data.Time.Ext DateParser
    Model View

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-iadd-1.3.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-iadd
hs-libraries:         HShledger-iadd-1.3.22-ApZCw1AbgBc5Mg4tlGmuJj
depends:
    base-4.18.2.1 brick-2.5-1Y1mzX58dIADm8kgkRHvOU containers-0.6.7
    directory-1.3.8.5 free-5.2-DlZGL8sVPWTHtuHZyHepAx
    hledger-lib-1.50.4-HtadN8JcWOvGsACwGGQvTr
    megaparsec-9.7.0-EJ90AsoHAMdCjQYvJMoIz4
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw
    optparse-applicative-0.18.1.0-LPpsyWWBTB8DZOwBIqw3J0 text-2.0.2
    text-zipper-0.13-5T8E7HU1HSbD5GhpCLX29A time-1.12.2
    transformers-0.6.1.0
    unordered-containers-0.2.20.1-650icVWmHjf3WKXK0GKpae
    vector-0.13.2.0-8Ien1418VpU5tGTMA2qRu7
    vty-6.2-6DGA2W5fruYGI1Pcli1nVz
    xdg-basedir-0.2.2-DLaKUfv1JJAFBfkP0BUklH

haddock-interfaces:   /usr/share/doc/hledger-iadd/html/hledger-iadd.haddock
haddock-html:         /usr/share/doc/hledger-iadd/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

