/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.asm;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;

class ClassRelevancyFilter
implements Predicate<String> {
    private static final Set<String> PRIMITIVES = ImmutableSet.builder().add((Object)"void").add((Object)"boolean").add((Object)"byte").add((Object)"char").add((Object)"short").add((Object)"int").add((Object)"long").add((Object)"float").add((Object)"double").build();
    private String excludedClassName;

    public ClassRelevancyFilter(String excludedClassName) {
        this.excludedClassName = excludedClassName;
    }

    @Override
    public boolean test(String className) {
        return !className.startsWith("java.") && !this.excludedClassName.equals(className) && !PRIMITIVES.contains(className);
    }
}

