---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token GitHub personal access token (classic)'
---

## Description

The response body contains content that matches the pattern of a GitHub personal access token (classic) was identified. Personal access tokens can be used to access GitHub services as the user who created them. In most cases these tokens are given read-write access to all repositories. A malicious actor with access to this token can execute functionality on behalf of the user with the given permissions of the token.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To regenerate a personal access token:

- Sign in to your GitHub account and access <https://github.com/settings/tokens>
- Find the token that was identified and select the name
- Select "Regenerate token" at the top of the page Alternatively, you could select "Delete this token" at the bottom of the page and create a new one. Be sure to note the scopes and permissions set before doing this action.

For more information, please see [GitHubs documentation on personal access tokens](https://docs.github.com/en/authentication/keeping-your-account-and-data-secure/managing-your-personal-access-tokens).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.52 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
