/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Scene;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Alignment;
import com.jogamp.graph.ui.layout.BoxLayout;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.AABBox;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import jogamp.graph.ui.TreeTool;

public class HUDShape
extends Group {
    private final boolean hasFrame;
    private final Vec2f clientSize = new Vec2f();
    private final Vec3f clientPos = new Vec3f();
    private final Vec4f backColor = new Vec4f(0.9f, 0.9f, 0.9f, 0.9f);
    private final Vec4f frontColor = new Vec4f(0.1f, 0.1f, 0.1f, 0.9f);
    private final Rectangle frame;
    private final Scene scene;
    private final Shape targetShape;
    private Shape clientShape;
    private static final boolean DEBUG = false;
    private final Vec3f hudSizeOld = new Vec3f();
    private final AABBox tmpB0 = new AABBox();
    private final AABBox tmpB1 = new AABBox();
    private final Vec3f tmpV0 = new Vec3f();
    private final Vec3f tmpV1 = new Vec3f();

    public HUDShape(Scene scene, float f, float f2, int n, Shape shape, Shape shape2) {
        this(scene, f, f2, null, null, 0.0f, null, n, shape, shape2);
    }

    public HUDShape(Scene scene, float f, float f2, Vec4f vec4f, Vec4f vec4f2, float f3, Padding padding, int n, Shape shape, Shape shape2) {
        this.hasFrame = null != vec4f;
        this.clientSize.set(f, f2);
        if (this.hasFrame) {
            this.backColor.set(vec4f);
        }
        if (null != this.frontColor) {
            this.frontColor.set(this.frontColor);
        }
        this.scene = scene;
        this.targetShape = shape;
        this.clientShape = shape2;
        if (this.hasFrame) {
            this.frame = (Rectangle)new Rectangle(n, 1.0f, 1.0f, 0.0f).setColor(vec4f).setBorder(f3).setBorderColor(this.frontColor).setName("HUD.frame").move(0.0f, 0.0f, -scene.getZEpsilon(16));
            this.addShape(this.frame.setInteractive(false));
        } else {
            this.frame = null;
        }
        Group group = new Group("HUD.wrapper", null, null, shape2);
        if (null != padding) {
            group.setPaddding(padding);
        }
        this.addShape(group);
        this.setName("HUD");
        this.markShapeDirty();
    }

    @Override
    protected void validateImpl(GL2ES2 gL2ES2, GLProfile gLProfile) {
        if (this.isShapeDirty()) {
            this.targetShape.validate(gL2ES2, gLProfile);
            PMVMatrix4f pMVMatrix4f = new PMVMatrix4f();
            this.tmpB0.reset().setSize(this.clientPos, this.tmpV0.set(this.clientPos).add(this.clientSize.x(), this.clientSize.y(), 0.0f));
            Vec3f vec3f = this.tmpV0;
            Vec3f vec3f2 = this.tmpV1;
            AABBox aABBox = new AABBox();
            TreeTool.forOne(this.scene, pMVMatrix4f, this.targetShape, () -> {
                this.targetShape.getBounds().transform(pMVMatrix4f.getMv(), aABBox);
                this.tmpB0.transform(pMVMatrix4f.getMv(), this.tmpB1);
                vec3f.set(this.tmpB1.getWidth(), this.tmpB1.getHeight(), 0.0f);
                vec3f2.set(this.tmpB1.getLow());
            });
            vec3f2.add(0.0f, 0.0f, this.scene.getActiveTopLevelZOffsetScale() * this.scene.getZEpsilon(16));
            AABBox aABBox2 = this.scene.getBounds();
            if (vec3f2.x() < aABBox2.getMinX()) {
                vec3f2.setX(aABBox2.getMinX());
            } else if (vec3f2.x() + vec3f.x() > aABBox2.getMaxX()) {
                vec3f2.setX(aABBox2.getMaxX() - vec3f.x());
            }
            if (vec3f2.y() < aABBox2.getMinY()) {
                vec3f2.setY(aABBox2.getMinY());
            } else if (vec3f2.y() + vec3f.y() > aABBox2.getMaxY()) {
                vec3f2.setY(aABBox2.getMaxY() - vec3f.y());
            }
            if (!this.hudSizeOld.isEqual(vec3f) || null == this.getLayout()) {
                this.setLayout(new BoxLayout(vec3f.x(), vec3f.y(), Alignment.FillCenter));
                this.hudSizeOld.set(vec3f);
            }
            this.moveTo(vec3f2);
            super.validateImpl(gL2ES2, gLProfile);
        }
    }

    public HUDShape moveToHUDPos(Vec3f vec3f) {
        this.clientPos.set(vec3f);
        this.markShapeDirty();
        return this;
    }

    public HUDShape moveHUDPos(Vec3f vec3f) {
        this.clientPos.add(vec3f);
        this.markShapeDirty();
        return this;
    }

    public HUDShape setClientSize(float f, float f2) {
        this.clientSize.set(f, f2);
        this.markShapeDirty();
        return this;
    }

    public Vec2f getClientSize() {
        return this.clientSize;
    }

    public Vec3f getClientPos() {
        return this.clientPos;
    }

    public Shape getClientShape() {
        return this.clientShape;
    }

    public Shape getTargetShape() {
        return this.targetShape;
    }

    public Shape removeClient() {
        Group group;
        Shape shape2 = this.clientShape;
        this.clientShape = null;
        if (null != shape2 && null == (group = (Group)this.getShapeByIdx(1)).removeShape(shape2)) {
            System.err.println("HUDShape.destroyTip: Warning: ClientShape " + shape2.getName() + " not contained in " + group.getName() + "; Internal Group: ");
            TreeTool.forAll(this, shape -> {
                System.err.println("- " + shape.getName());
                return false;
            });
        }
        return shape2;
    }
}

