/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.parser.MediaQueryDatabase;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;

public abstract class AbstractMediaQuery
implements MediaQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final HashSet<String> rangeFeatureSet = new HashSet(MediaQueryDatabase.rangeFeatures.length);
    private String mediaType = null;
    private boolean negativeQuery = false;
    private boolean onlyPrefix = false;
    private BooleanCondition predicate = null;

    protected AbstractMediaQuery() {
    }

    private static String escapeIdentifier(String string) {
        return ParseHelper.escape(string);
    }

    protected static boolean isRangeFeature(String string) {
        return rangeFeatureSet.contains(string);
    }

    @Override
    public BooleanCondition getCondition() {
        return this.predicate;
    }

    @Override
    public String getMedia() {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (this.negativeQuery) {
            stringBuilder.append("not ");
        } else if (this.onlyPrefix) {
            stringBuilder.append("only ");
        }
        if (this.predicate != null) {
            this.predicate.appendText(stringBuilder);
        } else if (this.mediaType != null) {
            stringBuilder.append(AbstractMediaQuery.escapeIdentifier(this.mediaType));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getMinifiedMedia() {
        StringBuilder stringBuilder = new StringBuilder(32);
        if (this.negativeQuery) {
            stringBuilder.append("not ");
        } else if (this.onlyPrefix) {
            stringBuilder.append("only ");
        }
        if (this.predicate != null) {
            this.predicate.appendMinifiedText(stringBuilder);
        } else if (this.mediaType != null) {
            stringBuilder.append(AbstractMediaQuery.escapeIdentifier(this.mediaType));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isAllMedia() {
        return (this.mediaType == null || "all".equalsIgnoreCase(this.mediaType)) && !this.negativeQuery && this.predicate == null;
    }

    @Override
    public boolean isNegated() {
        return this.negativeQuery;
    }

    @Override
    public boolean isNotAllMedia() {
        return "all".equalsIgnoreCase(this.mediaType) && this.negativeQuery && this.predicate == null;
    }

    protected boolean matches(AbstractMediaQuery abstractMediaQuery) {
        boolean bl;
        if (abstractMediaQuery.isNotAllMedia()) {
            return false;
        }
        boolean bl2 = bl = this.mediaType == null || "all".equals(this.mediaType);
        if (this.negativeQuery ? (bl ? this.predicate == null : (this.mediaType.equals(abstractMediaQuery.mediaType) ? !abstractMediaQuery.negativeQuery : abstractMediaQuery.negativeQuery)) : !bl && (abstractMediaQuery.negativeQuery || !this.mediaType.equals(abstractMediaQuery.mediaType))) {
            return false;
        }
        if (this.predicate == null) {
            return true;
        }
        if (abstractMediaQuery.predicate == null) {
            return false;
        }
        byte by = this.negativeQuery ? (!abstractMediaQuery.negativeQuery ? (byte)1 : 0) : (abstractMediaQuery.negativeQuery ? (byte)2 : 0);
        return this.matches(this.predicate, abstractMediaQuery.predicate, by) != 0;
    }

    protected abstract byte matches(BooleanCondition var1, BooleanCondition var2, byte var3);

    public boolean matches(String string, CSSCanvas cSSCanvas) {
        if (this.mediaType != null && (this.mediaType.equals(string) ? this.negativeQuery : !this.negativeQuery)) {
            return false;
        }
        if (this.predicate != null) {
            if (cSSCanvas == null) {
                return false;
            }
            return this.matchesCondition(this.predicate, cSSCanvas);
        }
        return true;
    }

    private boolean matchesCondition(BooleanCondition booleanCondition, CSSCanvas cSSCanvas) {
        switch (booleanCondition.getType()) {
            case AND: {
                for (BooleanCondition booleanCondition2 : booleanCondition.getSubConditions()) {
                    if (this.matchesCondition(booleanCondition2, cSSCanvas)) continue;
                    return false;
                }
                return true;
            }
            case NOT: {
                return !this.matchesCondition(booleanCondition.getNestedCondition(), cSSCanvas);
            }
            case OR: {
                for (BooleanCondition booleanCondition3 : booleanCondition.getSubConditions()) {
                    if (!this.matchesCondition(booleanCondition3, cSSCanvas)) continue;
                    return true;
                }
                break;
            }
            default: {
                return this.matchesPredicate(booleanCondition, cSSCanvas);
            }
        }
        return false;
    }

    protected abstract boolean matchesPredicate(BooleanCondition var1, CSSCanvas var2);

    protected void setFeaturePredicate(BooleanCondition booleanCondition) {
        this.predicate = booleanCondition;
    }

    protected void setMediaType(String string) {
        this.mediaType = string;
    }

    protected void setNegative(boolean bl) {
        this.negativeQuery = bl;
    }

    protected void setOnlyPrefix(boolean bl) {
        this.onlyPrefix = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AbstractMediaQuery abstractMediaQuery = (AbstractMediaQuery)object;
        if (this.mediaType == null ? abstractMediaQuery.mediaType != null : !this.mediaType.equals(abstractMediaQuery.mediaType)) {
            return false;
        }
        if (this.negativeQuery != abstractMediaQuery.negativeQuery) {
            return false;
        }
        if (this.onlyPrefix != abstractMediaQuery.onlyPrefix) {
            return false;
        }
        if (this.predicate == null) {
            if (abstractMediaQuery.predicate != null) {
                return false;
            }
        } else {
            if (abstractMediaQuery.predicate == null) {
                return false;
            }
            if (!this.predicate.equals(abstractMediaQuery.predicate)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.mediaType == null ? 0 : this.mediaType.hashCode());
        n2 = 31 * n2 + (this.negativeQuery ? 1231 : 1237);
        n2 = 31 * n2 + (this.onlyPrefix ? 1231 : 1237);
        if (this.predicate != null) {
            n2 = 31 * n2 + this.predicate.hashCode();
        }
        return n2;
    }

    public String toString() {
        return this.getMedia();
    }

    static {
        Collections.addAll(rangeFeatureSet, MediaQueryDatabase.rangeFeatures);
    }
}

