/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.ElementTuple;
import io.sf.carte.doc.dom.NDTNode;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

abstract class AbstractElementLiveList
implements ElementList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final NDTNode contextNode;

    AbstractElementLiveList(NDTNode nDTNode) {
        this.contextNode = nDTNode;
    }

    @Override
    public boolean contains(Node node) {
        if (node == null) {
            return false;
        }
        return this.containsChild(this.contextNode, node);
    }

    private boolean containsChild(NDTNode nDTNode, Node node) {
        for (Node node2 = nDTNode.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            DOMElement dOMElement = (DOMElement)node2;
            if (this.matches(dOMElement, node)) {
                return true;
            }
            if (!this.containsChild(dOMElement, node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DOMElement item(int n) {
        if (n < 0) {
            return null;
        }
        ElementTuple elementTuple = new ElementTuple();
        this.indexChildList(this.contextNode, n, elementTuple);
        return elementTuple.element;
    }

    private void indexChildList(NDTNode nDTNode, int n, ElementTuple elementTuple) {
        for (Node node = nDTNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement dOMElement = (DOMElement)node;
            if (this.matches(dOMElement)) {
                if (elementTuple.index == n) {
                    elementTuple.element = dOMElement;
                    return;
                }
                ++elementTuple.index;
            }
            this.indexChildList(dOMElement, n, elementTuple);
            if (elementTuple.element == null) continue;
            return;
        }
    }

    @Override
    public int getLength() {
        return this.countChildList(this.contextNode, 0);
    }

    private int countChildList(NDTNode nDTNode, int n) {
        for (Node node = nDTNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement dOMElement = (DOMElement)node;
            if (this.matches(dOMElement)) {
                ++n;
            }
            n = this.countChildList(dOMElement, n);
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        ElementTuple elementTuple = new ElementTuple();
        this.indexChildList(this.contextNode, 0, elementTuple);
        return elementTuple.element == null;
    }

    abstract boolean matches(DOMElement var1, Node var2);

    abstract boolean matches(DOMElement var1);

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        Iterator<DOMElement> iterator = this.iterator();
        if (iterator.hasNext()) {
            stringBuilder.append(iterator.next().getStartTag());
        }
        while (iterator.hasNext()) {
            stringBuilder.append(',').append(iterator.next().getStartTag());
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<DOMElement> iterator() {
        return new ElementIterator();
    }

    private class ElementIterator
    implements Iterator<DOMElement> {
        private DOMElement next;

        private ElementIterator() {
            this.next = this.findNext(AbstractElementLiveList.this.contextNode);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public DOMElement next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            DOMElement dOMElement = this.next;
            this.next = this.findNext(this.next);
            return dOMElement;
        }

        private DOMElement findNext(NDTNode nDTNode) {
            AbstractDOMNode abstractDOMNode = this.nextNode(nDTNode);
            while (abstractDOMNode != AbstractElementLiveList.this.contextNode) {
                DOMElement dOMElement;
                if (abstractDOMNode.getNodeType() == 1 && AbstractElementLiveList.this.matches(dOMElement = (DOMElement)abstractDOMNode)) {
                    return dOMElement;
                }
                abstractDOMNode = this.nextNode(abstractDOMNode);
            }
            return null;
        }

        private AbstractDOMNode nextNode(AbstractDOMNode abstractDOMNode) {
            AbstractDOMNode abstractDOMNode2 = abstractDOMNode.getNodeList().getFirst();
            if (abstractDOMNode2 == null) {
                abstractDOMNode2 = abstractDOMNode != AbstractElementLiveList.this.contextNode ? this.nextSiblingOrParent(abstractDOMNode) : abstractDOMNode;
            }
            return abstractDOMNode2;
        }

        private AbstractDOMNode nextSiblingOrParent(AbstractDOMNode abstractDOMNode) {
            AbstractDOMNode abstractDOMNode2 = abstractDOMNode.nextSibling;
            if (abstractDOMNode2 == null) {
                AbstractDOMNode abstractDOMNode3 = abstractDOMNode.parentNode();
                if (abstractDOMNode3 != AbstractElementLiveList.this.contextNode && abstractDOMNode3 != null) {
                    return this.nextSiblingOrParent(abstractDOMNode3);
                }
                abstractDOMNode2 = AbstractElementLiveList.this.contextNode;
            }
            return abstractDOMNode2;
        }
    }
}

