/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.renderable;

import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.AbstractRable;
import io.sf.carte.echosvg.ext.awt.image.renderable.FloodRable;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.FloodRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.PadRed;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;

public class FloodRable8Bit
extends AbstractRable
implements FloodRable {
    Paint floodPaint;
    Rectangle2D floodRegion;

    public FloodRable8Bit(Rectangle2D rectangle2D, Paint paint) {
        this.setFloodPaint(paint);
        this.setFloodRegion(rectangle2D);
    }

    @Override
    public void setFloodPaint(Paint paint) {
        this.touch();
        this.floodPaint = paint == null ? new Color(0, 0, 0, 0) : paint;
    }

    @Override
    public Paint getFloodPaint() {
        return this.floodPaint;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.floodRegion.clone();
    }

    @Override
    public Rectangle2D getFloodRegion() {
        return (Rectangle2D)this.floodRegion.clone();
    }

    @Override
    public void setFloodRegion(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException();
        }
        this.touch();
        this.floodRegion = rectangle2D;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Rectangle2D rectangle2D;
        AffineTransform affineTransform = renderContext.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        Rectangle2D rectangle2D2 = this.getBounds2D();
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = rectangle2D2;
            rectangle2D = rectangle2D2;
        } else {
            rectangle2D = shape.getBounds2D();
            if (!rectangle2D2.intersects(rectangle2D)) {
                return null;
            }
            Rectangle2D.intersect(rectangle2D2, rectangle2D, rectangle2D);
        }
        Rectangle rectangle = affineTransform.createTransformedShape(rectangle2D).getBounds();
        if (rectangle.width <= 0 || rectangle.height <= 0) {
            return null;
        }
        AbstractRed abstractRed = new FloodRed(rectangle, this.getFloodPaint());
        abstractRed = new PadRed(abstractRed, rectangle, PadMode.ZERO_PAD, null);
        return abstractRed;
    }
}

