﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconvert/MediaConvert_EXPORTS.h>

namespace Aws {
namespace MediaConvert {
namespace Model {
enum class MsSmoothManifestEncoding { NOT_SET, UTF8, UTF16 };

namespace MsSmoothManifestEncodingMapper {
AWS_MEDIACONVERT_API MsSmoothManifestEncoding GetMsSmoothManifestEncodingForName(const Aws::String& name);

AWS_MEDIACONVERT_API Aws::String GetNameForMsSmoothManifestEncoding(MsSmoothManifestEncoding value);
}  // namespace MsSmoothManifestEncodingMapper
}  // namespace Model
}  // namespace MediaConvert
}  // namespace Aws
