/* Device.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Device.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Sean Davis <sean@bluesabre.org>
 */

#include "sound.h"
#include <pulse/pulseaudio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_DEVICE_0_PROPERTY,
	SOUND_DEVICE_DIRECTION_PROPERTY,
	SOUND_DEVICE_ID_PROPERTY,
	SOUND_DEVICE_CARD_INDEX_PROPERTY,
	SOUND_DEVICE_PORT_NAME_PROPERTY,
	SOUND_DEVICE_DISPLAY_NAME_PROPERTY,
	SOUND_DEVICE_FORM_FACTOR_PROPERTY,
	SOUND_DEVICE_ICON_NAME_PROPERTY,
	SOUND_DEVICE_PROFILES_PROPERTY,
	SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY,
	SOUND_DEVICE_SINK_NAME_PROPERTY,
	SOUND_DEVICE_SINK_INDEX_PROPERTY,
	SOUND_DEVICE_CARD_SINK_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY,
	SOUND_DEVICE_SOURCE_NAME_PROPERTY,
	SOUND_DEVICE_SOURCE_INDEX_PROPERTY,
	SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY,
	SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY,
	SOUND_DEVICE_IS_DEFAULT_PROPERTY,
	SOUND_DEVICE_IS_PRIORITY_PROPERTY,
	SOUND_DEVICE_NUM_PROPERTIES
};
static GParamSpec* sound_device_properties[SOUND_DEVICE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SoundDeviceParamSpecPort SoundDeviceParamSpecPort;
enum  {
	SOUND_DEVICE_REMOVED_SIGNAL,
	SOUND_DEVICE_DEFAULTED_SIGNAL,
	SOUND_DEVICE_NUM_SIGNALS
};
static guint sound_device_signals[SOUND_DEVICE_NUM_SIGNALS] = {0};

struct _SoundDevicePrivate {
	pa_direction_t _direction;
	gchar* _id;
	guint32 _card_index;
	gchar* _port_name;
	gchar* _display_name;
	gchar* _form_factor;
	gchar* _icon_name;
	GeeArrayList* _profiles;
	gchar* _card_active_profile_name;
	gchar* _sink_name;
	gint _sink_index;
	gchar* _card_sink_name;
	gchar* _card_sink_port_name;
	gint _card_sink_index;
	gchar* _source_name;
	gint _source_index;
	gchar* _card_source_name;
	gchar* _card_source_port_name;
	gint _card_source_index;
	gboolean _is_default;
	gboolean _is_priority;
};

struct _SoundDeviceParamSpecPort {
	GParamSpec parent_instance;
};

static gint SoundDevice_private_offset;
static gpointer sound_device_parent_class = NULL;
static gpointer sound_device_port_parent_class = NULL;

static void sound_device_port_finalize (SoundDevicePort * obj);
static GType sound_device_port_get_type_once (void);
static GObject * sound_device_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void sound_device_finalize (GObject * obj);
static GType sound_device_get_type_once (void);
static void _vala_sound_device_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sound_device_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
sound_device_get_instance_private (SoundDevice* self)
{
	return G_STRUCT_MEMBER_P (self, SoundDevice_private_offset);
}

SoundDevice*
sound_device_construct (GType object_type,
                        const gchar* id,
                        guint32 card_index,
                        const gchar* port_name)
{
	SoundDevice * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (port_name != NULL, NULL);
	self = (SoundDevice*) g_object_new (object_type, "id", id, "card-index", card_index, "port-name", port_name, NULL);
	return self;
}

SoundDevice*
sound_device_new (const gchar* id,
                  guint32 card_index,
                  const gchar* port_name)
{
	return sound_device_construct (SOUND_TYPE_DEVICE, id, card_index, port_name);
}

gchar*
sound_device_get_matching_profile (SoundDevice* self,
                                   SoundDevice* other_device)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (other_device != NULL) {
		{
			GeeArrayList* _profile_list = NULL;
			GeeArrayList* _tmp0_;
			gint _profile_size = 0;
			GeeArrayList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _profile_index = 0;
			_tmp0_ = self->priv->_profiles;
			_profile_list = _tmp0_;
			_tmp1_ = _profile_list;
			_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
			_tmp3_ = _tmp2_;
			_profile_size = _tmp3_;
			_profile_index = -1;
			while (TRUE) {
				gint _tmp4_;
				gint _tmp5_;
				gchar* profile = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				GeeArrayList* _tmp8_;
				const gchar* _tmp9_;
				_profile_index = _profile_index + 1;
				_tmp4_ = _profile_index;
				_tmp5_ = _profile_size;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = _profile_list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _profile_index);
				profile = (gchar*) _tmp7_;
				_tmp8_ = other_device->priv->_profiles;
				_tmp9_ = profile;
				if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp8_, _tmp9_)) {
					result = profile;
					return result;
				}
				_g_free0 (profile);
			}
		}
	}
	result = NULL;
	return result;
}

pa_direction_t
sound_device_get_direction (SoundDevice* self)
{
	pa_direction_t result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_direction;
	return result;
}

void
sound_device_set_direction (SoundDevice* self,
                            pa_direction_t value)
{
	pa_direction_t old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_direction (self);
	if (old_value != value) {
		self->priv->_direction = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_DIRECTION_PROPERTY]);
	}
}

const gchar*
sound_device_get_id (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}

static void
sound_device_set_id (SoundDevice* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_ID_PROPERTY]);
	}
}

guint32
sound_device_get_card_index (SoundDevice* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_card_index;
	return result;
}

static void
sound_device_set_card_index (SoundDevice* self,
                             guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_index (self);
	if (old_value != value) {
		self->priv->_card_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_port_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_port_name;
	result = _tmp0_;
	return result;
}

static void
sound_device_set_port_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_port_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_port_name);
		self->priv->_port_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_PORT_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_display_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_display_name (SoundDevice* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_DISPLAY_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_form_factor (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_form_factor;
	result = _tmp0_;
	return result;
}

void
sound_device_set_form_factor (SoundDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_form_factor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_form_factor);
		self->priv->_form_factor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_FORM_FACTOR_PROPERTY]);
	}
}

const gchar*
sound_device_get_icon_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_icon_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_ICON_NAME_PROPERTY]);
	}
}

GeeArrayList*
sound_device_get_profiles (SoundDevice* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_profiles;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sound_device_set_profiles (SoundDevice* self,
                           GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_profiles (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_profiles);
		self->priv->_profiles = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_PROFILES_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_active_profile_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_active_profile_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_active_profile_name (SoundDevice* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_active_profile_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_active_profile_name);
		self->priv->_card_active_profile_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_sink_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sink_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_sink_name (SoundDevice* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_sink_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_sink_name);
		self->priv->_sink_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SINK_NAME_PROPERTY]);
	}
}

gint
sound_device_get_sink_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sink_index;
	return result;
}

void
sound_device_set_sink_index (SoundDevice* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_sink_index (self);
	if (old_value != value) {
		self->priv->_sink_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SINK_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_sink_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_sink_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_sink_name (SoundDevice* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_sink_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_sink_name);
		self->priv->_card_sink_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SINK_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_sink_port_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_sink_port_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_sink_port_name (SoundDevice* self,
                                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_sink_port_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_sink_port_name);
		self->priv->_card_sink_port_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY]);
	}
}

gint
sound_device_get_card_sink_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_card_sink_index;
	return result;
}

void
sound_device_set_card_sink_index (SoundDevice* self,
                                  gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_sink_index (self);
	if (old_value != value) {
		self->priv->_card_sink_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_source_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_source_name (SoundDevice* self,
                              const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_source_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_source_name);
		self->priv->_source_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SOURCE_NAME_PROPERTY]);
	}
}

gint
sound_device_get_source_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_source_index;
	return result;
}

void
sound_device_set_source_index (SoundDevice* self,
                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_source_index (self);
	if (old_value != value) {
		self->priv->_source_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_SOURCE_INDEX_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_source_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_source_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_source_name (SoundDevice* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_source_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_source_name);
		self->priv->_card_source_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY]);
	}
}

const gchar*
sound_device_get_card_source_port_name (SoundDevice* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_card_source_port_name;
	result = _tmp0_;
	return result;
}

void
sound_device_set_card_source_port_name (SoundDevice* self,
                                        const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_source_port_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_card_source_port_name);
		self->priv->_card_source_port_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY]);
	}
}

gint
sound_device_get_card_source_index (SoundDevice* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_card_source_index;
	return result;
}

void
sound_device_set_card_source_index (SoundDevice* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_card_source_index (self);
	if (old_value != value) {
		self->priv->_card_source_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY]);
	}
}

gboolean
sound_device_get_is_default (SoundDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_default;
	return result;
}

void
sound_device_set_is_default (SoundDevice* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_is_default (self);
	if (old_value != value) {
		self->priv->_is_default = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_IS_DEFAULT_PROPERTY]);
	}
}

gboolean
sound_device_get_is_priority (SoundDevice* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_priority;
	return result;
}

void
sound_device_set_is_priority (SoundDevice* self,
                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_device_get_is_priority (self);
	if (old_value != value) {
		self->priv->_is_priority = value;
		g_object_notify_by_pspec ((GObject *) self, sound_device_properties[SOUND_DEVICE_IS_PRIORITY_PROPERTY]);
	}
}

SoundDevicePort*
sound_device_port_construct (GType object_type)
{
	SoundDevicePort* self = NULL;
	self = (SoundDevicePort*) g_type_create_instance (object_type);
	return self;
}

SoundDevicePort*
sound_device_port_new (void)
{
	return sound_device_port_construct (SOUND_DEVICE_TYPE_PORT);
}

static void
sound_device_value_port_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
sound_device_value_port_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		sound_device_port_unref (value->data[0].v_pointer);
	}
}

static void
sound_device_value_port_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = sound_device_port_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
sound_device_value_port_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
sound_device_value_port_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		SoundDevicePort * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = sound_device_port_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
sound_device_value_port_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	SoundDevicePort ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = sound_device_port_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
sound_device_param_spec_port (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	SoundDeviceParamSpecPort* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SOUND_DEVICE_TYPE_PORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
sound_device_value_get_port (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SOUND_DEVICE_TYPE_PORT), NULL);
	return value->data[0].v_pointer;
}

void
sound_device_value_set_port (GValue* value,
                             gpointer v_object)
{
	SoundDevicePort * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SOUND_DEVICE_TYPE_PORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SOUND_DEVICE_TYPE_PORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		sound_device_port_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sound_device_port_unref (old);
	}
}

void
sound_device_value_take_port (GValue* value,
                              gpointer v_object)
{
	SoundDevicePort * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SOUND_DEVICE_TYPE_PORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SOUND_DEVICE_TYPE_PORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		sound_device_port_unref (old);
	}
}

static void
sound_device_port_class_init (SoundDevicePortClass * klass,
                              gpointer klass_data)
{
	sound_device_port_parent_class = g_type_class_peek_parent (klass);
	((SoundDevicePortClass *) klass)->finalize = sound_device_port_finalize;
}

static void
sound_device_port_instance_init (SoundDevicePort * self,
                                 gpointer klass)
{
	self->ref_count = 1;
}

static void
sound_device_port_finalize (SoundDevicePort * obj)
{
	SoundDevicePort * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_DEVICE_TYPE_PORT, SoundDevicePort);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->description);
}

static GType
sound_device_port_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { sound_device_value_port_init, sound_device_value_port_free_value, sound_device_value_port_copy_value, sound_device_value_port_peek_pointer, "p", sound_device_value_port_collect_value, "p", sound_device_value_port_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SoundDevicePortClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_device_port_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundDevicePort), 0, (GInstanceInitFunc) sound_device_port_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType sound_device_port_type_id;
	sound_device_port_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SoundDevicePort", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return sound_device_port_type_id;
}

GType
sound_device_port_get_type (void)
{
	static volatile gsize sound_device_port_type_id__once = 0;
	if (g_once_init_enter (&sound_device_port_type_id__once)) {
		GType sound_device_port_type_id;
		sound_device_port_type_id = sound_device_port_get_type_once ();
		g_once_init_leave (&sound_device_port_type_id__once, sound_device_port_type_id);
	}
	return sound_device_port_type_id__once;
}

gpointer
sound_device_port_ref (gpointer instance)
{
	SoundDevicePort * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
sound_device_port_unref (gpointer instance)
{
	SoundDevicePort * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SOUND_DEVICE_PORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
sound_device_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SoundDevice * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	parent_class = G_OBJECT_CLASS (sound_device_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_DEVICE, SoundDevice);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	sound_device_set_profiles (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
sound_device_class_init (SoundDeviceClass * klass,
                         gpointer klass_data)
{
	sound_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundDevice_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_device_set_property;
	G_OBJECT_CLASS (klass)->constructor = sound_device_constructor;
	G_OBJECT_CLASS (klass)->finalize = sound_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_DIRECTION_PROPERTY, sound_device_properties[SOUND_DEVICE_DIRECTION_PROPERTY] = g_param_spec_uint ("direction", "direction", "direction", 0, G_MAXUINT, PA_DIRECTION_INPUT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_ID_PROPERTY, sound_device_properties[SOUND_DEVICE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_INDEX_PROPERTY] = g_param_spec_uint ("card-index", "card-index", "card-index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_PORT_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_PORT_NAME_PROPERTY] = g_param_spec_string ("port-name", "port-name", "port-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_DISPLAY_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_FORM_FACTOR_PROPERTY, sound_device_properties[SOUND_DEVICE_FORM_FACTOR_PROPERTY] = g_param_spec_string ("form-factor", "form-factor", "form-factor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_ICON_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_PROFILES_PROPERTY, sound_device_properties[SOUND_DEVICE_PROFILES_PROPERTY] = g_param_spec_object ("profiles", "profiles", "profiles", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY] = g_param_spec_string ("card-active-profile-name", "card-active-profile-name", "card-active-profile-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SINK_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_SINK_NAME_PROPERTY] = g_param_spec_string ("sink-name", "sink-name", "sink-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SINK_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_SINK_INDEX_PROPERTY] = g_param_spec_int ("sink-index", "sink-index", "sink-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SINK_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SINK_NAME_PROPERTY] = g_param_spec_string ("card-sink-name", "card-sink-name", "card-sink-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY] = g_param_spec_string ("card-sink-port-name", "card-sink-port-name", "card-sink-port-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY] = g_param_spec_int ("card-sink-index", "card-sink-index", "card-sink-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SOURCE_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_SOURCE_NAME_PROPERTY] = g_param_spec_string ("source-name", "source-name", "source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_SOURCE_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_SOURCE_INDEX_PROPERTY] = g_param_spec_int ("source-index", "source-index", "source-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY] = g_param_spec_string ("card-source-name", "card-source-name", "card-source-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY] = g_param_spec_string ("card-source-port-name", "card-source-port-name", "card-source-port-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY, sound_device_properties[SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY] = g_param_spec_int ("card-source-index", "card-source-index", "card-source-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_IS_DEFAULT_PROPERTY, sound_device_properties[SOUND_DEVICE_IS_DEFAULT_PROPERTY] = g_param_spec_boolean ("is-default", "is-default", "is-default", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_DEVICE_IS_PRIORITY_PROPERTY, sound_device_properties[SOUND_DEVICE_IS_PRIORITY_PROPERTY] = g_param_spec_boolean ("is-priority", "is-priority", "is-priority", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sound_device_signals[SOUND_DEVICE_REMOVED_SIGNAL] = g_signal_new ("removed", SOUND_TYPE_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sound_device_signals[SOUND_DEVICE_DEFAULTED_SIGNAL] = g_signal_new ("defaulted", SOUND_TYPE_DEVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
sound_device_instance_init (SoundDevice * self,
                            gpointer klass)
{
	self->priv = sound_device_get_instance_private (self);
	self->priv->_direction = PA_DIRECTION_INPUT;
	self->priv->_is_default = FALSE;
	self->priv->_is_priority = FALSE;
}

static void
sound_device_finalize (GObject * obj)
{
	SoundDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_DEVICE, SoundDevice);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_port_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_form_factor);
	_g_free0 (self->priv->_icon_name);
	_g_object_unref0 (self->priv->_profiles);
	_g_free0 (self->priv->_card_active_profile_name);
	_g_free0 (self->priv->_sink_name);
	_g_free0 (self->priv->_card_sink_name);
	_g_free0 (self->priv->_card_sink_port_name);
	_g_free0 (self->priv->_source_name);
	_g_free0 (self->priv->_card_source_name);
	_g_free0 (self->priv->_card_source_port_name);
	G_OBJECT_CLASS (sound_device_parent_class)->finalize (obj);
}

static GType
sound_device_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundDevice), 0, (GInstanceInitFunc) sound_device_instance_init, NULL };
	GType sound_device_type_id;
	sound_device_type_id = g_type_register_static (G_TYPE_OBJECT, "SoundDevice", &g_define_type_info, 0);
	SoundDevice_private_offset = g_type_add_instance_private (sound_device_type_id, sizeof (SoundDevicePrivate));
	return sound_device_type_id;
}

GType
sound_device_get_type (void)
{
	static volatile gsize sound_device_type_id__once = 0;
	if (g_once_init_enter (&sound_device_type_id__once)) {
		GType sound_device_type_id;
		sound_device_type_id = sound_device_get_type_once ();
		g_once_init_leave (&sound_device_type_id__once, sound_device_type_id);
	}
	return sound_device_type_id__once;
}

static void
_vala_sound_device_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SoundDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_DEVICE, SoundDevice);
	switch (property_id) {
		case SOUND_DEVICE_DIRECTION_PROPERTY:
		g_value_set_uint (value, sound_device_get_direction (self));
		break;
		case SOUND_DEVICE_ID_PROPERTY:
		g_value_set_string (value, sound_device_get_id (self));
		break;
		case SOUND_DEVICE_CARD_INDEX_PROPERTY:
		g_value_set_uint (value, sound_device_get_card_index (self));
		break;
		case SOUND_DEVICE_PORT_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_port_name (self));
		break;
		case SOUND_DEVICE_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_display_name (self));
		break;
		case SOUND_DEVICE_FORM_FACTOR_PROPERTY:
		g_value_set_string (value, sound_device_get_form_factor (self));
		break;
		case SOUND_DEVICE_ICON_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_icon_name (self));
		break;
		case SOUND_DEVICE_PROFILES_PROPERTY:
		g_value_set_object (value, sound_device_get_profiles (self));
		break;
		case SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_active_profile_name (self));
		break;
		case SOUND_DEVICE_SINK_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_sink_name (self));
		break;
		case SOUND_DEVICE_SINK_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_sink_index (self));
		break;
		case SOUND_DEVICE_CARD_SINK_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_sink_name (self));
		break;
		case SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_sink_port_name (self));
		break;
		case SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_card_sink_index (self));
		break;
		case SOUND_DEVICE_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_source_name (self));
		break;
		case SOUND_DEVICE_SOURCE_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_source_index (self));
		break;
		case SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_source_name (self));
		break;
		case SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY:
		g_value_set_string (value, sound_device_get_card_source_port_name (self));
		break;
		case SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY:
		g_value_set_int (value, sound_device_get_card_source_index (self));
		break;
		case SOUND_DEVICE_IS_DEFAULT_PROPERTY:
		g_value_set_boolean (value, sound_device_get_is_default (self));
		break;
		case SOUND_DEVICE_IS_PRIORITY_PROPERTY:
		g_value_set_boolean (value, sound_device_get_is_priority (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_device_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SoundDevice * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_DEVICE, SoundDevice);
	switch (property_id) {
		case SOUND_DEVICE_DIRECTION_PROPERTY:
		sound_device_set_direction (self, g_value_get_uint (value));
		break;
		case SOUND_DEVICE_ID_PROPERTY:
		sound_device_set_id (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_INDEX_PROPERTY:
		sound_device_set_card_index (self, g_value_get_uint (value));
		break;
		case SOUND_DEVICE_PORT_NAME_PROPERTY:
		sound_device_set_port_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_DISPLAY_NAME_PROPERTY:
		sound_device_set_display_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_FORM_FACTOR_PROPERTY:
		sound_device_set_form_factor (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_ICON_NAME_PROPERTY:
		sound_device_set_icon_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_PROFILES_PROPERTY:
		sound_device_set_profiles (self, g_value_get_object (value));
		break;
		case SOUND_DEVICE_CARD_ACTIVE_PROFILE_NAME_PROPERTY:
		sound_device_set_card_active_profile_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_SINK_NAME_PROPERTY:
		sound_device_set_sink_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_SINK_INDEX_PROPERTY:
		sound_device_set_sink_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_CARD_SINK_NAME_PROPERTY:
		sound_device_set_card_sink_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SINK_PORT_NAME_PROPERTY:
		sound_device_set_card_sink_port_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SINK_INDEX_PROPERTY:
		sound_device_set_card_sink_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_SOURCE_NAME_PROPERTY:
		sound_device_set_source_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_SOURCE_INDEX_PROPERTY:
		sound_device_set_source_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_CARD_SOURCE_NAME_PROPERTY:
		sound_device_set_card_source_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SOURCE_PORT_NAME_PROPERTY:
		sound_device_set_card_source_port_name (self, g_value_get_string (value));
		break;
		case SOUND_DEVICE_CARD_SOURCE_INDEX_PROPERTY:
		sound_device_set_card_source_index (self, g_value_get_int (value));
		break;
		case SOUND_DEVICE_IS_DEFAULT_PROPERTY:
		sound_device_set_is_default (self, g_value_get_boolean (value));
		break;
		case SOUND_DEVICE_IS_PRIORITY_PROPERTY:
		sound_device_set_is_priority (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

