// java wrapper for vtkGenericStreamTracer object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGenericStreamTracer.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGenericStreamTracer_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGenericStreamTracer",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericStreamTracer_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericStreamTracer_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetStartPosition_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPosition(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetStartPosition_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPosition(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGenericStreamTracer_GetStartPosition_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartPosition();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetSourceData_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericStreamTracer_GetSource_18(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSource();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetSourceConnection_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceConnection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_FillInputPortInformation_110(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkInformation * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FillInputPortInformation(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegrator_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInitialValueProblemSolver * temp0;
  temp0 = static_cast<vtkInitialValueProblemSolver*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrator(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericStreamTracer_GetIntegrator_112(JNIEnv* env, jobject obj)
{
  vtkInitialValueProblemSolver * temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrator();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegratorType_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetIntegratorType_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegratorType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegratorTypeToRungeKutta2_115(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorTypeToRungeKutta2();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegratorTypeToRungeKutta4_116(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorTypeToRungeKutta4();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegratorTypeToRungeKutta45_117(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegratorTypeToRungeKutta45();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumPropagation_118(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagation(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumPropagation_119(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagation(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumPropagationUnit_120(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagationUnit(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetMaximumPropagationUnit_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPropagationUnit();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetMaximumPropagation_122(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumPropagation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumPropagationUnitToTimeUnit_123(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagationUnitToTimeUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumPropagationUnitToLengthUnit_124(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagationUnitToLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumPropagationUnitToCellLengthUnit_125(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumPropagationUnitToCellLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMinimumIntegrationStep_126(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStep(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMinimumIntegrationStepUnit_127(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStepUnit(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMinimumIntegrationStep_128(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetMinimumIntegrationStepUnit_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumIntegrationStepUnit();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetMinimumIntegrationStep_130(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinimumIntegrationStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMinimumIntegrationStepUnitToTimeUnit_131(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStepUnitToTimeUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMinimumIntegrationStepUnitToLengthUnit_132(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStepUnitToLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMinimumIntegrationStepUnitToCellLengthUnit_133(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMinimumIntegrationStepUnitToCellLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumIntegrationStep_134(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStep(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumIntegrationStepUnit_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStepUnit(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumIntegrationStep_136(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetMaximumIntegrationStepUnit_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumIntegrationStepUnit();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetMaximumIntegrationStep_138(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumIntegrationStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumIntegrationStepUnitToTimeUnit_139(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStepUnitToTimeUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumIntegrationStepUnitToLengthUnit_140(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStepUnitToLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumIntegrationStepUnitToCellLengthUnit_141(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumIntegrationStepUnitToCellLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInitialIntegrationStep_142(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStep(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInitialIntegrationStepUnit_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStepUnit(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInitialIntegrationStep_144(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStep(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetInitialIntegrationStepUnit_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInitialIntegrationStepUnit();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetInitialIntegrationStep_146(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInitialIntegrationStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInitialIntegrationStepUnitToTimeUnit_147(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStepUnitToTimeUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInitialIntegrationStepUnitToLengthUnit_148(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStepUnitToLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInitialIntegrationStepUnitToCellLengthUnit_149(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInitialIntegrationStepUnitToCellLengthUnit();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumError_150(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumError(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetMaximumError_151(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumError();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetMaximumNumberOfSteps_152(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumNumberOfSteps(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGenericStreamTracer_GetMaximumNumberOfSteps_153(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumNumberOfSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetTerminalSpeed_154(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTerminalSpeed(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetTerminalSpeed_155(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTerminalSpeed();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegrationStepUnit_156(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationStepUnit(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegrationDirection_157(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirection(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetIntegrationDirectionMinValue_158(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirectionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetIntegrationDirectionMaxValue_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirectionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetIntegrationDirection_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIntegrationDirection();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegrationDirectionToForward_161(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToForward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegrationDirectionToBackward_162(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToBackward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetIntegrationDirectionToBoth_163(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIntegrationDirectionToBoth();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetComputeVorticity_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComputeVorticity(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGenericStreamTracer_GetComputeVorticity_165(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComputeVorticity();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_ComputeVorticityOn_166(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeVorticityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_ComputeVorticityOff_167(JNIEnv* env, jobject obj)
{

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeVorticityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetRotationScale_168(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRotationScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGenericStreamTracer_GetRotationScale_169(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRotationScale();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGenericStreamTracer_GetInputVectorsSelection_170(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInputVectorsSelection();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SelectInputVectors_171(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SelectInputVectors(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_AddInputData_172(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGenericDataSet * temp0;
  temp0 = static_cast<vtkGenericDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddInputData(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGenericStreamTracer_SetInterpolatorPrototype_173(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGenericInterpolatedVelocityField * temp0;
  temp0 = static_cast<vtkGenericInterpolatedVelocityField*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGenericStreamTracer* op = static_cast<vtkGenericStreamTracer*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolatorPrototype(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGenericStreamTracer_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGenericStreamTracer::New());
}
