// python wrapper for vtkExternalLight
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkExternalLight.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkExternalLight(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkExternalLight_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExternalLight_ReplaceModes_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingExternal.vtkExternalLight.ReplaceModes", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkExternalLight_ReplaceModes_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkExternalLight_ReplaceModes_Type, static_cast<int>(val));
}


static PyObject *
PyvtkExternalLight_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkExternalLight::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkExternalLight::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkExternalLight *tempr = vtkExternalLight::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkExternalLight *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkExternalLight::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkExternalLight::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkExternalLight::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SetLightIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLightIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLightIndex(temp0);
    }
    else
    {
      op->vtkExternalLight::SetLightIndex(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetLightIndex(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLightIndex");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLightIndex() :
      op->vtkExternalLight::GetLightIndex());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SetReplaceMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReplaceMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReplaceMode(temp0);
    }
    else
    {
      op->vtkExternalLight::SetReplaceMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetReplaceMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReplaceMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReplaceMode() :
      op->vtkExternalLight::GetReplaceMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SetPosition_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExternalLight::SetPosition(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetPosition_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0);
    }
    else
    {
      op->vtkExternalLight::SetPosition(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetPosition(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExternalLight_SetPosition_s1(self, args);
    case 1:
      return PyvtkExternalLight_SetPosition_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetPosition");
  return nullptr;
}


static PyObject *
PyvtkExternalLight_SetFocalPoint_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetFocalPoint(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExternalLight::SetFocalPoint(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetFocalPoint_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFocalPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetFocalPoint(temp0);
    }
    else
    {
      op->vtkExternalLight::SetFocalPoint(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetFocalPoint(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExternalLight_SetFocalPoint_s1(self, args);
    case 1:
      return PyvtkExternalLight_SetFocalPoint_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetFocalPoint");
  return nullptr;
}


static PyObject *
PyvtkExternalLight_SetAmbientColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbientColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAmbientColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExternalLight::SetAmbientColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetAmbientColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAmbientColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetAmbientColor(temp0);
    }
    else
    {
      op->vtkExternalLight::SetAmbientColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetAmbientColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExternalLight_SetAmbientColor_s1(self, args);
    case 1:
      return PyvtkExternalLight_SetAmbientColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetAmbientColor");
  return nullptr;
}


static PyObject *
PyvtkExternalLight_SetDiffuseColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDiffuseColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetDiffuseColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExternalLight::SetDiffuseColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetDiffuseColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDiffuseColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetDiffuseColor(temp0);
    }
    else
    {
      op->vtkExternalLight::SetDiffuseColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetDiffuseColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExternalLight_SetDiffuseColor_s1(self, args);
    case 1:
      return PyvtkExternalLight_SetDiffuseColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetDiffuseColor");
  return nullptr;
}


static PyObject *
PyvtkExternalLight_SetSpecularColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSpecularColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExternalLight::SetSpecularColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetSpecularColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSpecularColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSpecularColor(temp0);
    }
    else
    {
      op->vtkExternalLight::SetSpecularColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetSpecularColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExternalLight_SetSpecularColor_s1(self, args);
    case 1:
      return PyvtkExternalLight_SetSpecularColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSpecularColor");
  return nullptr;
}


static PyObject *
PyvtkExternalLight_SetIntensity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIntensity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIntensity(temp0);
    }
    else
    {
      op->vtkExternalLight::SetIntensity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SetConeAngle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetConeAngle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetConeAngle(temp0);
    }
    else
    {
      op->vtkExternalLight::SetConeAngle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SetAttenuationValues_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAttenuationValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetAttenuationValues(temp0, temp1, temp2);
    }
    else
    {
      op->vtkExternalLight::SetAttenuationValues(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetAttenuationValues_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAttenuationValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetAttenuationValues(temp0);
    }
    else
    {
      op->vtkExternalLight::SetAttenuationValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkExternalLight_SetAttenuationValues(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkExternalLight_SetAttenuationValues_s1(self, args);
    case 1:
      return PyvtkExternalLight_SetAttenuationValues_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetAttenuationValues");
  return nullptr;
}


static PyObject *
PyvtkExternalLight_SetExponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExponent(temp0);
    }
    else
    {
      op->vtkExternalLight::SetExponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_SetPositional(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPositional");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPositional(temp0);
    }
    else
    {
      op->vtkExternalLight::SetPositional(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetPositionSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPositionSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPositionSet() :
      op->vtkExternalLight::GetPositionSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetFocalPointSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFocalPointSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetFocalPointSet() :
      op->vtkExternalLight::GetFocalPointSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetAmbientColorSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAmbientColorSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAmbientColorSet() :
      op->vtkExternalLight::GetAmbientColorSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetDiffuseColorSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDiffuseColorSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetDiffuseColorSet() :
      op->vtkExternalLight::GetDiffuseColorSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetSpecularColorSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSpecularColorSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSpecularColorSet() :
      op->vtkExternalLight::GetSpecularColorSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetIntensitySet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIntensitySet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetIntensitySet() :
      op->vtkExternalLight::GetIntensitySet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetConeAngleSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetConeAngleSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetConeAngleSet() :
      op->vtkExternalLight::GetConeAngleSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetAttenuationValuesSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAttenuationValuesSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAttenuationValuesSet() :
      op->vtkExternalLight::GetAttenuationValuesSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetExponentSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExponentSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExponentSet() :
      op->vtkExternalLight::GetExponentSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkExternalLight_GetPositionalSet(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPositionalSet");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkExternalLight *op = static_cast<vtkExternalLight *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetPositionalSet() :
      op->vtkExternalLight::GetPositionalSet());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkExternalLight_Methods[] = {
  {"IsTypeOf", PyvtkExternalLight_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkExternalLight_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkExternalLight_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkExternalLight\nC++: static vtkExternalLight *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkExternalLight_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkExternalLight\nC++: vtkExternalLight *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkExternalLight_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkExternalLight_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetLightIndex", PyvtkExternalLight_SetLightIndex, METH_VARARGS,
   "SetLightIndex(self, _arg:int) -> None\nC++: virtual void SetLightIndex(int _arg)\n\nSet/Get light index This should be the OpenGL light identifier.\n(e.g.: GL_LIGHT0) (Default: GL_LIGHT0)\n"},
  {"GetLightIndex", PyvtkExternalLight_GetLightIndex, METH_VARARGS,
   "GetLightIndex(self) -> int\nC++: virtual int GetLightIndex()\n\n"},
  {"SetReplaceMode", PyvtkExternalLight_SetReplaceMode, METH_VARARGS,
   "SetReplaceMode(self, _arg:int) -> None\nC++: virtual void SetReplaceMode(int _arg)\n\nSet/Get replace mode This determines how this ExternalLight will\nbe used to tweak parameters on an existing light in the rendering\ncontext. (Default: INDIVIDUAL_PARAMS)\n\n* \\li vtkExternalLight::INDIVIDUAL_PARAMS : Replace parameters\n* specifically set by the user by calling the parameter\n* Set method. (e.g. SetDiffuseColor())\n\n* \\li vtkExternalLight::ALL_PARAMS : Replace all\n* parameters of the light with the parameters in vtkExternalLight\nobject.\n"},
  {"GetReplaceMode", PyvtkExternalLight_GetReplaceMode, METH_VARARGS,
   "GetReplaceMode(self) -> int\nC++: virtual int GetReplaceMode()\n\n"},
  {"SetPosition", PyvtkExternalLight_SetPosition, METH_VARARGS,
   "SetPosition(self, __a:float, __b:float, __c:float) -> None\nC++: void SetPosition(double, double, double) override;\nSetPosition(self, _arg:(float, float, float)) -> None\nC++: virtual void SetPosition(const double _arg[3])\n\nOverride Set method to keep a record of changed value\n"},
  {"SetFocalPoint", PyvtkExternalLight_SetFocalPoint, METH_VARARGS,
   "SetFocalPoint(self, __a:float, __b:float, __c:float) -> None\nC++: void SetFocalPoint(double, double, double) override;\nSetFocalPoint(self, _arg:(float, float, float)) -> None\nC++: virtual void SetFocalPoint(const double _arg[3])\n\nOverride Set method to keep a record of changed value\n"},
  {"SetAmbientColor", PyvtkExternalLight_SetAmbientColor, METH_VARARGS,
   "SetAmbientColor(self, __a:float, __b:float, __c:float) -> None\nC++: void SetAmbientColor(double, double, double) override;\nSetAmbientColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetAmbientColor(const double _arg[3])\n\nOverride Set method to keep a record of changed value\n"},
  {"SetDiffuseColor", PyvtkExternalLight_SetDiffuseColor, METH_VARARGS,
   "SetDiffuseColor(self, __a:float, __b:float, __c:float) -> None\nC++: void SetDiffuseColor(double, double, double) override;\nSetDiffuseColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetDiffuseColor(const double _arg[3])\n\nOverride Set method to keep a record of changed value\n"},
  {"SetSpecularColor", PyvtkExternalLight_SetSpecularColor, METH_VARARGS,
   "SetSpecularColor(self, __a:float, __b:float, __c:float) -> None\nC++: void SetSpecularColor(double, double, double) override;\nSetSpecularColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSpecularColor(const double _arg[3])\n\nOverride Set method to keep a record of changed value\n"},
  {"SetIntensity", PyvtkExternalLight_SetIntensity, METH_VARARGS,
   "SetIntensity(self, __a:float) -> None\nC++: void SetIntensity(double) override;\n\nOverride Set method to keep a record of changed value\n"},
  {"SetConeAngle", PyvtkExternalLight_SetConeAngle, METH_VARARGS,
   "SetConeAngle(self, __a:float) -> None\nC++: void SetConeAngle(double) override;\n\nOverride Set method to keep a record of changed value\n"},
  {"SetAttenuationValues", PyvtkExternalLight_SetAttenuationValues, METH_VARARGS,
   "SetAttenuationValues(self, __a:float, __b:float, __c:float)\n    -> None\nC++: void SetAttenuationValues(double, double, double) override;\nSetAttenuationValues(self, _arg:(float, float, float)) -> None\nC++: virtual void SetAttenuationValues(const double _arg[3])\n\nOverride Set method to keep a record of changed value\n"},
  {"SetExponent", PyvtkExternalLight_SetExponent, METH_VARARGS,
   "SetExponent(self, __a:float) -> None\nC++: void SetExponent(double) override;\n\nOverride Set method to keep a record of changed value\n"},
  {"SetPositional", PyvtkExternalLight_SetPositional, METH_VARARGS,
   "SetPositional(self, __a:int) -> None\nC++: void SetPositional(vtkTypeBool) override;\n\nOverride Set method to keep a record of changed value\n"},
  {"GetPositionSet", PyvtkExternalLight_GetPositionSet, METH_VARARGS,
   "GetPositionSet(self) -> bool\nC++: virtual bool GetPositionSet()\n\nCheck whether value set by user\n"},
  {"GetFocalPointSet", PyvtkExternalLight_GetFocalPointSet, METH_VARARGS,
   "GetFocalPointSet(self) -> bool\nC++: virtual bool GetFocalPointSet()\n\nCheck whether value set by user\n"},
  {"GetAmbientColorSet", PyvtkExternalLight_GetAmbientColorSet, METH_VARARGS,
   "GetAmbientColorSet(self) -> bool\nC++: virtual bool GetAmbientColorSet()\n\nCheck whether value set by user\n"},
  {"GetDiffuseColorSet", PyvtkExternalLight_GetDiffuseColorSet, METH_VARARGS,
   "GetDiffuseColorSet(self) -> bool\nC++: virtual bool GetDiffuseColorSet()\n\nCheck whether value set by user\n"},
  {"GetSpecularColorSet", PyvtkExternalLight_GetSpecularColorSet, METH_VARARGS,
   "GetSpecularColorSet(self) -> bool\nC++: virtual bool GetSpecularColorSet()\n\nCheck whether value set by user\n"},
  {"GetIntensitySet", PyvtkExternalLight_GetIntensitySet, METH_VARARGS,
   "GetIntensitySet(self) -> bool\nC++: virtual bool GetIntensitySet()\n\nCheck whether value set by user\n"},
  {"GetConeAngleSet", PyvtkExternalLight_GetConeAngleSet, METH_VARARGS,
   "GetConeAngleSet(self) -> bool\nC++: virtual bool GetConeAngleSet()\n\nCheck whether value set by user\n"},
  {"GetAttenuationValuesSet", PyvtkExternalLight_GetAttenuationValuesSet, METH_VARARGS,
   "GetAttenuationValuesSet(self) -> bool\nC++: virtual bool GetAttenuationValuesSet()\n\nCheck whether value set by user\n"},
  {"GetExponentSet", PyvtkExternalLight_GetExponentSet, METH_VARARGS,
   "GetExponentSet(self) -> bool\nC++: virtual bool GetExponentSet()\n\nCheck whether value set by user\n"},
  {"GetPositionalSet", PyvtkExternalLight_GetPositionalSet, METH_VARARGS,
   "GetPositionalSet(self) -> bool\nC++: virtual bool GetPositionalSet()\n\nCheck whether value set by user\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkExternalLight_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("light_index"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetLightIndex(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetLightIndex(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetLightIndex(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLightIndex/SetLightIndex\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("replace_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetReplaceMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetReplaceMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetReplaceMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReplaceMode/SetReplaceMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("focal_point"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetFocalPoint(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetFocalPoint(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetFocalPoint\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ambient_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetAmbientColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetAmbientColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAmbientColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("diffuse_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetDiffuseColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetDiffuseColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetDiffuseColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetSpecularColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetSpecularColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSpecularColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("intensity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetIntensity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetIntensity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetIntensity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cone_angle"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetConeAngle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetConeAngle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetConeAngle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("attenuation_values"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetAttenuationValues(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetAttenuationValues(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAttenuationValues\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exponent"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetExponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetExponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetExponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("positional"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkExternalLight_SetPositional(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkExternalLight_SetPositional(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetPositional\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetPositionSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPositionSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("focal_point_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetFocalPointSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFocalPointSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ambient_color_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetAmbientColorSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAmbientColorSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("diffuse_color_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetDiffuseColorSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDiffuseColorSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("specular_color_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetSpecularColorSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSpecularColorSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("intensity_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetIntensitySet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetIntensitySet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cone_angle_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetConeAngleSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetConeAngleSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("attenuation_values_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetAttenuationValuesSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetAttenuationValuesSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("exponent_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetExponentSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetExponentSet\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("positional_set"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkExternalLight_GetPositionalSet(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPositionalSet\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkExternalLight_Doc =
  "vtkExternalLight - a virtual light object for tweaking existing\nlights in an external 3D rendering context\n\n"
  "Superclass: vtkLight\n\n"
  "vtkExternalLight is a virtual light object for tweaking existing\n"
  "lights in an external 3D rendering context. It provides a mechanism\n"
  "to adjust and control parameters of existing lights in an external\n"
  "OpenGL context.\n\n"
  "It provides methods to locate and point the light, and set its\n"
  "brightness and color. In addition to the basic infinite distance\n"
  "point light source attributes, you can also specify the light\n"
  "attenuation values and cone angle. These attributes are only used if\n"
  "the light is a positional light.\n\n"
  "By default, vtkExternalLight overrides specific light parameters as\n"
  "set by the user. Setting the #ReplaceMode to ALL_PARAMS, will set all\n"
  "the light parameter values to the ones set in vtkExternalLight.\n\n"
  "@warning\n"
  "Use the vtkExternalLight object to tweak parameters of lights created\n"
  "in the external context. This class does NOT create new lights in the\n"
  "scene.\n\n"
  "@par Example: Usage example for vtkExternalLight in conjunction with\n"
  "vtkExternalOpenGLRenderer and \\ref ExternalVTKWidget{.cpp}\n"
  "   vtkNewexLight;\n"
  "   exLight->SetLightIndex(GL_LIGHT0); // GL_LIGHT0 identifies the\n"
  "external light\n"
  "   exLight->SetDiffuseColor(1.0, 0.0, 0.0); // Changing diffuse color\n"
  "   vtkNewexWidget;\n"
  "   vtkExternalOpenGLRenderer* ren =\n"
  "vtkExternalOpenGLRenderer::SafeDownCast(exWidget->AddRenderer());\n"
  "   ren->AddExternalLight(exLight.GetPointer());\n\n"
  "@sa\n"
  "vtkExternalOpenGLRenderer \\ref ExternalVTKWidget\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkExternalLight_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRenderingExternal.vtkExternalLight", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkExternalLight_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkExternalLight_StaticNew()
{
  return vtkExternalLight::New();
}

PyObject *PyvtkExternalLight_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkExternalLight_Type, PyvtkExternalLight_Methods,
    "vtkExternalLight",
 &PyvtkExternalLight_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkLight");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkExternalLight_ReplaceModes_Type);
  PyVTKEnum_Add(&PyvtkExternalLight_ReplaceModes_Type, "vtkExternalLight.ReplaceModes");

  o = (PyObject *)&PyvtkExternalLight_ReplaceModes_Type;
  if (PyDict_SetItemString(d, "ReplaceModes", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 2; c++)
  {
    typedef vtkExternalLight::ReplaceModes cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[2] = {
        { "INDIVIDUAL_PARAMS", vtkExternalLight::INDIVIDUAL_PARAMS },
        { "ALL_PARAMS", vtkExternalLight::ALL_PARAMS },
      };

    o = PyvtkExternalLight_ReplaceModes_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkExternalLight_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkExternalLight(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkExternalLight_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkExternalLight", o) != 0)
  {
    Py_DECREF(o);
  }

}

