/** @file
 * VirtualBox API class wrapper code for IDataStream.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_DATASTREAM

#include "DataStreamWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(DataStreamWrap)

//
// IDataStream properties
//

STDMETHODIMP DataStreamWrap::COMGETTER(ReadSize)(ULONG *aReadSize)
{
    LogRelFlow(("{%p} %s: enter aReadSize=%p\n", this, "DataStream::getReadSize", aReadSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReadSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_GET_READSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getReadSize(aReadSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_GET_READSIZE_RETURN(this, hrc, 0 /*normal*/,*aReadSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_GET_READSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aReadSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_GET_READSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aReadSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aReadSize=%RU32 hrc=%Rhrc\n", this, "DataStream::getReadSize", *aReadSize, hrc));
    return hrc;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute1IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute2IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute3IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute4IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute5IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute6IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute7IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::COMGETTER(InternalAndReservedAttribute8IDataStream)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IDataStream methods
//

STDMETHODIMP DataStreamWrap::Read(ULONG aSize,
                                  ULONG aTimeoutMS,
                                  ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aSize=%RU32 aTimeoutMS=%RU32 aData=%p\n", this, "DataStream::read", aSize, aTimeoutMS, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_READ_ENTER(this, aSize, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(aSize,
                       aTimeoutMS,
                       TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_READ_RETURN(this, hrc, 0 /*normal*/, aSize, aTimeoutMS, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_READ_RETURN(this, hrc, 1 /*hrc exception*/, aSize, aTimeoutMS, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_DATASTREAM_READ_RETURN(this, hrc, 9 /*unhandled exception*/, aSize, aTimeoutMS, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "DataStream::read", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP DataStreamWrap::InternalAndReservedMethod1IDataStream()
{
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::InternalAndReservedMethod2IDataStream()
{
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::InternalAndReservedMethod3IDataStream()
{
    return E_NOTIMPL;
}

STDMETHODIMP DataStreamWrap::InternalAndReservedMethod4IDataStream()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(DataStreamWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(DataStreamWrap, IDataStream)
#endif // VBOX_WITH_XPCOM
