#include "AbortControllerBinding.h"
#include "AbortSignalBinding.h"
#include "CompressionStreamBinding.h"
#include "DecompressionStreamBinding.h"
#include "EventTargetBinding.h"
#include "QueuingStrategyBinding.h"
#include "ReadableByteStreamControllerBinding.h"
#include "ReadableStreamBYOBReaderBinding.h"
#include "ReadableStreamBYOBRequestBinding.h"
#include "ReadableStreamBinding.h"
#include "ReadableStreamDefaultControllerBinding.h"
#include "ReadableStreamDefaultReaderBinding.h"
#include "StructuredCloneHolderBinding.h"
#include "TextDecoderStreamBinding.h"
#include "TextEncoderStreamBinding.h"
#include "TransformStreamBinding.h"
#include "TransformStreamDefaultControllerBinding.h"
#include "WritableStreamBinding.h"
#include "WritableStreamDefaultControllerBinding.h"
#include "WritableStreamDefaultWriterBinding.h"

namespace mozilla::dom {
bool
RegisterShadowRealmBindings(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  if (!AbortController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!AbortSignal_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ByteLengthQueuingStrategy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CompressionStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!CountQueuingStrategy_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!DecompressionStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!EventTarget_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableByteStreamController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamBYOBReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamBYOBRequest_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!ReadableStreamDefaultReader_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (StructuredCloneHolder_Binding::ConstructorEnabled(aCx, aObj) && !StructuredCloneHolder_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextDecoderStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TextEncoderStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TransformStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!TransformStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStream_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStreamDefaultController_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  if (!WritableStreamDefaultWriter_Binding::CreateAndDefineOnGlobal(aCx)) {
    return false;
  }

  return true;
}

} // namespace mozilla::dom

